/*
***************************************************************************
*
* Author: Teunis van Beelen
*
* Copyright (C) 2007, 2008, 2009, 2010, 2011 Teunis van Beelen
*
* teuniz@gmail.com
*
***************************************************************************
*
* This program is free software; you can redistribute it and/or modify
* it under the terms of the GNU General Public License as published by
* the Free Software Foundation version 2 of the License.
*
* This program is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
* GNU General Public License for more details.
*
* You should have received a copy of the GNU General Public License along
* with this program; if not, write to the Free Software Foundation, Inc.,
* 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA.
*
***************************************************************************
*
* This version of GPL is at http://www.gnu.org/licenses/old-licenses/gpl-2.0.txt
*
***************************************************************************
*/



#ifndef VIEWCURVE_H
#define VIEWCURVE_H

#include <QWidget>
#include <QPainter>
#include <QMouseEvent>
#include <QDialog>
#include <QPushButton>
#include <QDoubleSpinBox>
#include <QComboBox>
#include <QLabel>
#include <QPrinter>
#include <QPixmap>
#include <QPrintDialog>
#include <QColor>
#include <QPen>
#include <QMessageBox>

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <math.h>

#include "global.h"
#include "mainwindow.h"
#include "colordialog.h"
#include "filter.h"
#include "popup_messagewindow.h"
#include "spectrumanalyzer.h"
#include "utils.h"
#include "adjustfiltersettings.h"
#include "ravg_filter.h"
#include "ecg_filter.h"
#include "statistics_dialog.h"

#include "fidlib/fidlib.h"



class UI_Mainwindow;




class ViewCurve : public QWidget
{
  Q_OBJECT

public:
  ViewCurve(QWidget *parent=0);
  ~ViewCurve();

  UI_Mainwindow *mainwindow;

  int use_move_events,
      mouse_x,
      mouse_y,
      mouse_old_x,
      mouse_old_y,
      sidemenu_active,
      signal_nr,
      mouse_press_coordinate_x,
      mouse_press_coordinate_y,
      draw_zoom_rectangle,
      signal_color,
      crosshair_1_color,
      crosshair_2_color,
      floating_ruler_color,
      crosshair_1_file_num,
      crosshair_2_file_num,
      crosshair_1_active,
      crosshair_2_active,
      ruler_active,
      crosshair_1_moving,
      crosshair_2_moving,
      ruler_moving,
      crosshair_1_x_position,
      crosshair_2_x_position,
      ruler_x_position,
      crosshair_1_y_position,
      crosshair_2_y_position,
      ruler_y_position,
      crosshair_1_y_value,
      crosshair_2_y_value,
      *screensamples,
      graphicBufWidth,
      blackwhite_printing,
      backup_color_10[MAXSIGNALS],
      backup_color_11,
      backup_color_12,
      backup_color_14,
      annot_marker_moving,
      pressed_on_label,
      label_press_y_position;


  double crosshair_1_value,
         crosshair_2_value,
         original_screen_offset;

  long long crosshair_1_time,
            crosshair_2_time,
            crosshair_1_time_relative,
            crosshair_2_time_relative;

  struct graphicLineStruct{
          int x1;
          int y1;
          int x2;
          int y2;
         };

  struct graphicBufStruct{
          graphicLineStruct graphicLine[MAXSIGNALS];
         };

  struct graphicBufStruct *graphicBuf,
                          *printBuf;

  struct active_markersblock *active_markers;

  QColor backgroundcolor,
         small_ruler_color,
         big_ruler_color,
         mouse_rect_color,
         baseline_color,
         text_color,
         annot_marker_color,
         backup_color_1,
         backup_color_2,
         backup_color_3,
         backup_color_4,
         backup_color_5,
         backup_color_13,
         backup_color_15;

  QFont *printfont;

  void drawCurve_stage_1(QPainter *painter=NULL, int w_width=0, int w_height=0);
  void setCrosshair_1_center(void);


public slots:

  void exec_sidemenu(int);
  void print_to_postscript();
  void print_to_pdf();
  void print_to_image(int, int);
  void print_to_printer();


private:

  QDialog     *sidemenu;

  QPushButton *sidemenuButton1,
              *sidemenuButton2,
              *sidemenuButton3,
              *sidemenuButton4,
              *sidemenuButton5,
              *sidemenuButton6,
              *sidemenuButton7,
              *sidemenuButton8,
              *sidemenuButton9,
              *sidemenuButton10,
              *sidemenuButton11,
              *sidemenuButton12;

  QDoubleSpinBox *ScaleBox,
                 *ScaleBox2;

  QLabel      *SidemenuLabel,
              *AmpLabel,
              *OffsetLabel;

  QPrinter    *printer;

  QPen        *special_pen,
              *annot_marker_pen;

  int         printing,
              w,
              h,
              floating_ruler_value;

  double      *original_sensitivity,
              painter_pixelsizefactor,
              printsize_x_factor,
              printsize_y_factor;


  inline void floating_ruler(QPainter *, int, int, struct signalcompblock *);

  void backup_colors_for_printing(void);
  void restore_colors_after_printing(void);

protected slots:

  void RulerButton();
  void FittopaneButton();
  void ScaleBoxChanged(double);
  void ScaleBox2Changed(double);
  void RemovefilterButton();
  void RemovesignalButton();
  void ColorButton();
  void CrosshairButton();
  void FreqSpecButton();
  void AdjustFilterButton();
  void StatisticsButton();
  void ECGdetectButton();
  void signalInvert();
  void strip_types_from_label(char *);

protected:
  void paintEvent(QPaintEvent *);
  void resizeEvent(QResizeEvent *);
  void drawCurve_stage_2(QPainter *painter, int w_width=0, int w_height=0);
  void mousePressEvent(QMouseEvent *);
  void mouseReleaseEvent(QMouseEvent *);
  void mouseMoveEvent(QMouseEvent *);
  void wheelEvent(QWheelEvent *);

};


#endif


