/*
 * Copyright © 2009 Tim Horton <hortont424@gmail.com>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

Gtk = imports.gi.Gtk;
Gdk = imports.gi.Gdk;
WebKit = imports.gi.WebKit;
Epiphany = imports.gi.Epiphany;

var last_closed_urls = [ ];

var key_pressed = function (window, event)
{
	if(event.key.state & Gdk.ModifierType.CONTROL_MASK &&
	   event.key.state & Gdk.ModifierType.SHIFT_MASK)
	{
		if(event.key.keyval == Gdk.T)
		{
			var embed = window.get_active_child();
			var shell = Epiphany.EphyShell.get_default();
			var new_url = last_closed_urls.pop();
			
			if(new_url != null)
				var new_tab = new Epiphany.EphyShell.tab(shell, window, embed,
								new_url,
								Epiphany.EphyNewTabFlags.OPEN_PAGE |
								Epiphany.EphyNewTabFlags.IN_EXISTING_WINDOW |
								Epiphany.EphyNewTabFlags.JUMP);
		}
	}
	
	return false;
}

extension = {
	attach_tab: function(window, tab)
	{
	
	},
	detach_tab: function(window, tab)
	{
		var embed;
		
		if(tab.get_embed != null)
			embed = tab.get_embed();
		else
			embed = tab;
		
		last_closed_urls.push(embed.get_web_view().get_location());
	},
	attach_window: function(window)
	{
		window.signal.key_press_event.connect(key_pressed);
	},
	detach_window: function(window)
	{

	}
}
