/* GADMIN-DHCPD - An easy to use GTK+ frontend for ISC DHCPD.
 * Copyright (C) 2004 - 2008 Magnus Loef <magnus-swe@telia.com> 
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * See the GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License along
 * with this program; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 *
*/


#include <gtk/gtk.h>
#include "widgets.h"
#include "functions.h"
#include "populate_scope_treeview.h"
#include "select_first_scope.h"
#include "set_num_ranges.h"
#include "populate_ranges.h"
#include "populate_scope_settings.h"
#include "populate_leases.h"

extern char global_netmask[1024];
extern char global_subnet[1024];
extern char global_nic[1024];

extern char DHCPD_CONF_BUF[1024];


void add_conf_button_clicked(struct w *widgets)
{
    gtk_widget_destroy(widgets->add_conf_window);

    add_missing_values(DHCPD_CONF_BUF);

    /* Populate the scope treeview */
    populate_scope_treeview(widgets);
    select_first_scope(widgets);

    /* Populate ranges */
    set_num_ranges(global_nic, global_subnet, global_netmask);
    populate_ranges(widgets, global_nic, global_subnet, global_netmask);
    
    /* Populate the settings */
    populate_scope_settings(widgets);

    /* Populate leases */
    populate_leases(widgets);

    gtk_widget_show_all(widgets->main_window);

    /* Dont ReRead here */
}
