/* GADMIN-DHCPD - An easy to use GTK+ frontend for ISC DHCPD.
 * Copyright (C) 2004 - 2009 Magnus Loef <magnus-swe@telia.com> 
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * See the GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License along
 * with this program; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 *
*/



#include <gtk/gtk.h>
#include <stdio.h>
#include <string.h>
#include <stdlib.h>
#include "widgets.h"
#include "gettext.h"
#include "allocate.h"

extern char LEASE_FILE_BUF[1024];


void populate_leases(struct w *widgets)
{
    FILE *fp;
    long conf_size=0;
    char *line, *buffy;
    gchar *utf8=NULL;
    GtkTextBuffer *text_buffer;

    text_buffer = gtk_text_view_get_buffer(GTK_TEXT_VIEW(widgets->leases_textview));
    
    if((fp=fopen(LEASE_FILE_BUF, "r"))==NULL)
    {
        return;
    }
    fseek(fp, 0, SEEK_END);
    conf_size = ftell(fp);
    rewind(fp);

    line = allocate(conf_size+1);
    buffy = allocate(conf_size+1);

    if( conf_size > 1 )
    while(fgets(line, conf_size, fp)!=NULL)
      strcat(buffy, line);

    fclose(fp);
    free(line);

    utf8 = g_locale_to_utf8(buffy, strlen(buffy), NULL, NULL, NULL);
    free(buffy);
    if( utf8!=NULL )
    {
	/* Strlen error on NULL, thats why.. */
        gtk_text_buffer_set_text(text_buffer, utf8, strlen(utf8));
        g_free(utf8);
    }
}
