#ifndef MISC_H
#define MISC_H

/**
 * Logiciel Gassst (Global Alignment Short Sequence Search Tool)
 * \file misc.h
 * \brief Module Misc, contenant des fonctions utilitaires, et de gestion des options et des erreurs
 * \author Dominique Lavenier
 * \author Damien Fleury
 * \version 5.2
 * \date 28/08/2008
 */


#include <iostream>
#include <stdlib.h>
#include <string.h>


/// Variables globales utiles  la gestion des options
/// Elles permettent la mmorisation des options spcifies
char KEY0[64];
char KEY1[64];
char PARAM0[64][64];
char PARAM1[64][64];
extern int  NB_KEY1;
extern int  NB_KEY0;
char PROG_NAME[1024];
extern int NBTHREADS;
extern int MAXHITS;
extern int MAXPOS;
extern int MAXPOS_AMONT;
extern int BESTAL;
extern int SLEVEL;
extern int BITSTAT;
extern int NUMGAPS_AUTO;


/*
 * Fontion minimum de deux valeurs
 * \param a un entier
 * \param b un entier
 * \return la valeur minimale entre a et b
 */
inline int min(int a, int b)
{
	return a < b ? a : b;
}

/*
 * Fontion maximum de deux valeurs
 * \param a un entier
 * \param b un entier
 * \return la valeur maximale entre a et b
 */
inline int max(int a, int b)
{
	return a > b ? a : b; 
}

/**
 * Fonction d'impession d'un message d'erreur et de fermeture du programme
 * \param msg la chane du message d'erreur
 */
void ExitError(char *msg);


/**
 * Fonction d'affichage d'un erreur dans les paramtres du programme et de fermeture du programme
 */
void SyntaxError();


/**
 * Mthode de gnration des diffrentes options du programme
 * \param key le caractre permettant d'identifier l'option
 * \param strg_in le nom de l'option
 * \param opt indique si l'option est obligatoire, 1 si oui, 0 sinon
 */
void option(char key, char *strg_in, int opt);


/**
 * Mthode permettant de vrifier les options spcifies lors de l'excution du programme et d'en rcuprer les paramtres
 * \param key le caractre permettant d'identifier l'option
 * \param strg_out la valeur utilise pour l'option
 * \param argc le nombre de paramtres utiliss lors de l'appel au programme
 * \param argv un pointeur vers le tableau des paramtres du programme
 * \param opt indique si l'option est obligatoire, 1 si oui, 0 sinon
 * \return 1 si l'option a t spcifie, 0 si l'option est facultative et non utilise
 */
int getoption(char key, char *strg_out, int argc, char *argv[], int opt);


/**
 * Mthode de vrification des options
 * \param argc le nombre de paramtres utiliss lors de l'appel au programme
 * \param argv un pointeur vers le tableau des paramtres du programme
 */
void checkoption(int argc, char *argv[]);

#endif
