;; Scheduling description for IBM PowerPC 440 processor.
;;   Copyright (C) 2003, 2004 Free Software Foundation, Inc.
;;
;; This file is part of GCC.
;;
;; GCC is free software; you can redistribute it and/or modify
;; it under the terms of the GNU General Public License as published by
;; the Free Software Foundation; either version 2, or (at your option)
;; any later version.
;;
;; GCC is distributed in the hope that it will be useful,
;; but WITHOUT ANY WARRANTY; without even the implied warranty of
;; MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
;; GNU General Public License for more details.
;;
;; You should have received a copy of the GNU General Public License
;; along with GCC; see the file COPYING.  If not, write to
;; the Free Software Foundation, 51 Franklin Street, Fifth Floor,
;; Boston, MA 02110-1301, USA.

;; PPC440 Embedded PowerPC controller
;; dual issue
;; i_pipe - complex integer / compare / branch
;; j_pipe - simple integer arithmetic
;; l_pipe - load-store
;; f_pipe - floating point arithmetic

(define_automaton "ppc440_core,ppc440_apu")
(define_cpu_unit "ppc440_i_pipe,ppc440_j_pipe,ppc440_l_pipe" "ppc440_core")
(define_cpu_unit "ppc440_f_pipe" "ppc440_apu")
(define_cpu_unit "ppc440_issue_0,ppc440_issue_1" "ppc440_core")

(define_reservation "ppc440_issue" "ppc440_issue_0|ppc440_issue_1")


(define_insn_reservation "ppc440-load" 3
  (and (eq_attr "type" "load,load_ext,load_ext_u,load_ext_ux,load_ux,load_u,\
                        load_l,store_c,sync")
       (eq_attr "cpu" "ppc440"))
  "ppc440_issue,ppc440_l_pipe")

(define_insn_reservation "ppc440-store" 3
  (and (eq_attr "type" "store,store_ux,store_u")
       (eq_attr "cpu" "ppc440"))
  "ppc440_issue,ppc440_l_pipe")

(define_insn_reservation "ppc440-fpload" 4
  (and (eq_attr "type" "fpload,fpload_ux,fpload_u")
       (eq_attr "cpu" "ppc440"))
  "ppc440_issue,ppc440_l_pipe")

(define_insn_reservation "ppc440-fpstore" 3
  (and (eq_attr "type" "fpstore,fpstore_ux,fpstore_u")
       (eq_attr "cpu" "ppc440"))
  "ppc440_issue,ppc440_l_pipe")

(define_insn_reservation "ppc440-integer" 1
  (and (eq_attr "type" "integer,insert_word")
       (eq_attr "cpu" "ppc440"))
  "ppc440_issue,ppc440_i_pipe|ppc440_j_pipe")

(define_insn_reservation "ppc440-two" 1
  (and (eq_attr "type" "two")
       (eq_attr "cpu" "ppc440"))
  "ppc440_issue_0+ppc440_issue_1,\
   ppc440_i_pipe|ppc440_j_pipe,ppc440_i_pipe|ppc440_j_pipe")

(define_insn_reservation "ppc440-three" 1
  (and (eq_attr "type" "three")
       (eq_attr "cpu" "ppc440"))
  "ppc440_issue_0+ppc440_issue_1,ppc440_i_pipe|ppc440_j_pipe,\
   ppc440_i_pipe|ppc440_j_pipe,ppc440_i_pipe|ppc440_j_pipe")

(define_insn_reservation "ppc440-imul" 3
  (and (eq_attr "type" "imul,imul_compare")
       (eq_attr "cpu" "ppc440"))
  "ppc440_issue,ppc440_i_pipe")

(define_insn_reservation "ppc440-imul2" 2
  (and (eq_attr "type" "imul2,imul3")
       (eq_attr "cpu" "ppc440"))
  "ppc440_issue,ppc440_i_pipe")

(define_insn_reservation "ppc440-idiv" 34
  (and (eq_attr "type" "idiv")
       (eq_attr "cpu" "ppc440"))
  "ppc440_issue,ppc440_i_pipe*33")

(define_insn_reservation "ppc440-branch" 1
  (and (eq_attr "type" "branch,jmpreg,isync")
       (eq_attr "cpu" "ppc440"))
  "ppc440_issue,ppc440_i_pipe")

(define_insn_reservation "ppc440-compare" 2
  (and (eq_attr "type" "cmp,fast_compare,compare,cr_logical,delayed_cr,mfcr")
       (eq_attr "cpu" "ppc440"))
  "ppc440_issue,ppc440_i_pipe")

(define_insn_reservation "ppc440-fpcompare" 3 ; 2
  (and (eq_attr "type" "fpcompare")
       (eq_attr "cpu" "ppc440"))
  "ppc440_issue,ppc440_f_pipe+ppc440_i_pipe")

(define_insn_reservation "ppc440-fp" 5
  (and (eq_attr "type" "fp,dmul")
       (eq_attr "cpu" "ppc440"))
  "ppc440_issue,ppc440_f_pipe")

(define_insn_reservation "ppc440-sdiv" 19
  (and (eq_attr "type" "sdiv")
       (eq_attr "cpu" "ppc440"))
  "ppc440_issue,ppc440_f_pipe*15")

(define_insn_reservation "ppc440-ddiv" 33
  (and (eq_attr "type" "ddiv")
       (eq_attr "cpu" "ppc440"))
  "ppc440_issue,ppc440_f_pipe*29")

(define_insn_reservation "ppc440-mtcr" 3
  (and (eq_attr "type" "mtcr")
       (eq_attr "cpu" "ppc440"))
  "ppc440_issue,ppc440_i_pipe")

(define_insn_reservation "ppc440-mtjmpr" 4
  (and (eq_attr "type" "mtjmpr")
       (eq_attr "cpu" "ppc440"))
  "ppc440_issue,ppc440_i_pipe")

(define_insn_reservation "ppc440-mfjmpr" 2
  (and (eq_attr "type" "mfjmpr")
       (eq_attr "cpu" "ppc440"))
  "ppc440_issue,ppc440_i_pipe")

