package GCPlugins::GCboardgames::GCboardgamegeek;

###################################################
#
#  Copyright 2005-2007 Tian
#
#  This file is part of GCstar.
#
#  GCstar is free software; you can redistribute it and/or modify
#  it under the terms of the GNU General Public License as published by
#  the Free Software Foundation; either version 2 of the License, or
#  (at your option) any later version.
#
#  GCstar is distributed in the hope that it will be useful,
#  but WITHOUT ANY WARRANTY; without even the implied warranty of
#  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#  GNU General Public License for more details.
#
#  You should have received a copy of the GNU General Public License
#  along with GCstar; if not, write to the Free Software
#  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
#
###################################################

use strict;
use utf8;

use GCPlugins::GCboardgames::GCboardgamesCommon;

{
    package GCPlugins::GCboardgames::GCPluginboardgamegeek;

    use base qw(GCPlugins::GCboardgames::GCboardgamesPluginsBase);
 
    sub start
    {
        my ($self, $tagname, $attr, $attrseq, $origtext) = @_;
	
        $self->{inside}->{$tagname}++;

        if ($self->{parsingEnded})
        {
            return;
        }
        
        if ($self->{parsingList})
        {
            if (($tagname eq "h1") && ($attr->{class} eq "geekitem"))
            {
                $self->{parsingEnded} = 1;
                $self->{itemIdx} = 0;
                $self->{itemsList}[0]->{url} = $self->{loadedUrl};
            }
            if ($tagname eq "table")
            {
                if ($attr->{class} eq "thin_table")
                {
                    $self->{isInsideResultsTable} = 1;
	        }                
            }
            if (($tagname eq "a") && ($self->{isInsideResultsTable}))
            {
                if ($attr->{href} =~ /^\/game\//)
                {
                    my $url = $attr->{href};
                    $self->{isBoardgame} = 1;
                    $self->{itemIdx}++;
                    $self->{itemsList}[$self->{itemIdx}]->{url} = $url;
                    $self->{temporaryName} = "";
                    $self->{ignoreAltTitle} = 0;
                }
            }
            if (($tagname eq "i") && ($self->{isBoardgame}))
            {
                $self->{ignoreAltTitle} = 1;
            }
        }
        else
        {
            if (($tagname eq "h1") && ($attr->{class} eq "geekitem"))
            {
                $self->{insideName} = 1;
            }
            elsif (($tagname eq "span") && ($attr->{id} eq "edityear")) 
            {
		$self->{insideYear} = 1;
            } 
            elsif (($tagname eq "span") && ($attr->{id} eq "editnumplayers")) 
            {
		$self->{insidePlayers} = 1;
            }
            elsif (($tagname eq "span") && ($attr->{id} eq "editdesigner")) 
            {
		$self->{insideDesigners} = 1;
            }
            elsif (($tagname eq "span") && ($attr->{id} eq "editpublisher")) 
            {
		$self->{insidePublishers} = 1;
            }
            elsif (($tagname eq "span") && ($attr->{id} eq "editplayingtime")) 
            {
		$self->{insidePlayingTime} = 1;
            }
            elsif (($tagname eq "span") && ($attr->{id} eq "editages")) 
            {
		$self->{insideAges} = 1;
            }
            elsif (($tagname eq "span") && ($attr->{id} eq "editcategory")) 
            {
		$self->{insideCategories} = 1;
            }
            elsif (($tagname eq "span") && ($attr->{id} eq "editmechanic")) 
            {
		$self->{insideMechanics} = 1;
            }
            elsif (($tagname eq "div") && ($attr->{id} eq "module_1")) 
            {
		$self->{insideInfo} = 1;
            }  
            elsif (($tagname eq "div") && ($attr->{id} eq "module_5")) 
            {
		$self->{insideImages} = 1;
            }      
            elsif (($tagname eq "div") && ($attr->{id} eq "module_2")) 
            {
		$self->{insideDescription} = 1;
            }              
            elsif ($tagname eq "img")
            {
                if ($self->{insideImages})
                {
                    if (! $self->{curInfo}->{photo1} )
                    {
                        $self->{tempPic} = $attr->{src};
                        $self->{tempPic} =~ s/_mt/_md/;
                        $self->{curInfo}->{photo1} = $self->{tempPic}
                    }
                    elsif (! $self->{curInfo}->{photo2} )
                    {
                        $self->{tempPic} = $attr->{src};
                        $self->{tempPic} =~ s/_mt/_md/;
                        $self->{curInfo}->{photo2} = $self->{tempPic}
                    }
                    elsif (! $self->{curInfo}->{photo3} )
                    {
                        $self->{tempPic} = $attr->{src};
                        $self->{tempPic} =~ s/_mt/_md/;
                        $self->{curInfo}->{photo3} = $self->{tempPic}
                    }
                    elsif (! $self->{curInfo}->{photo4} )
                    {
                        $self->{tempPic} = $attr->{src};
                        $self->{tempPic} =~ s/_mt/_md/;
                        $self->{curInfo}->{photo4} = $self->{tempPic}
                    }
                }
                elsif ($self->{insideInfo})
                {
	            $self->{tempPic} = $attr->{src};
                    $self->{tempPic} =~ s/_t/_md/;
                    $self->{curInfo}->{boxpic} = $self->{tempPic} if ! $self->{curInfo}->{boxpic};
                    $self->{insideInfo} = 0;
                }
            }
            elsif ($tagname eq "a")
            {
                $self->{currentHref} = $attr->{href};

                if ($self->{insideCategories})
                {
                    $self->{insideCategory} = 1; 
                }
                elsif ($self->{insideMechanics})
                {
                    $self->{insideMechanic} = 1;
                }
                elsif ($self->{insideExpandsList})
                {
                    $self->{insideExpands} = 1;
                }
                elsif ($self->{insideExpansionList})
                {
                    $self->{insideExpansion} = 1;
                }
                elsif ($self->{insideDesigners})
                {
                    $self->{insideDesigner} = 1;
                }
                elsif ($self->{insidePublishers})
                {
                    $self->{insidePublishers} = 0;
                    $self->{insidePublisher} = 1;
                }
            }
            if ($self->{insideDescription})
            {
                if ($tagname eq "br")
                {
                    # neatens up the description a little by starting new line on br tags
                    $self->{curInfo}->{description} .= "\n";
                }
                elsif ($tagname eq "li")
                {
                    # basic formatting of lists
                    $self->{curInfo}->{description} .= " - ";
                }
            }
        }
    }

    sub end
    {
        my ($self, $tagname) = @_;	
        $self->{inside}->{$tagname}--;

        if (($self->{isInsideResultsTable}) && ($tagname eq "table"))
        {
            $self->{isInsideResultsTable} = 0;
        }
	if (($self->{isBoardgame}) && ($tagname eq "a"))
        {
            # name will be messy thanks to formatting of alternate names - clean up

            $self->{originalName} = $self->{temporaryName};

            # first, grab date (eg. (2006) ) from string
            $self->{nameFiltered} = $self->{originalName};
            if ($self->{nameFiltered} =~ /\(([0-9]{4,4})\)$/ )
            {
               $self->{itemsList}[$self->{itemIdx}]->{released} = $1;
            }

            # remove date from string
            $self->{nameFiltered} =~ s/ \([0-9]{4,4}\)$//;
            # also need to remove any occurances of " or " from end of string
            $self->{nameFiltered} =~ s/( or )+$//;

            $self->{itemsList}[$self->{itemIdx}]->{name} = $self->{nameFiltered};

            $self->{isBoardgame} = 0;
        }
        if (($tagname eq "i") && ($self->{ignoreAltTitle}))
        {
            $self->{ignoreAltTitle} = 0;
        }
        if ($tagname eq "span")
        {
            $self->{insideCategories} = 0;
            $self->{insideMechanics} = 0;
            if ($self->{insideDesigners})
            {
                $self->{insideDesigners} = 0;
                $self->{curInfo}->{designedby} =~ s/^(, )//;
                $self->{curInfo}->{designedby} =~ s/(, )$//;
            }

        }
        if ($tagname eq "ul")
        {
            $self->{insideExpandsList} = 0;
            $self->{insideExpansionList} = 0;
        }
        if ($tagname eq "div")
        {
            $self->{insideDescription} = 0;
            # remove spaces from start and end of description
            $self->{curInfo}->{description} =~ s/^\s+//;
            $self->{curInfo}->{description} =~ s/\s+$//;
        }
        if ($self->{insideDescription})
        {
            if (($tagname eq "p") || ($tagname eq "h1") || ($tagname eq "h2") || ($tagname eq "h3") || ($tagname eq "h4")) 
            {
                # neatens up the description a little by placing blank lines between paragraphs
                $self->{curInfo}->{description} .= "\n\n";
            }
            elsif ($tagname eq "li")
            {
                # put new line at end of li elements
                $self->{curInfo}->{description} .= "\n";      
            }
            elsif (($tagname eq "ul") || ($tagname eq "ol"))
            {
                # put blank line after ul, ol elements
                $self->{curInfo}->{description} .= "\n";      
            }
        }
    }

    sub text
    {
        my ($self, $origtext) = @_;

        return if ((length($origtext) < 2) && ($origtext ne " ") && (! $self->{insideDescription}));
        
        $origtext =~ s/&#34;/"/g;
        $origtext =~ s/&#179;/3/g;
        $origtext =~ s/&#[0-9]*;//g;
        $origtext =~ s/\n//g;
        $origtext =~ s/^\s{2,//;



        return if ($self->{parsingEnded});
        
        if ($self->{parsingList})
        {
            if ($self->{isBoardgame})
            {
                if ($self->{ignoreAltTitle})
                {
                }
                else
                {
                    # again, clean up mess left by alt titles by ignoring certain strings
                    if ($origtext ne " or ")
                    {
			$self->{temporaryName} .= $origtext;
                        return;
                    }
                }
            }
        }
        else
        {

            if ((($origtext =~ /^Expands/) && ($self->{inside}->{strong})) && ($self->{insideDescription}))
            {
		$self->{insideExpandsList} = 1;
            }
            elsif ((($origtext =~ /^Expanded/) || ($origtext =~ /^Expansion/)) && ($self->{insideDescription}))
            {
		$self->{insideExpansionList} = 1;
            }

            
            if ($self->{insideName})
            {
                $self->{curInfo}->{name} = $origtext;
                $self->{insideName} = 0;
            }
            elsif ($self->{insideYear})
            {
                $self->{curInfo}->{released} = $origtext;
                $self->{curInfo}->{released} =~ s/([^0-9])//g;
                $self->{insideYear} = 0;
            }
            elsif ($self->{insideDesigner})
            {
                $self->{curInfo}->{designedby} .= $origtext.', ';
                $self->{insideDesigner} = 0;
            } 
            elsif ($self->{insidePublisher})
            {
                $self->{curInfo}->{publishedby} = $origtext;
                $self->{insidePublisher} = 0;
            }
            elsif ($self->{insidePlayers})
            {
                $self->{curInfo}->{players} = $origtext;
                $self->{insidePlayers} = 0;
            }
            elsif ($self->{insidePlayingTime})
            {
                $self->{curInfo}->{playingtime} = $origtext;
                $self->{insidePlayingTime} = 0;
            }
            elsif ($self->{insideAges})
            {
                $self->{curInfo}->{suggestedage} = $origtext;
                $self->{insideAges} = 0;
            }
            elsif ($self->{insideCategory})
            {
                $self->{curInfo}->{category} .= $self->capWord($origtext).',';
                $self->{insideCategory} = 0;
            }
            elsif ($self->{insideMechanic})
            {
                $self->{curInfo}->{mechanics} .= $self->capWord($origtext).',';
                $self->{insideMechanic} = 0;
            }
            elsif ($self->{insideExpands})
            {
                $self->{curInfo}->{expansionfor} = $origtext;
                $self->{insideExpands} = 0;
            }
            elsif ($self->{insideExpansion})
            {
                $self->{curInfo}->{expandedby} .= $self->capWord($origtext).',';
                $self->{insideExpansion} = 0;
            }
            if ($self->{insideDescription})
            {
                $self->{curInfo}->{description} .= $origtext;
            }
        }
    }

    sub new
    {
        my $proto = shift;
        my $class = ref($proto) || $proto;
        my $self  = $class->SUPER::new();
        bless ($self, $class);

        $self->{hasField} = {
            name => 1,
            released => 1,
        };

        $self->{isBoardgame} = 0;
        $self->{curName} = undef;
        $self->{curUrl} = undef;

        return $self;
    }

    sub preProcess
    {
        my ($self, $html) = @_;
        
        $self->{parsingEnded} = 0;
        
        $html =~ s/"&#34;/'"/g;
        $html =~ s/&#34;"/"'/g;
        $html =~ s//'/g;
        $html =~ s//.../g;
        $html =~ s|</a></b><br>|</a><br>|;
             
        return $html;
    }

    sub getSearchUrl
    {
		my ($self, $word) = @_;
	
		return "http://www.boardgamegeek.com/metasearch.php?searchtype=game&search=$word&B1=Go";
    }
    
    sub getItemUrl
    {
		my ($self, $url) = @_;
		
		return $url if $url =~ /^http:/;
		return "http://www.boardgamegeek.com".$url;
    }

    sub getName
    {
        return "Board Game Geek";
    }
    
    sub getAuthor
    {
        return 'Zombiepig';
    }
    
    sub getLang
    {
        return 'EN';
    }
    
    
}

1;
