import gtk



class CalLabel(gtk.VBox):

    def __init__(self, n_horiz, n_vertic, homogeneous):

        self.__labels = []
        self.__positions = {}
        

        gtk.VBox.__init__(self, homogeneous, 0)

        for y in xrange(n_vertic):
            hbox = gtk.HBox(homogeneous, 0)
            hbox.show()
            self.add(hbox)

            for x in xrange(n_horiz):
                lbl = gtk.Label("")
                lbl.show()
                hbox.add(lbl)
                self.__labels.append(lbl)
            #end for
            
        #end for



    def update_positions(self):

        for l in self.__labels:
            x, y, nil, nil = l.get_allocation()
            self.__positions[(x, y)] = l



    def get_label(self, index):

        return self.__labels[index]



    def get_label_at(self, x, y):

        return self.__positions.get((x, y))



    def set_spacing(self, horiz, vertic):

        gtk.VBox.set_spacing(self, vertic)
        for c in self.get_children():
            c.set_spacing(horiz)
