# 
# (c) Simon Marlow 2002
#

# -----------------------------------------------------------------------------
# Configuration info

# There is a single global instance of this structure, stored in the
# variable config below.  The fields of the structure are filled in by
# the appropriate config script(s) for this compiler/platform, in
# ../config.
# 
# Bits of the structure may also be filled in from the command line,
# via the build system, using the '-e' option to runtests.

class TestConfig:
    def __init__(self):

        # Where the testsuite root is
        self.top = ''

        # Directories below which to look for test description files (foo.T)
        self.rootdirs = []

        # Run these tests only (run all tests if empty)
        self.only = []

        # Accept new output which differs from the sample?
        self.accept = 0

        # File in which to save the summary
        self.output_summary = ''

        # File in which to save the times
        self.times_file = ''

        # What platform are we running on?
        self.platform = ''
        self.os = ''
        self.arch = ''

        # What is the wordsize (in bits) of this platform?
        self.wordsize = ''

        # Verbosity level
        self.verbose = 1

        # run the "fast" version of the test suite
        self.fast = 0

        # Compiler type (ghc, hugs, nhc, etc.)
        self.compiler_type = ''

        # Path to the compiler
        self.compiler = ''
        # and ghc-pkg
        self.ghc_pkg = ''

        # Compiler version info
        self.compiler_version = ''
        self.compiler_maj_version = ''
        self.compiler_tags = []

        # Flags we always give to this compiler
        self.compiler_always_flags = []
        
        # Which ways to run tests (when compiling and running respectively)
        # Other ways are added from the command line if we have the appropriate
        # libraries.
        self.compile_ways = []
        self.run_ways     = []
        self.other_ways   = []

        # The ways selected via the command line.
        self.cmdline_ways = []

        # Lists of flags for each way
        self.way_flags = {}
        self.way_rts_flags = {}

        # Do we have profiling support?
        self.have_profiling = False

        # Do we have shared libraries?
        self.have_shared_libs = False

        # Are we testing an in-tree compiler?
        self.in_tree_compiler = True

        # the timeout program
        self.timeout_prog = ''
        self.timeout = 300
        
        # threads
        self.threads = 1
        self.use_threads = 0

global config
config = TestConfig()

def getConfig():
    return config

# -----------------------------------------------------------------------------
# Information about the current test run

class TestRun:
   def __init__(self):
       self.start_time = ''
       self.total_tests = 0
       self.total_test_cases = 0
       self.n_framework_failures = 0
       self.framework_failures = {}
       self.n_tests_skipped = 0
       self.tests_skipped = {}
       self.n_expected_passes = 0
       self.expected_passes = {}
       self.n_expected_failures = 0
       self.expected_failures = {}
       self.n_unexpected_passes = 0
       self.unexpected_passes = {}
       self.n_unexpected_failures = 0
       self.unexpected_failures = {}
       
global t
t = TestRun()

def getTestRun():
    return t

# -----------------------------------------------------------------------------
# Information about the current test

class TestOptions:
   def __init__(self):

       # if not None then we look for namebase.stderr etc rather than
       # using the test name
       self.with_namebase = None;

       # skip this test?
       self.skip = 0;

       # skip these ways
       self.omit_ways = []

       # skip all ways except these ([] == do all ways)
       self.only_ways = []

       # add these ways to the default set
       self.extra_ways = []

       # the result we normally expect for this test
       self.expect = 'pass'

       # override the expected result for certain ways
       self.expect_fail_for = []

       # the stdin file that this test will use (empty for <name>.stdin)
       self.stdin = ''

       # don't compare output
       self.ignore_output = 0

       # don't give anything as stdin
       self.no_stdin = 0

       # compile this test to .hc only
       self.compile_to_hc = 0

       # extra compiler opts for this test
       self.extra_hc_opts = ''

       # extra run opts for this test
       self.extra_run_opts = ''

       # expected exit code
       self.exit_code = 0

       # should we clean up after ourselves?
       self.cleanup = ''

       # extra files to clean afterward
       self.clean_files = []

       # which -t numeric fields do we want to look at, and what bounds must
       # they fall within?
       # Elements of these lists should be things like
       # ('bytes allocated',
       #   9300000000,
       #   9400000000)
       self.compiler_stats_num_fields = []
       self.stats_num_fields = []

       # should we run this test alone, i.e. not run it in parallel with
       # any other threads
       self.alone = 0

       # Does this test use a literate (.lhs) file?
       self.literate = 0

       # Does this test use a .c file?
       self.c_src = 0

       # Command to run before the test
       self.pre_cmd = None

       # Command to run for extra cleaning
       self.clean_cmd = None

       # Prefix to put on the command before running it
       self.cmd_prefix = ''

       # Prefix to put on the command before compiling it
       self.compile_cmd_prefix = ''

       # Extra output normalisation
       self.extra_normaliser = lambda x: x

       # The directory the test is in
       self.testdir = '.'

# The default set of options
global default_testopts
default_testopts = TestOptions()

