/*
 *  
 *  $Id: panelgrid.cpp 4330 2011-10-25 10:28:33Z tovar $
 *  Ginkgo CADx Project
 *
 *  Copyright 2008-10 MetaEmotion S.L. All rights reserved.
 *  http://ginkgo-cadx.com
 *
 *  This file is licensed under LGPL v3 license.
 *  See License.txt for details
 *
 *
 */

#include <wx/wx.h>
#include <wx/aui/aui.h>
#include <wx/iconoimagenctrl/iconoimagenctrl.h>
#include <wx/menu.h>
#include <wx/dcbuffer.h>
#include <wx/dcclient.h>

#include <api/globals.h>

#include <resources/ginkgoresourcemanager.h>
#include <api/ivista.h>
#include <api/icontextoestudio.h>
#include <main/entorno.h>

#include <main/gui/mainwindow/ventanaprincipal.h>

#include "panelgrid.h"

namespace GNC {
	namespace GUI {
		DialogoDesencajado::DialogoDesencajado(wxWindow* pParent, VentanaPrincipal* pVentanaPrincipal): DialogoDesencajadoBase(pParent)
		{
			wxIcon icono;
			icono.CopyFromBitmap(GinkgoResourcesManager::Logos::GetLogoGinkgo32x32());
			this->SetIcon(icono);

			GNC::Entorno::Instance()->ObservadoresVistas.push_back(this);
			m_pWindow = NULL;
			m_pVentanaPrincipal = pVentanaPrincipal;
		}

		DialogoDesencajado::~DialogoDesencajado()
		{
			GNC::Entorno::Instance()->ObservadoresVistas.remove(this);
			m_pWindow = NULL;
			m_pVentanaPrincipal = NULL;
		}

		void DialogoDesencajado::AddPanel(wxWindow* pWin, const wxString& titulo)
		{
			m_pWindow = pWin;
			SetTitle(titulo);
			if(m_pWindow->GetParent() != this){
				m_pWindow->GetParent()->GetSizer()->Detach(m_pWindow);
				m_pWindow->Reparent(this);
			}
			m_pWindow->Show(true);
			GetSizer()->Add(m_pWindow,1,wxEXPAND);
		}

		void DialogoDesencajado::SetTitulo(const wxString& titulo)
		{
			SetTitle(titulo);
		}

		wxWindow* DialogoDesencajado::GetWindow()
		{
			return m_pWindow;
		}

		wxString DialogoDesencajado::GetTitulo()
		{
			return GetTitle();
		}

		void DialogoDesencajado::OnCloseDialogo(wxCloseEvent &event)
		{
			if(!m_pVentanaPrincipal->CerrarVista(m_pWindow)) {
				event.Veto();
			} else {
				event.Skip();
				GetSizer()->Detach(m_pWindow);
				GNC::GCS::ControladorVistas::Instance()->Destruir(m_pWindow);
			}
		}

		//esto es para que se pinte correctamente el recuadro amarillo cuando cambias de ventana
		void DialogoDesencajado::OnVistaActivada(GNC::GCS::IVista* pVista)
		{
			RefrescarVista(pVista);
		}

		void DialogoDesencajado::RefrescarVista(GNC::GCS::IVista* pVista)
		{
			if(pVista != NULL) {
				if(pVista->GetWindow()->GetParent() == m_pWindow)
				{
					m_pWindow->Refresh();
				}
			}
		}


		void DialogoDesencajado::OnBotonTitulo(wxCommandEvent &)
		{

		}

		///////////////////////////////////////////////////////////////////////////
		PanelGrid::PanelGrid(wxWindow* pParent, VentanaPrincipal* pVentanaPrincipal):PanelGridBase(pParent)
		{
			SetBackgroundColour(wxColour(75,75,75));

			SetMinSize(wxSize(300,300));
			m_pWindow = NULL;
			m_pVentanaPrincipal = pVentanaPrincipal;

			//creo los botones
			m_pBPrimerPlano = new IconoImagenCtrl(this,GinkgoResourcesManager::MenusTabs::GetIcoPrimerPlano(),_("Maximize"),false,true);
			m_pBPrimerPlano->Connect(wxEVT_COMMAND_BUTTON_CLICKED,wxCommandEventHandler( PanelGrid::OnPrimerPlano),NULL,this);
			m_pSizerBotones->Add(m_pBPrimerPlano,1, wxALIGN_CENTER_VERTICAL|wxEXPAND);

			m_pBReagrupar = new IconoImagenCtrl(this,GinkgoResourcesManager::MenusTabs::GetIcoReagrupar(),_("Display Options"),false,true);
			m_pBReagrupar->Connect(wxEVT_COMMAND_BUTTON_CLICKED,wxCommandEventHandler( PanelGrid::OnBotonTitulo),NULL,this);
			m_pSizerBotones->Add(m_pBReagrupar,1, wxALIGN_CENTER_VERTICAL|wxEXPAND);

			m_pBCerrar = new IconoImagenCtrl(this,GinkgoResourcesManager::MenusTabs::GetIcoCerrarTab(),_("Close Panel"),false,true);
			m_pBCerrar->Connect(wxEVT_COMMAND_BUTTON_CLICKED,wxCommandEventHandler( PanelGrid::OnPanelGridClose),NULL,this);
			m_pSizerBotones->Add(m_pBCerrar,1, wxALIGN_CENTER_VERTICAL|wxEXPAND);

			m_titulo = wxEmptyString;

			Layout();
		}

		PanelGrid::~PanelGrid()
		{
			m_pWindow = NULL;
			m_pVentanaPrincipal = NULL;
			if(m_pBCerrar != NULL){
				delete m_pBCerrar;
				m_pBCerrar = NULL;
			}
			if(m_pBReagrupar != NULL) {
				delete m_pBReagrupar;
				m_pBReagrupar = NULL;
			}
			if(m_pBPrimerPlano != NULL){
				delete m_pBPrimerPlano;
				m_pBPrimerPlano = NULL;
			}
		}

		void PanelGrid::AddPanel(wxWindow* pWin, const wxString& titulo)
		{
			m_pWindow = pWin;
			SetTitulo(titulo);
			if(m_pWindow->GetParent() != this){
				m_pWindow->GetParent()->GetSizer()->Detach(m_pWindow);
				m_pWindow->Reparent(this);
			}
			GetSizer()->Add(m_pWindow,1,wxEXPAND);
			//esto parece inutil pero no lo es, cuando el pWin viene de un tab estara oculto
			pWin->Show(true);
			Layout();
		}

		void PanelGrid::SetTitulo(const wxString& titulo)
		{
			m_titulo = titulo;
		}

		wxWindow* PanelGrid::GetWindow()
		{
			return m_pWindow;
		}

		wxString PanelGrid::GetTitulo()
		{
			return m_titulo;
		}

		bool PanelGrid::Cerrar()
		{
			bool cerrado;
			//m_pVentanaPrincipal->SuperFreeze();
			cerrado = m_pVentanaPrincipal->CerrarVista(m_pWindow);
			if(cerrado) {
				GNC::GCS::ControladorVistas::Instance()->Destruir(m_pWindow);
				m_pVentanaPrincipal->DestruirPanelGrid(this);
				//a partir d aqui esta muerta
			}
			//m_pVentanaPrincipal->SuperThaw();
			return cerrado;
		}

		void PanelGrid::OnPanelGridClose(wxCommandEvent &)
		{
			Cerrar();
		}

		void PanelGrid::OnPrimerPlano(wxCommandEvent &)
		{
			m_pVentanaPrincipal->PasarAPrimerPlano(m_pWindow);
			//a partir d aqui esta muerta
		}

		void PanelGrid::OnBotonTitulo(wxCommandEvent &)
		{
			MostrarMenu();
		}

		void PanelGrid::OnRightButtonUp( wxMouseEvent& /*event*/ )
		{
			MostrarMenu();
		}

		void PanelGrid::OnMenuTitulo( wxMouseEvent&  )
		{
			MostrarMenu();
		}

		void PanelGrid::MostrarMenu( )
		{
			wxMenu*  menu = new wxMenu();
			//cerrar pestania activa
			int id=1;

			wxMenu* subMenuPestanias = new wxMenu();
			wxMenuItem* pMenuMostrarPrimerPlano = new wxMenuItem(subMenuPestanias, id++, _("Tab grouping"), _("Tab grouping"), wxITEM_NORMAL );
			wxMenuItem*  pMosaicoHorizontal = new wxMenuItem( subMenuPestanias, id++, _("Horizontal mosaic"), _("Horizontal mosaic"), wxITEM_NORMAL );
			wxMenuItem*  pMosaicoVertical = new wxMenuItem( subMenuPestanias, id++, _("Vertical mosaic"), _("Vertical mosaic"), wxITEM_NORMAL );

			wxMenu* subMenuGrid = new wxMenu();
			wxMenuItem*  pGrid2Col = new wxMenuItem( menu, id++, _("Grid (two columns)"), _("Grid (two columns)"), wxITEM_NORMAL );
			wxMenuItem*  pGrid3Col = new wxMenuItem( menu, id++, _("Grid (three columns)"), _("Grid (three columns)"), wxITEM_NORMAL );

			wxMenuItem* pMenuCerrarTodas = new wxMenuItem(menu, id++, _("Close All"), _("Close all tabs"), wxITEM_NORMAL );
			wxMenuItem* pMenuCerrarActiva = new wxMenuItem(menu, id++, _("&Close"), _("Close"), wxITEM_NORMAL );

		#ifdef __WXMSW__
			pMenuCerrarActiva->SetBitmaps(GinkgoResourcesManager::IconosMenus::GetIcoCerrarTab());
			pMenuMostrarPrimerPlano->SetBitmaps(GinkgoResourcesManager::MenusTabs::GetIcoReagrupar());
			pGrid2Col->SetBitmaps(GinkgoResourcesManager::MenusTabs::GetIcoGrid2Col());
			pGrid3Col->SetBitmaps(GinkgoResourcesManager::MenusTabs::GetIcoGrid3Col());
		#else
			pMenuCerrarActiva->SetBitmap(GinkgoResourcesManager::IconosMenus::GetIcoCerrarTab());
			pMenuMostrarPrimerPlano->SetBitmap(GinkgoResourcesManager::MenusTabs::GetIcoReagrupar());
			pGrid2Col->SetBitmap(GinkgoResourcesManager::MenusTabs::GetIcoGrid2Col());
			pGrid3Col->SetBitmap(GinkgoResourcesManager::MenusTabs::GetIcoGrid3Col());
		#endif

			subMenuPestanias->Append(pMenuMostrarPrimerPlano);
			subMenuPestanias->AppendSeparator();
			subMenuPestanias->Append(pMosaicoHorizontal);
			subMenuPestanias->Append(pMosaicoVertical);
			menu->AppendSubMenu(subMenuPestanias,_("Tabbed organization"));
			subMenuGrid->Append(pGrid2Col);
			subMenuGrid->Append(pGrid3Col);
			menu->AppendSubMenu(subMenuGrid,_("Grid Organization"));
			menu->AppendSeparator();
			menu->Append(pMenuCerrarActiva);
			menu->Append(pMenuCerrarTodas);

			menu->Connect(pMenuMostrarPrimerPlano->GetId(), wxEVT_COMMAND_MENU_SELECTED,wxCommandEventHandler( PanelGrid::OnPrimerPlano),NULL,this);
			menu->Connect(pMenuCerrarTodas->GetId(),wxEVT_COMMAND_MENU_SELECTED,wxCommandEventHandler( PanelGrid::OnMenuCerrarTodosTabsClick),NULL,this);
			menu->Connect(pMenuCerrarActiva->GetId(),wxEVT_COMMAND_MENU_SELECTED,wxCommandEventHandler( PanelGrid::OnPanelGridClose),NULL,this);


			#ifdef __WXGTK__
			subMenuPestanias->Connect( pMosaicoVertical->GetId(), wxEVT_COMMAND_MENU_SELECTED, wxCommandEventHandler( PanelGrid::OnMosaicoVertical ),NULL,this );
			subMenuPestanias->Connect( pMosaicoHorizontal->GetId(), wxEVT_COMMAND_MENU_SELECTED, wxCommandEventHandler( PanelGrid::OnMosaicoHorizontal ),NULL,this );
			subMenuGrid->Connect(pGrid3Col->GetId(),wxEVT_COMMAND_MENU_SELECTED,wxCommandEventHandler( PanelGrid::OnMosaicoGrid3Col),NULL,this);
			subMenuGrid->Connect(pGrid2Col->GetId(),wxEVT_COMMAND_MENU_SELECTED,wxCommandEventHandler( PanelGrid::OnMosaicoGrid2Col),NULL,this);
			#else
			menu->Connect( pMosaicoVertical->GetId(), wxEVT_COMMAND_MENU_SELECTED, wxCommandEventHandler( PanelGrid::OnMosaicoVertical ),NULL,this );
			menu->Connect( pMosaicoHorizontal->GetId(), wxEVT_COMMAND_MENU_SELECTED, wxCommandEventHandler( PanelGrid::OnMosaicoHorizontal ),NULL,this );
			menu->Connect(pGrid3Col->GetId(),wxEVT_COMMAND_MENU_SELECTED,wxCommandEventHandler( PanelGrid::OnMosaicoGrid3Col),NULL,this);
			menu->Connect(pGrid2Col->GetId(),wxEVT_COMMAND_MENU_SELECTED,wxCommandEventHandler( PanelGrid::OnMosaicoGrid2Col),NULL,this);
			#endif
			GNC::Entorno::Instance()->GetVentanaRaiz()->PopupMenu(menu);
			delete menu;
		}

		void PanelGrid::OnMosaicoHorizontal(wxCommandEvent& event)
		{
			m_pVentanaPrincipal->OnMosaicoHorizontal(event);
		}
		void PanelGrid::OnMosaicoVertical(wxCommandEvent& event)
		{
			m_pVentanaPrincipal->OnMosaicoVertical(event);
		}

		void PanelGrid::OnMosaicoRestaurar(wxCommandEvent& event)
		{
			m_pVentanaPrincipal->OnMosaicoRestaurar(event);
		}

		void PanelGrid::OnMosaicoGrid2Col(wxCommandEvent& event)
		{
			m_pVentanaPrincipal->OnMosaicoGrid2Col(event);
		}

		void PanelGrid::OnMosaicoGrid3Col(wxCommandEvent& event)
		{
			m_pVentanaPrincipal->OnMosaicoGrid3Col(event);
		}

		void PanelGrid::OnPantallaCompleta(wxCommandEvent& event)
		{
			m_pVentanaPrincipal->OnPantallaCompleta(event);
		}

		void PanelGrid::OnMenuCerrarTodosTabsClick(wxCommandEvent& event)
		{
			m_pVentanaPrincipal->OnMenuCerrarTodosTabsClick(event);
		}

		void PanelGrid::OnSize(wxSizeEvent &event)
		{
			//se obliga a refrescar el texto
			wxRect rect(0,0,event.GetSize().x-m_pSizerBotones->GetSize().x,25);
			RefreshRect(rect,true);
			event.Skip(true);
		}

		void PanelGrid::OnEraseBackground(wxEraseEvent& )
		{}

		void PanelGrid::OnPaint(wxPaintEvent& /*event*/)
		{
			//se pinta la parte de arriba
			wxBufferedPaintDC dc(this);

			const int width = dc.GetSize().x;
			const int height = dc.GetSize().y;

			wxColour m_colorBorde = wxColour(115, 115, 115);
			wxColour m_colorSombraBorde = wxColour(230, 230, 230);
			wxColour m_colorTitulo = wxColour(245,245,245);
			int m_sizeBorder = 1;
			wxFont m_fuente = wxFont( 10, 70, 90, wxFONTWEIGHT_BOLD, false, wxEmptyString );
			wxColour m_fondoTituloTopColor = wxColour(90, 90, 90);
			wxColour m_fondoTituloBottomColor = wxColour(54, 54, 54);
			int m_margenTitulo = 5;

			dc.SetFont( m_fuente );

			wxString titulo = m_titulo;

			wxCoord textW, textH;
			dc.GetTextExtent(wxT("..."), & textW, & textH);
			int offsetDerecha = m_pSizerBotones->GetSize().x + textW + 10;
			
			dc.GetTextExtent(titulo, & textW, & textH);
			while (textW > (width - offsetDerecha) && titulo.size()>0 ) {			
				titulo = titulo.substr(0, titulo.size() - 1);
				dc.GetTextExtent(titulo, & textW, & textH);
			}

			if (titulo.size() != m_titulo.size())
				titulo+= wxT("...");

			if (titulo.empty()) {
				titulo = wxT("    ");
				dc.GetTextExtent(titulo, & textW, & textH);
			}

			// Title
			int dobleMargen = m_margenTitulo*2;
			wxRect rTitle(0, 0, width, textH + dobleMargen);

			// Title background			
			dc.GradientFillLinear(rTitle, m_fondoTituloBottomColor, m_fondoTituloTopColor, wxNORTH);

			// Title border
			dc.SetBrush(*wxTRANSPARENT_BRUSH);
			dc.SetPen(wxPen(m_colorBorde, m_sizeBorder, wxSOLID));
			dc.DrawRectangle(rTitle);	

			// Title text
			if (!IsEnabled()) {
				dc.SetTextForeground(wxSystemSettings::GetColour( wxSYS_COLOUR_GRAYTEXT ));
			} else {
				dc.SetTextForeground(m_colorTitulo);
			}

			dc.DrawText(titulo,m_margenTitulo+3,m_margenTitulo);

			// inner shadow container
			wxRect rTitleShadow(1, textH + dobleMargen, width - 2, height - textH - dobleMargen - 1);
			dc.SetPen(wxPen(m_colorSombraBorde, m_sizeBorder, wxSOLID));
			dc.DrawRectangle(rTitleShadow);
		}
		

		
	}
}
