/*
 *  $Id: FooExtensionController.cpp 3681 2011-04-12 10:53:31Z tovar $
 *  Proyecto Ginkgo
 *
 *  Copyright 2008 MetaEmotion S.L. All rights reserved.
 *
 */
#include <api/globals.h>
#include <vector>
#include <set>
#include <string>
#include <sstream>
#include <iostream>
#include <wx/config.h>

#include <wx/wx.h>
#include <wx/notebook.h>
#include <wx/aui/aui.h>
#include <wx/dir.h>
#include <wx/file.h>
#include <wx/filename.h>
#include <wx/mstream.h>

#include <api/ientorno.h>
#include <api/ivista.h>
#include <api/ianotador.h>
#include <api/dicom/imodelodicom.h>
#include <api/controllers/ipacscontroller.h>
#include <api/icontroladorvistas.h>
#include <api/icontroladorcarga.h>
#include <api/icontroladorhistorial.h>


#include <api/icontroladorpermisos.h>

#include "../../resources/fooextensionresourcemanager.h"
#include "fooextensioncontroller.h"
#include <fooextension/gui/importation/generaldata.h>
#include <fooextension/views/fooextensionview.h>
#include <fooextension/studies/fooextensionstudy.h>


#include <api/icontroladorinternacionalizacion.h>
#include <fooextension/license.h>


namespace FooExtension {
	//Controller mode of foo extension, foo extension can open 
	class FooExtensionControllerMode: public GNC::GCS::ModoControlador
	{
	public:
		//FooExtensionControllerMode: defines ways of Dicom viewing of this extension
		//id: unique in this controller
		//listaModalidades: modality supporting list
		//abreSeriesSueltas: true if it opens series, false if it opens studies
		//bitmap: bitmap of this mode (for visualization purposes)
		FooExtensionControllerMode(int id, const std::string& descripcion, TipoListaModalidades listaModalidades, TipoListaUIDsImportacion listaUIDsImportacion, bool abreSeriesSueltas, wxBitmap * bitmap = NULL):GNC::GCS::ModoControlador(id, descripcion, listaModalidades, listaUIDsImportacion, abreSeriesSueltas, bitmap)
		{
		}
		~FooExtensionControllerMode() {}

		//returns true if this mode supports this pair of modality-transfer syntax
		virtual bool SupportsModalityFile(const std::string &modalidad, const std::string& transferSyntax){
			for(TipoListaModalidades::iterator it = m_listaModalidades.begin(); it!= m_listaModalidades.end(); ++it){
				if((*it) == modalidad){					
					return true;
				}
			}
			return false;
		}
	};

	/* Constructor */
	FooExtensionController::FooExtensionController(GNC::GCS::IEntorno* pEntorno) : IControladorModulo(pEntorno, FOO_EXTENSION_SID, 5 )
	{
		//First we register internationalization catalog
		{
			pEntorno->GetControladorInternacionalizacion()->AddCatalog("fooextension");
		}

		m_pEntorno = pEntorno;
		//name
		m_Nombre = FOO_EXTENSION_DESCRIPTION;
		//copyright
		m_CopyRight = "(c) 2009 MetaEmotion S.L.";
		//author
		m_Author = "MetaEmotion S.L.";
		m_VersionMayor = FOO_EXTENSION_VERSION;
		m_VersionMinor = FOO_EXTENSION_SUB_VERSION;
		m_VersionRelease = FOO_EXTENSION_SUB_RELEASE;
		m_CodeName = FOO_EXTENSION_CODENAME;
		
		std::ostringstream ostr;
		ostr << m_VersionMayor << "." << m_VersionMinor << "." << m_VersionRelease << " " << m_CodeName;
		m_Version = ostr.str();
	}

	FooExtensionController::~FooExtensionController()
	{
		for (int i = 0; i < m_ListaModos.size(); ++i) {
			delete m_ListaModos[i];
		}
	}

	//It's mandatory to implement this method, here you have to register views of this module (Controller modes), this will register FooExtensionView .
	 void FooExtensionController::RegistrarVistas()
	 {
		 GNC::GCS::ModoControlador::TipoListaModalidades listaModalidades;
		listaModalidades.push_back(std::string("XC")); //External-camera Photography

		GNC::GCS::ModoControlador::TipoListaUIDsImportacion listaUIDsImportacion;
		listaUIDsImportacion.push_back(FOO_EXTENSION_UID);

		m_ListaModos.push_back(new FooExtensionControllerMode(0, FOO_EXTENSION_DESCRIPTION, listaModalidades, listaUIDsImportacion, true));
	 }


	//it's call by Ginkgo CADx core when this extension has to open a series with required module and required Diagnostic Study UID, returns an IVista (view)
	GNC::GCS::IVista* FooExtensionController::AbrirVista(int modo, ListaDescriptoresSerie& series, const std::string& uidEstudioDiagnostico)
	{
		FooExtension::FooExtensionView * pView = NULL;

		if (modo < 0 || modo >= (int) m_ListaModos.size()) {
			wxMessageDialog dialog( m_pEntorno->GetVentanaRaiz(), _("Error opening study"), _("Unknown mode"),  wxOK | wxICON_INFORMATION);
			dialog.ShowModal();
			return NULL;
		}

		//this module opens series, so we extract unique series, and we open one view for each series
		std::set<std::string> uidsSeries;
		{
			for(ListaDescriptoresSerie::iterator it = series.begin(); it!= series.end(); it++){
				if(m_ListaModos[modo]->SupportsModalityFile((*it).m_modalidad, (*it).m_uidTransferSyntax))
				{
					uidsSeries.insert((*it).m_uidSerie);
				}
			}
		}
		//

		for(std::set<std::string>::iterator it = uidsSeries.begin(); it!= uidsSeries.end(); it++)
		{
			//this call returns paths ordered
			std::vector<std::string> paths = m_pEntorno->GetControladorHistorial()->GetPathsSerieOrdenados((*it));

			//this is the view controller
			GNC::GCS::IControladorVistas* pCtrlVistas = m_pEntorno->GetControladorVistas();
			wxWindow* pVentanaPadre = NULL;

			{
				//this is to prevent flickering
				pVentanaPadre = pCtrlVistas->GetRootWindow();
				pCtrlVistas->Freeze();
				//
				try{
					if (modo == m_ListaModos[0]->GetId()) {
						wxWindowDisabler disabler;

						GnkPtr<FooExtension::FooExtensionStudy> study = new FooExtension::FooExtensionStudy();
						study->ListaUIDsSerie.push_back((*it));
						study->Entorno = m_pEntorno;
						study->Modulo = this;
						study->VentanaPadre = pVentanaPadre;
						study->InicializarContextoEstudio(paths, "", GNC::GCS::IContextoEstudio::TMF_UNDiagnostico);
						pView = new FooExtension::FooExtensionView (study);
						//register this new view
						pCtrlVistas->Registrar(pView);
					}
				}
				catch(GNC::GCS::VistaException &ex){
					if (pView != NULL) {
						pCtrlVistas->Destruir(pView);
					}
					pCtrlVistas->Thaw();
					wxString mensaje = wxString::FromUTF8(ex.GetCause().c_str());
					wxMessageDialog dialogo( m_pEntorno->GetVentanaRaiz(), mensaje, _("Error opening study"),  wxOK | wxICON_INFORMATION);
					dialogo.ShowModal();
					return NULL;
				}
				catch (...) {
					if (pView != NULL) {
						pCtrlVistas->Destruir(pView);
					}
					pCtrlVistas->Thaw();
					wxMessageDialog dialogo( m_pEntorno->GetVentanaRaiz(), _("Error opening study"), _("Error opening study"),  wxOK | wxICON_INFORMATION);
					dialogo.ShowModal();
					return NULL;
				}
				pCtrlVistas->Thaw();
			}//ends window freeze

			if (pView == NULL ) {
				pCtrlVistas->Freeze();
				pCtrlVistas->Destruir(pView);
				pCtrlVistas->Thaw();
				return NULL;
			}
			else {
				//starts loader command, this command is asyncronous and makes all loading work
				GnkPtr<GIL::IModeloIntegracion> ptr;
				m_pEntorno->GetControladorCarga()->CargaAsincrona(pView, ptr, "");
			}
		}

		return pView;
		return NULL;
	}

	//it supports importation workflow?
	bool FooExtensionController::SoportaImportacion() const {
		return true;
	}


	//returns importation steps
	void FooExtensionController::GetPasosImportacion(IWizard* pWizard,std::list<IPasoWizard*> &listaPasos, wxWindow* pParent, std::string &dirTemporal, GnkPtr<GIL::IModeloIntegracion> pModeloIntegracion)
	{
		//All importation wizards are initialized with image selection step, if you want to remove this step call to this method
		//listaPasos.clear();
		//

		//this is a structure shared by all steps
		GnkPtr<FooExtension::GUI::ImportationPersistentData> persistentData(new FooExtension::GUI::ImportationPersistentData());

		IPasoWizard* step = NULL;

		//patient data step
		step = new FooExtension::GUI::GeneralData(pParent,pWizard,dirTemporal,persistentData,m_pEntorno);
		listaPasos.push_back(step);
	}
};




