/*
 *  $Id: glightvisualizatorview.cpp 3922 2011-07-06 12:51:23Z tovar $
 *  Proyecto Ginkgo
 *
 *  Copyright 2008 MetaEmotion S.L. All rights reserved.
 *
 */
#ifdef __DEPRECATED
#undef __DEPRECATED
#endif
//#define _GINKGO_TRACE
#include <api/globals.h>
#include <api/icontextoestudio.h>
#include <api/ientorno.h>

#include <eventos/eventosginkgo.h>

#include "glightvisualizatorview.h"
#include <wx/image.h>
#include <wx/bitmap.h>
#include <wx/dcclient.h>
#include <lightvisualizator/views/lightvisualizatorview.h>
#include <main/controllers/controladorlog.h>
#include <itk/itkVTKImageToImageFilter.h>


#include <vtkSmartPointer.h>
#include <vtkObject.h>
#include <vtkExecutive.h>
#include <vtkInformationVector.h>
#include <vtkInformation.h>
#include <vtkRenderer.h>
#include <vtkPointData.h>
#include <vtkImageData.h>
#include <vtkLookupTable.h>
#include <vtkProperty.h>
#include <vtkImageResample.h>
#include <vtkImageExport.h>
#include <vtkImageChangeInformation.h>
#include <vtkAlgorithmOutput.h>
#include <vtkImageMapToColors.h>
#include <vtkScalarsToColors.h>
#include <vtkImageMapToWindowLevelColors.h>
#include <vtkStreamingDemandDrivenPipeline.h>
#include <VTKInria3D/vtkVISUManagement/vtkLookupTableManager.h>
#include <lightvisualizator/tools/toolwindowlevellight.h>
#include <api/icontroladorherramientas.h>
#include <api/ientorno.h>



namespace LightVisualizator {
	namespace GUI {

		class VTKInternalMembers {
		public:
			vtkSmartPointer<vtkImageResample> ImageScale;
			vtkSmartPointer<vtkScalarsToColors> LookupTable;
			int DimensionsOriginal[3];
		};
		
		class ImagePanel: public wxPanel {
		public:
			ImagePanel(wxWindow* parent) : wxPanel(parent)
			{	
				m_pBitmap = NULL;
				this->Connect( wxEVT_PAINT, wxPaintEventHandler( ImagePanel::OnPaint ), NULL, this );
			}

			
			~ImagePanel()
			{
			}


			virtual void OnEraseBackground(wxEraseEvent& WXUNUSED(event))
			 {
				 wxPaintDC dc( this );
				 if (m_pBitmap == NULL) {
					wxBrush backBrush(*wxBLACK);
					dc.SetBackground(backBrush);
					return;
				 }
			 }

			virtual void OnPaint(wxPaintEvent& WXUNUSED(event))
			 {
			  wxPaintDC dc( this );
				 if (m_pBitmap == NULL) {
					wxBrush backBrush(*wxBLACK);
					dc.SetBackground(backBrush);
					return;
				 }
			  if (m_pBitmap->IsOk()) {
				dc.DrawBitmap( *m_pBitmap, 0, 0, true );
			  }
			}
		
			void SetBitmap(wxBitmap* pBitmap) 
			{
				m_pBitmap = pBitmap;
				wxSize size(m_pBitmap->GetWidth(), m_pBitmap->GetHeight());
				SetSize(size);
				SetMinSize(size);
				SetMaxSize(size);
				SetClientSize(size);
				Layout();
			}

			wxBitmap* m_pBitmap;
		};
		/////////////////////////////////////////////////////////////////////////////////////////////////
	
		GLightVisualizatorView::GLightVisualizatorView(LightVisualizator::LightVisualizatorView* pView): GLightVisualizatorViewBase(pView->GetLightStudy()->VentanaPadre) 
		{
			pInternalMembers = NULL;
			m_pBitmap = NULL;
			View = pView;
			m_pImagePanel = new ImagePanel(m_pScrolledImage);
			m_pScrolledImage->GetSizer()->Add(m_pImagePanel, 1, wxEXPAND);
			m_pScrolledImage->Layout();
			Layout();
			m_zoom = -1;

			m_pZoom->AppendString(wxT("Ventana"));
			m_pZoom->AppendString(wxT("100 %"));
			m_pZoom->AppendString(wxT("66 %"));
			m_pZoom->AppendString(wxT("50 %"));
			m_pZoom->AppendString(wxT("33 %"));
			m_pZoom->AppendString(wxT("25 %"));
			m_pZoom->AppendString(wxT("16 %"));
			m_pZoom->AppendString(wxT("12 %"));
			m_pZoom->AppendString(wxT("8 %"));
			m_pZoom->AppendString(wxT("6 %"));
			m_pZoom->AppendString(wxT("5 %"));
			m_pZoom->AppendString(wxT("4 %"));
			m_pZoom->AppendString(wxT("3 %"));
			m_pZoom->AppendString(wxT("2 %"));
			m_pZoom->AppendString(wxT("1 %"));
			m_pZoom->SetSelection(0);

			
			GNC::GCS::Eventos::EventoModificacionImagen ev2(View);
			
			View->GetEstudio()->Entorno->GetControladorEventos()->Registrar(this, ev2);
		}

		GLightVisualizatorView::~GLightVisualizatorView() 
		{
			GNC::GCS::IControladorHerramientas* cH = View->GetLightStudy()->Entorno->GetControladorHerramientas();
			LightVisualizator::IToolWindowLevelLight*            hWL = NULL;
			try {
				// Subscribimos la vista al contrato de puntero
				hWL = cH->ObtenerHerramientaConcreta<LightVisualizator::IToolWindowLevelLight>(LightVisualizator::IToolWindowLevelLight::ID);
				if (hWL != NULL) {
					((GNC::GCS::IContratable<LightVisualizator::IContratoWindowLevelLight>*)hWL)->DesSubscribirsLosDeLaVista(View);
				}
			}
			catch (GNC::GCS::ControladorHerramientasException& ex) {
				std::cerr << "Error al obtener la herramienta: No se pudo subscribir la herramienta: " << ex.getCause() << std::endl;
			}

			View->Lock(GLOC());
			delete View;
			if (m_pBitmap != NULL) {
				delete m_pBitmap;
			}
			if (pInternalMembers != NULL) {
				delete pInternalMembers;
			}
		}
		
		void GLightVisualizatorView::LoadImageCanvas()
		{
			Freeze();
			if (m_pBitmap != NULL) {
				delete m_pBitmap;
			}

			if (pInternalMembers == NULL) {
				pInternalMembers = new VTKInternalMembers();
			}

			int numSlices = View->GetEstudio()->GetNumeroCortes();
			if (numSlices>1) {
				m_pSliderSerie->Show(true);
				m_pSliderSerie->SetMin(0);
				m_pSliderSerie->SetValue(0);
				m_pSliderSerie->SetMax(numSlices-1);
			} else {
				m_pSliderSerie->Show(false);
			}
			
			//number of components????
			vtkSmartPointer<vtkAlgorithmOutput> inputConnection = View->GetLightStudy()->GetLoaderOutputConnection();
			if (inputConnection == NULL) {
				//TODO ERROR GORDO
				return;
			}
			int nc = 3;
			inputConnection->GetProducer()->UpdateInformation();
			vtkInformationVector* iv = inputConnection->GetProducer()->GetExecutive()->GetOutputInformation();
			if (iv->GetNumberOfInformationObjects() == 1) {
				vtkInformation* io = iv->GetInformationObject(0);
				vtkInformation* scalarInfo = vtkDataObject::GetActiveFieldInformation(io, vtkImageData::FIELD_ASSOCIATION_POINTS, vtkDataSetAttributes::SCALARS);
				if (scalarInfo && scalarInfo->Has(vtkImageData::FIELD_NUMBER_OF_COMPONENTS()))
				{
					nc = scalarInfo->Get( vtkImageData::FIELD_NUMBER_OF_COMPONENTS() );
				} else {
					//TODO error gordo
				}
				int extent[6] = {0, 0, 0, 0, 0, 0};
				vtkInformationIntegerVectorKey* k = vtkStreamingDemandDrivenPipeline::WHOLE_EXTENT();
				if (io->Has(k)) {
					io->Get(k, extent);
					pInternalMembers->DimensionsOriginal[0] = extent[1] + 1;
					pInternalMembers->DimensionsOriginal[1] = extent[3] + 1;
					pInternalMembers->DimensionsOriginal[2] = extent[5] + 1;
				}
			} else {
				//TODO error gordo
			}
			
			if (nc == 1) {
				//black and white...
				vtkLookupTable* tbl = vtkLookupTableManager::GetLinearLookupTable();
				pInternalMembers->LookupTable = tbl;
				tbl->Delete();

				GNC::GCS::IControladorHerramientas* cH = View->GetLightStudy()->Entorno->GetControladorHerramientas();
				LightVisualizator::IToolWindowLevelLight*            hWL = NULL;
				try {
					// Subscribimos la vista al contrato de puntero
					hWL = cH->ObtenerHerramientaConcreta<LightVisualizator::IToolWindowLevelLight>(LightVisualizator::IToolWindowLevelLight::ID);
					if (hWL != NULL) {
						((GNC::GCS::IContratable<LightVisualizator::IContratoWindowLevelLight>*)hWL)->Subscribir(View, this);
					}
				}
				catch (GNC::GCS::ControladorHerramientasException& ex) {
					std::cerr << "Error al obtener la herramienta: No se pudo subscribir la herramienta: " << ex.getCause() << std::endl;
				}
			}

			pInternalMembers->ImageScale = vtkSmartPointer<vtkImageResample>::New();
			pInternalMembers->ImageScale->SetInputConnection(inputConnection);
			pInternalMembers->ImageScale->GetInput()->ReleaseDataFlagOn();
			pInternalMembers->ImageScale->GetOutput()->ReleaseDataFlagOn();
			pInternalMembers->ImageScale->ReleaseDataFlagOn();

			SetSlice(0, true);
			Thaw();
		}

		void GLightVisualizatorView::OnZoomChoice(wxCommandEvent &event)
		{
			if (m_pZoom->GetSelection() == 0) {
				SetZoom(-1);				
			} else {
				long zoom = 0;
				std::istringstream istr(std::string(m_pZoom->GetStringSelection().ToUTF8()));
				istr >> zoom;
				if (zoom != 0) {
					SetZoom(zoom);
				}
			}
		}

		void GLightVisualizatorView::OnSize(wxSizeEvent& event)
		{
			if (m_pZoom->GetSelection() == 0) {
				SetZoom(-1);				
			} else {
				Layout();
			}
			event.Skip(true);
		}


		void GLightVisualizatorView::RefreshPipeline()
		{
			pInternalMembers->ImageScale->Update();	
			vtkSmartPointer<vtkImageData> pImgScaled = pInternalMembers->ImageScale->GetOutput();
			pImgScaled->Update();

			int nc = pImgScaled->GetNumberOfScalarComponents();
			if (nc == 1) {
				//firstly calculate window/level
				if (AutoWindowLevel) {
					if (HasDefaultWindowLevel()) {
						GNC::GCS::IContratoWindowLevel::WindowLevel wl = GetAndSetDefaultWindowLevel();
						CurrentWindow = wl.m_window;
						CurrentLevel = wl.m_level;
					} else {
						double range[2];
						pImgScaled->GetScalarRange(range);

						CurrentWindow = range[1]-range[0];
						CurrentLevel = 0.5*(range[1]+range[0]);
					}
				}

				double v_min = CurrentLevel - 0.5 * CurrentWindow;
				double v_max = CurrentLevel + 0.5 * CurrentWindow;

				pInternalMembers->LookupTable->SetRange(v_min, v_max);
			

				vtkDataArray *pArray = pImgScaled->GetPointData()->GetScalars();
				vtkUnsignedCharArray* pMapped = pInternalMembers->LookupTable->MapScalars(pArray, VTK_COLOR_MODE_MAP_SCALARS, 0);

				wxImage image(pImgScaled->GetDimensions()[0], pImgScaled->GetDimensions()[1]);				

				unsigned char* dataRGB = image.GetData();
				unsigned char* dataRGBA = pMapped->GetPointer(0);
				int sizeOfImage = pImgScaled->GetDimensions()[0]*pImgScaled->GetDimensions()[1]*3;
				for (int j = 0, i = 0; j < sizeOfImage;) {
					dataRGB[j++] = dataRGBA[i++];
					dataRGB[j++] = dataRGBA[i++];
					dataRGB[j++] = dataRGBA[i++];
					i++;
				}
				pMapped->Delete();
				if (m_pBitmap != NULL) {
					delete m_pBitmap;
				}
				m_pBitmap = new wxBitmap(image);
			} else {
				if (m_pBitmap != NULL) {
					delete m_pBitmap;
				}
				//maybe we have to rescale...
				const unsigned int psize = pImgScaled->GetDimensions()[0]*pImgScaled->GetDimensions()[1];
				double range[2] = {0.0, 1.0};
				pImgScaled->GetScalarRange(range);
				double diff = range[1] - range[0];

				switch (pImgScaled->GetScalarType()) {
					case VTK_UNSIGNED_CHAR:
						{
							if (nc == 3) {
								wxImage image(pImgScaled->GetDimensions()[0], pImgScaled->GetDimensions()[1], (unsigned char*)pImgScaled->GetScalarPointer(), true);
								m_pBitmap = new wxBitmap(image);
							} else {
								//ignore components > 3
								wxImage image(pImgScaled->GetDimensions()[0], pImgScaled->GetDimensions()[1]);				
								unsigned char* dst = image.GetData();
								char* src = (char*)pImgScaled->GetScalarPointer();
								for (unsigned int i = 0; i < psize; i++) {
									for (unsigned int j = 0; j < 4; j++) {
										if (j < 3) {
											if (j < nc) {
												*(dst++) =  *(src++);
											} else {
												*(dst++) = 255;
											}
										} else {
											if (j < nc) {
												src++;
											}
										}
									}
								}
							}
						}
						break;
					case VTK_CHAR:
						{
							if (diff < std::numeric_limits<double>::epsilon() ) {
								range[0] = (double) std::numeric_limits<char>::min();
								range[1] = (double) std::numeric_limits<char>::max();
								diff = range[1] - range[0];
							}

							double scale = 255.0 / diff;
							
							wxImage image(pImgScaled->GetDimensions()[0], pImgScaled->GetDimensions()[1]);				
							unsigned char* dst = image.GetData();
							char* src = (char*)pImgScaled->GetScalarPointer();
							for (unsigned int i = 0; i < psize; i++) {
								for (unsigned int j = 0; j < 4; j++) {
									if (j < 3) {
										if (j < nc) {
											const unsigned char v = (unsigned char) ( scale * ((double) *(src++)) );
											*(dst++) =  v;
										} else {
											*(dst++) = 255;
										}
									} else {
										if (j < nc) {
											src++;
										}
									}
								}
							}
						}
						break;
					case VTK_UNSIGNED_SHORT:
						{
							if (diff < std::numeric_limits<double>::epsilon() ) {
								range[0] = (double) std::numeric_limits<unsigned short>::min();
								range[1] = (double) std::numeric_limits<unsigned short>::max();
								diff = range[1] - range[0];
							}

							double scale = 255.0 / diff;

							
							wxImage image(pImgScaled->GetDimensions()[0], pImgScaled->GetDimensions()[1]);				

							unsigned char* dst = image.GetData();
							unsigned short* src = (unsigned short*)pImgScaled->GetScalarPointer();
							for (unsigned int i = 0; i < psize; i++) {
								for (unsigned int j = 0; j < 4; j++) {
									if (j < 3) {
										if (j < nc) {
											const unsigned char v = (unsigned char) ( scale * ((double) *(src++)) );
											*(dst++) =  v;
										} else {
											*(dst++) = 255;
										}
									} else {
										if (j < nc) {
											src++;
										}
									}
								}
							}
							m_pBitmap = new wxBitmap(image);
						}
						break;
						case VTK_SHORT:
						{
							if (diff < std::numeric_limits<double>::epsilon() ) {
								range[0] = (double) std::numeric_limits<short>::min();
								range[1] = (double) std::numeric_limits<short>::max();
								diff = range[1] - range[0];
							}

							double scale = 255.0 / diff;

							
							wxImage image(pImgScaled->GetDimensions()[0], pImgScaled->GetDimensions()[1]);				

							unsigned char* dst = image.GetData();
							short* src = (short*)pImgScaled->GetScalarPointer();
							for (unsigned int i = 0; i < psize; i++) {
								for (unsigned int j = 0; j < 4; j++) {
									if (j < 3) {
										if (j < nc) {
											const unsigned char v = (unsigned char) ( scale * ((double) *(src++)) );
											*(dst++) =  v;
										} else {
											*(dst++) = 255;
										}
									} else {
										if (j < nc) {
											src++;
										}
									}
								}
							}
							m_pBitmap = new wxBitmap(image);
						}
						break;
						case VTK_INT:
						{
							if (diff < std::numeric_limits<double>::epsilon() ) {
								range[0] = (double) std::numeric_limits<int>::min();
								range[1] = (double) std::numeric_limits<int>::max();
								diff = range[1] - range[0];
							}

							double scale = 255.0 / diff;

							
							wxImage image(pImgScaled->GetDimensions()[0], pImgScaled->GetDimensions()[1]);				

							unsigned char* dst = image.GetData();
							int* src = (int*)pImgScaled->GetScalarPointer();
							for (unsigned int i = 0; i < psize; i++) {
								for (unsigned int j = 0; j < 4; j++) {
									if (j < 3) {
										if (j < nc) {
											const unsigned char v = (unsigned char) ( scale * ((double) *(src++)) );
											*(dst++) =  v;
										} else {
											*(dst++) = 255;
										}
									} else {
										if (j < nc) {
											src++;
										}
									}
								}
							}
							m_pBitmap = new wxBitmap(image);
						}
						break;
						case VTK_UNSIGNED_INT:
						{
							if (diff < std::numeric_limits<double>::epsilon() ) {
								range[0] = (double) std::numeric_limits<unsigned int>::min();
								range[1] = (double) std::numeric_limits<unsigned int>::max();
								diff = range[1] - range[0];
							}

							double scale = 255.0 / diff;

							
							wxImage image(pImgScaled->GetDimensions()[0], pImgScaled->GetDimensions()[1]);				

							unsigned char* dst = image.GetData();
							unsigned int* src = (unsigned int*)pImgScaled->GetScalarPointer();
							for (unsigned int i = 0; i < psize; i++) {
								for (unsigned int j = 0; j < 4; j++) {
									if (j < 3) {
										if (j < nc) {
											const unsigned char v = (unsigned char) ( scale * ((double) *(src++)) );
											*(dst++) =  v;
										} else {
											*(dst++) = 255;
										}
									} else {
										if (j < nc) {
											src++;
										}
									}
								}
							}
							m_pBitmap = new wxBitmap(image);
						}
						break;
						case VTK_FLOAT:
						{
							if (diff < std::numeric_limits<double>::epsilon() ) {
								range[0] = (double) std::numeric_limits<float>::min();
								range[1] = (double) std::numeric_limits<float>::max();
								diff = range[1] - range[0];
							}

							double scale = 255.0 / diff;

							
							wxImage image(pImgScaled->GetDimensions()[0], pImgScaled->GetDimensions()[1]);				

							unsigned char* dst = image.GetData();
							float* src = (float*)pImgScaled->GetScalarPointer();
							for (unsigned int i = 0; i < psize; i++) {
								for (unsigned int j = 0; j < 4; j++) {
									if (j < 3) {
										if (j < nc) {
											const unsigned char v = (unsigned char) ( scale * ((double) *(src++)) );
											*(dst++) =  v;
										} else {
											*(dst++) = 255;
										}
									} else {
										if (j < nc) {
											src++;
										}
									}
								}
							}
							m_pBitmap = new wxBitmap(image);
						}
						break;
						case VTK_DOUBLE:
						{
							if (diff < std::numeric_limits<double>::epsilon() ) {
								range[0] = (double) std::numeric_limits<double>::min();
								range[1] = (double) std::numeric_limits<double>::max();
								diff = range[1] - range[0];
							}

							double scale = 255.0 / diff;

							
							wxImage image(pImgScaled->GetDimensions()[0], pImgScaled->GetDimensions()[1]);				

							unsigned char* dst = image.GetData();
							double* src = (double*)pImgScaled->GetScalarPointer();
							for (unsigned int i = 0; i < psize; i++) {
								for (unsigned int j = 0; j < 4; j++) {
									if (j < 3) {
										if (j < nc) {
											const unsigned char v = (unsigned char) ( scale * ((double) *(src++)) );
											*(dst++) =  v;
										} else {
											*(dst++) = 255;
										}
									} else {
										if (j < nc) {
											src++;
										}
									}
								}
							}
							m_pBitmap = new wxBitmap(image);
						}
						break;
					default:
						LOG_ERROR("GLightVisualizatorView", "Pixel data not supported");
						return;
				}
				//end rescale range
			}
			m_pImagePanel->SetBitmap(m_pBitmap);
			m_pScrolledImage->SetVirtualSize(m_pBitmap->GetWidth(), m_pBitmap->GetHeight());

			m_pScrolledImage->AdjustScrollbars();

			m_pScrolledImage->Layout();
			Layout();
			this->GetParent()->Layout();
			Refresh(true);
		}


		void GLightVisualizatorView::SetZoom(int zoom, bool force)
		{
			if ((zoom == m_zoom && ! force) || pInternalMembers == NULL) 
				return;	

			if (zoom != -1) {
				m_zoom = zoom;
			} else {
				//ventana
				float widthProportion = (float)this->GetSize().x/pInternalMembers->DimensionsOriginal[0];
				float heightProportion = (float)(this->GetSize().y-20)/pInternalMembers->DimensionsOriginal[1];
				m_zoom =( std::min<float>(widthProportion, heightProportion) *100.0f );
			}

			float factor = (float)m_zoom/100.0f;
			if (factor <= 0) {
				return;
			} 
			pInternalMembers->ImageScale->SetAxisMagnificationFactor(0,factor);
			pInternalMembers->ImageScale->SetAxisMagnificationFactor(1,factor);

			RefreshPipeline();
		}

		void GLightVisualizatorView::OnPaintView( wxPaintEvent& event )
		{
			GLightVisualizatorViewBase::OnPaintView(event);
			if(View->GetEstudio()->Entorno->GetControladorVistas()->GetVistaActiva() == View)
			{
				wxPaintDC dc(this);
				wxColour colorLineaSeleccion(219, 219, 0, 255);
				dc.SetBrush(wxBrush(colorLineaSeleccion,wxTRANSPARENT));
				dc.SetPen(wxPen(colorLineaSeleccion, 2, wxSOLID));
				dc.DrawRectangle(wxRect(wxPoint(1, 1), wxPoint(dc.GetSize().x-1, dc.GetSize().y-1)));
			}
		}

		void GLightVisualizatorView::OnFocus(wxFocusEvent &)
		{
			View->OnFocus();
		}

		void GLightVisualizatorView::OnKeyDown( wxKeyEvent& event )
		{
			switch(event.GetKeyCode()){
				case WXK_RIGHT:
				{
					GoToSlice(m_pSliderSerie->GetValue()+1);
				}
					break;
				case WXK_LEFT:
				{
					GoToSlice(m_pSliderSerie->GetValue()-1);
				}
					break;
				default:
					event.Skip(true);
			}
		}

		void GLightVisualizatorView::OnMouseWheel( wxMouseEvent& event )
		{
			if (event.ControlDown())
			{
				if(event.GetWheelRotation() > 0)
				{
					GoToSlice(m_pSliderSerie->GetValue()+1);
				}
				else
				{
					GoToSlice(m_pSliderSerie->GetValue()-1);
				}
			} else {
				event.Skip(true);
			}
		}

		void GLightVisualizatorView::GoToSlice(int i)
		{
			if (!m_pSliderSerie->IsEnabled()) {
				return;
			}
			if(i>=m_pSliderSerie->GetMin() && i<=m_pSliderSerie->GetMax()){
				m_pSliderSerie->SetValue(i);
				wxScrollEvent evt;
				evt.SetPosition(i);
				OnScrollSeries(evt);
			}
		}

		void GLightVisualizatorView::OnScrollSeries(wxScrollEvent &event)
		{
			unsigned int vid = (unsigned int)event.GetPosition();
			if ((int)vid < 0 ) {
				vid = 0;
			}
			if( (int) vid >= View->GetEstudio()->GetNumeroCortes()) {
				return;
			}
			SetSlice(vid);
		}

		void GLightVisualizatorView::SetSlice(int vid, bool force)
		{
			Freeze();
			if (vid != (unsigned int)View->GetEstudio()->IndiceFicheroActivo || force) {
				View->GetEstudio()->SetIndiceActivo(vid);

				GNC::GCS::IContratoWindowLevel::Setup(*View->GetEstudio()->GetTagsImagenDeImagenActiva());

				SetZoom(m_zoom, true);
				GNC::GCS::Eventos::EventoModificacionImagen* pEvt = new GNC::GCS::Eventos::EventoModificacionImagen(View,GNC::GCS::Eventos::EventoModificacionImagen::SliceCambiado, -1, true);
				View->GetEstudio()->Entorno->GetControladorEventos()->ProcesarEvento(pEvt);
			}

			Thaw();			
		}

		void GLightVisualizatorView::ProcesarEvento(GNC::GCS::Eventos::IEvento *evt)
		{
			switch (evt->GetCodigoEvento()) {
				case ginkgoEVT_Core_ModificacionImagen:
					{
						GNC::GCS::Eventos::EventoModificacionImagen* pEvt = dynamic_cast<GNC::GCS::Eventos::EventoModificacionImagen*>(evt);
						if (pEvt == NULL) {
							std::cerr << "Error al interpretar evento como evento de modificación de imagen: Evento = " << evt << std::endl;
							return;
						}
						switch (pEvt->GetTipo()) {
							case GNC::GCS::Eventos::EventoModificacionImagen::ImagenModificada:
							case GNC::GCS::Eventos::EventoModificacionImagen::ImagenCargada:
							case GNC::GCS::Eventos::EventoModificacionImagen::MapaModificado:
							case GNC::GCS::Eventos::EventoModificacionImagen::SliceCambiado:
							case GNC::GCS::Eventos::EventoModificacionImagen::ImagenRecalibrada:
							case GNC::GCS::Eventos::EventoModificacionImagen::ImagenDescargada:
							case GNC::GCS::Eventos::EventoModificacionImagen::AnotacionesEstaticasModificadas:
								break;
							case GNC::GCS::Eventos::EventoModificacionImagen::VisualizacionImagenModificada:
								{
									SetSlice(View->GetLightStudy()->IndiceFicheroActivo, true);
								}
								break;
						}
					}
					break;
				default:
					break;
			}			
		}
	}
}
