/*
 *  
 *  $Id: entorno.h 4508 2012-01-11 12:53:39Z tovar $
 *  Ginkgo CADx Project
 *
 *  Copyright 2008-10 MetaEmotion S.L. All rights reserved.
 *  http://ginkgo-cadx.com
 *
 *  This file is licensed under LGPL v3 license.
 *  See License.txt for details
 *
 *
 */
#pragma once
#include <list>
#include <string>

#include <api/globals.h>
#include <api/api.h>
#include <api/ientorno.h>
#include <api/icontroladorextensiones.h>
#include <api/icontroladorvistas.h>

#include <api/observers/iviewsobserver.h>
#include <api/observers/iextensionsobserver.h>

class VentanaPrincipal;
class wxWindow;
class wxApp;
class wxSizer;

namespace GNC {
	class EXTAPI Entorno : public GNC::GCS::IEntorno {
	public:

		typedef std::list<GNC::GCS::IObservadorExtensiones*> ListaObservadoresExtensiones;
		typedef std::list<GNC::GCS::IObservadorVistas*>      ListaObservadoresVistas;
		
		bool m_isChildInstance;

	protected:

		/* Constructor */
		Entorno();
		/* Destructor */
		~Entorno();

		static Entorno* m_pInstancia;

	public:
		static Entorno* Instance();
		static void FreeInstance();
		
		
		bool IsChildInstance() {
			return m_isChildInstance;
		}
		
		void SetChildInstance(bool child) {
			m_isChildInstance = child;
		}

		// Miembros estaticos

		virtual const std::string GetGinkgoRegisteredUser();
		virtual const std::string GetGinkgoRegisteredOrganization();

		virtual const std::string& GetGinkgoVersion();
		virtual void GetGinkgoVersionAsTuple(int* version, int* subversion, int* release, int* build, std::string* codename);
		virtual const std::string& GetGinkgoCopyRight();
		virtual int ParseSVNBuild(const char* str);
		virtual std::string GetGinkgoDicomDir(bool barraAlFinal = false);
		virtual void RefrescarDicomDir();

		virtual std::string GetPathAbsolutoFichero(const std::string& pathRelativo);
		virtual std::string GetPathRelativoFichero(const std::string& pathAbsoluto);

		virtual const std::string& GetPluginsPath();
		virtual const std::string& GetGinkgoUserDir();
		virtual const std::string& GetGinkgoTempDir();
		virtual std::string CreateGinkgoTempDir();
		virtual void RemoveDirRecursive(const std::string& path);
		virtual std::string CreateGinkgoTempFile();
		virtual const std::string& GetGinkgoLanguageDir();
		virtual const std::string& GetGinkgoResourcesDir();
		virtual std::string CrearDirectorioTemporal();
		virtual std::string  GetDicomLocalAET();

		std::string ParseAET(const std::string& AET);

		virtual wxApp* GetApp();
		virtual void SetApp(wxApp* app);

		virtual void YieldApp();

		virtual VentanaPrincipal* GetVentanaPrincipal();
		virtual void SetVentanaPrincipal(VentanaPrincipal* ventana);

		virtual wxWindow* GetVentanaRaiz();
		virtual void SetVentanaRaiz(wxWindow* window);

		virtual wxPanel* GetPanelHerramientasSuperior();
		virtual void SetPanelHerramientasSuperior(wxPanel* panel);

		virtual wxSizer* GetSizerHerramientas();
		virtual void SetSizerHerramientas(wxSizer* sizer);
		wxSizer* GetSizerHerramientasOpciones();
		virtual void SetSizerHerramientasOpciones(wxSizer* sizer);

		virtual GNC::GCS::IControladorComandos* GetControladorComandos();

		virtual GNC::GCS::IControladorHerramientas* GetControladorHerramientas();

		virtual GIL::DICOM::IPACSController* GetPACSController();

		virtual GNC::GCS::IControladorVistas* GetControladorVistas();

		virtual GNC::GCS::IControladorEventos* GetControladorEventos();

		virtual GNC::GCS::IControladorCarga* GetControladorCarga();

		virtual GNC::GCS::IControladorPermisos* GetControladorPermisos();

		virtual GNC::GCS::IControladorLog* GetControladorLog();

		virtual GNC::GCS::IControladorExtensiones* GetControladorExtensiones();

		virtual GNC::GCS::IControladorHistorial* GetControladorHistorial();

		virtual GNC::GCS::IControladorAcciones*  GetControladorAcciones();

		virtual GNC::GCS::IControladorInternacionalizacion*  GetControladorInternacionalizacion();

		virtual GNC::GCS::IConfigurationController* GetConfigurationController();

		virtual GNC::GCS::IWidgetsManager* NewWidgetsManager(GNC::GCS::IVista* pVista);
		virtual void FreeWidgetsManager(GNC::GCS::IWidgetsManager* pManager);

		virtual GNC::GCS::IEntorno::ListaModelosIntegracion& GetModelosIntegracion() { return m_ModelosIntegracion; }

		virtual GNC::GCS::IEntorno::MapaUbicaciones& GetUbicaciones() { return m_Ubicaciones; }

	private:
		std::string m_GinkgoVersion;
		std::string m_GinkgoCopyRight;
		std::string m_GinkgoPluginsDir;
		std::string m_GinkgoUserDir;
		std::string m_GinkgoTempDir;
		std::string m_GinkgoDicomDir;
		std::string m_GinkgoLanguageDir;
		std::string m_GinkgoResourcesDir;

		GNC::GCS::IEntorno::ListaModelosIntegracion m_pModelosIntegracion;

		wxApp* m_pApp;
		VentanaPrincipal* m_pVentanaPrincipal;
		wxWindow* m_pVentanaRaiz;
		wxPanel* m_pPanelHerramientasSuperior;
		wxSizer* m_pSizerHerramientas;
		wxSizer* m_pSizerOpcionesHerramientas;

	public:

		//region "Listas de observadores"
		// Las listas de observadores estan aqui para que la subscripcion sea mas transparente
		ListaObservadoresExtensiones ObservadoresExtensiones;
		//ListaObservadoresEstudios ObservadoresEstudios;
		ListaObservadoresVistas ObservadoresVistas;
		//endregion

		friend class ::VentanaPrincipal;
	};
}
