/*
 *
 *  $Id: panelconfiguracionpermisos.cpp 4477 2011-12-13 11:16:56Z tovar $
 *  Ginkgo CADx Project
 *
 *  Copyright 2008-10 MetaEmotion S.L. All rights reserved.
 *  http://ginkgo-cadx.com
 *
 *  This file is licensed under LGPL v3 license.
 *  See License.txt for details
 *
 *
 */
#include <vector>
#include <sstream>
#include <limits>

#include <wx/msgdlg.h>
#include <wx/msgout.h>
#include <wx/filename.h>
#include <main/controllers/configurationcontroller.h>
#include <wx/valtext.h>
#include <wx/ginkgostyle/ginkgostyle.h>
#include <wx/mstream.h>

#include <wx/file.h>
#include <wx/dir.h>
#include <wx/log.h>
#include <wx/busyinfo.h>
#include <wx/xml/xml.h>
#include <wx/log.h>

#include <wx/tokenzr.h>

#include "panelconfiguracionpermisos.h"

#include <sstream>

#include <main/controllers/controladorextensiones.h>
#include <main/controllers/controladorlog.h>
#include <main/controllers/controladorpermisos.h>
#include <main/entorno.h>

#define SEPARADOR "|"


namespace GNC {
	namespace GUI {

		class ProfileDialog: public ProfileDialogBase
		{
			typedef struct TipoPermiso {
				std::string clave;
				bool valor;

				TipoPermiso() {}

				TipoPermiso(const std::string& clave, bool valor)
				{
					this->clave = clave;
					valor = valor;
				}
			} TipoPermiso;
			typedef std::map <std::string, GNC::GCS::Permisos::EstadoPermiso> TipoMapaPermisos;
		public:
			ProfileDialog(wxWindow* pParent, std::list<std::string>& listaNombres, bool isnew = false):ProfileDialogBase(pParent)
			{

				m_Ok = false;
				m_listaNombres = listaNombres;

				if (isnew) {

					long     idNombreAutomatico = 0;
					std::string profile_template = _Std("Profile");
					std::string nombre_automatico;

					for (std::list<std::string>::iterator it = listaNombres.begin(); it != listaNombres.end(); it++)
					{
						std::istringstream is (*it);
						std::string t_name;
						long id = -1;
						is >> t_name >> id;

						if (!is.fail() && t_name == profile_template && id > 0) {
							idNombreAutomatico = std::max<long>(id, idNombreAutomatico);
						}

					}
					{
						std::ostringstream os;
						os << profile_template << " " << (idNombreAutomatico + 1);
						m_pName->SetValue( wxString::FromUTF8( os.str().c_str() ) );
					}
				}

				const GNC::GCS::ControladorPermisos::TipoMapaDefiniciones& definiciones = GNC::GCS::ControladorPermisos::Instance()->GetMapaDefiniciones();

				//bool defaultValue = GNC::GCS::ControladorPermisos::Instance()->GetDefaultPermiso();
				//cargamos los permisos "publicos" definidos
				std::string ultimaCategoria = "";
				wxPGProperty* cat = NULL;
				m_gridPermisos->SetColumnCount(4);
				m_gridPermisos->MakeColumnEditable(2, true);
				m_gridPermisos->SetColumnProportion(0, 3);
				m_gridPermisos->SetColumnProportion(1, 1);
				m_gridPermisos->SetColumnProportion(2, 2);
				m_gridPermisos->SetColumnProportion(3, 2);
				for(GNC::GCS::ControladorPermisos::TipoMapaDefiniciones::const_iterator it = definiciones.begin(); it != definiciones.end(); ++it)
				{
					if(!(*it).second.privado) {
						if ((*it).second.espacioNombres != ultimaCategoria) {
							ultimaCategoria = (*it).second.espacioNombres;
							cat = m_gridPermisos->Append(new wxPropertyCategory(wxString::FromUTF8((*it).second.descripcionNamespace.c_str()),wxString::FromUTF8(ultimaCategoria.c_str())));
						}
						std::string clave = (*it).second.espacioNombres + SEPARADOR + (*it).second.id;
						wxPGProperty* prop = cat->AppendChild(new wxBoolProperty(wxString::FromUTF8((*it).second.descripcion.c_str()), wxString::FromUTF8(clave.c_str()), (*it).second.activoPorDefecto ) );
						prop->SetCell(2, new wxPGCell( wxString::FromUTF8( ((*it).second.valorPorDefecto).c_str())) );
						prop->SetCell(3, new wxPGCell( _("Default value") ));
					}
				}
			}

			~ProfileDialog()
			{

			}

			void GetParametros(std::string &nombre, std::string &xml)
			{
				nombre = std::string(m_pName->GetValue().ToUTF8());

				//transformamos lo que esta viendo el usuario a un xml...
				std::ostringstream ostr;
				ostr << "<?xml version=\"1.0\"?>\n";
				ostr << "<permisos>\n";

				for(wxPropertyGridIterator it = m_gridPermisos->GetIterator(); !it.AtEnd(); it.Next())
				{
					wxBoolProperty* pProperty = (wxBoolProperty*) it.GetProperty();

					wxString clave = pProperty->GetName();


					wxStringTokenizer tkz(clave, wxString::FromUTF8(SEPARADOR));
					std::string espacioNombres ="", id="";
					if ( tkz.HasMoreTokens() )
					{
						espacioNombres = tkz.GetNextToken().ToUTF8();
						if (tkz.HasMoreTokens()) {
							id = tkz.GetNextToken().ToUTF8();
						}
					}

					if (id != "" && espacioNombres != "") {

						std::string stdclave( espacioNombres + "." + id );

						std::string accion;
						if (pProperty->GetValue()) {
							accion = "activar";
						} else {
							accion = "desactivar";
						}

						std::string val(pProperty->GetCell(2)->GetText().ToUTF8());
						std::string activopordefecto = "true";

						GNC::GCS::ControladorPermisos::TipoMapaDefiniciones mapa = GNC::GCS::ControladorPermisos::Instance()->GetMapaDefiniciones();
						GNC::GCS::ControladorPermisos::TipoMapaDefiniciones::iterator it = mapa.find(stdclave);
						GNC::GCS::ControladorPermisos::TipoDefinicionPermiso def;

						if (it != mapa.end()) {
							def = (*it).second;
						}

						if (!def.activoPorDefecto) {
							activopordefecto = "false";
						}

						ostr << "<permiso namespace=\"" << espacioNombres << "\" id=\"" << id << "\" valorpordefecto=\"" << def.valorPorDefecto << "\" activopordefecto=\"" << activopordefecto << "\" accion=\"" << accion << "\" valor=\"" << val << "\"/>" << std::endl;
					}
				}
				ostr << "</permisos>\n";
				xml = ostr.str();
			}

			void SetParametros(const std::string &nombre, const std::string &xml)
			{
				m_nombreEditar = nombre;
				m_pName->SetValue(wxString::FromUTF8(nombre.c_str()));

				TipoMapaPermisos mapa = GetPermisosFromXml(xml);

				for(wxPropertyGridIterator it = m_gridPermisos->GetIterator(); !it.AtEnd(); it.Next())
				{
					wxBoolProperty* pProperty = dynamic_cast<wxBoolProperty*> (it.GetProperty());
					if(pProperty != NULL) {

						wxStringTokenizer tkz(pProperty->GetName(), wxString::FromUTF8(SEPARADOR));
						std::string espacioNombres = "" , id = "";
						if ( tkz.HasMoreTokens() )
						{
							espacioNombres = tkz.GetNextToken().ToUTF8();
							if (tkz.HasMoreTokens()) {
								id = tkz.GetNextToken().ToUTF8();
							}
						}

						/*
						GNC::GCS::Permisos::EstadoPermiso perm = //GNC::GCS::ControladorPermisos::Instance()->Get(espacioNombres + "." + id);
						pProperty->SetValue((bool)perm);
						*/
						TipoMapaPermisos::iterator itp = mapa.find(std::string(pProperty->GetName().ToUTF8()));
						if (itp != mapa.end()) {
							GNC::GCS::Permisos::EstadoPermiso& perm = (*itp).second;
							pProperty->SetValue( (bool)perm );
							pProperty->GetCell(2)->SetText( wxString::FromUTF8(perm.ObtenerValor<std::string>().c_str()));
							if (perm.TieneValorPorDefecto()) {
								pProperty->GetCell(3)->SetText(_("Default value"));
							}
							else {
								pProperty->GetCell(3)->SetText(_("Set by user"));
							}
						}

					}
				}
				//free memory
			}

			TipoMapaPermisos GetPermisosFromXml(const std::string& stdCadena)
			{
				TipoMapaPermisos permisos;
				try {
					GNC::GCS::ControladorPermisos::TipoMapaPermisosNamespace mapaPermisosNamespace = GNC::GCS::ControladorPermisos::Instance()->GetPermisosFromXML(stdCadena);
					for( GNC::GCS::ControladorPermisos::TipoIteradorMapaPermisosNamespace itNames = mapaPermisosNamespace.begin(); itNames != mapaPermisosNamespace.end(); ++itNames )
					{
						for( GNC::GCS::ControladorPermisos::TipoIteradorMapaPermisos itPermisos = (*itNames).second->begin(); itPermisos != (*itNames).second->end(); ++itPermisos)
						{
							permisos[itNames->first + SEPARADOR + itPermisos->first] = itPermisos->second;
						}
						delete (*itNames).second;
					}
				} catch (GNC::GCS::ControladorPermisosException& ce)
				{
					LOG_WARN("GestionPermisos", "Existe en la configuracin un xml de permisos mal formado " << ce.GetCause());
				}
				return permisos;
			}

			virtual void OnCancelClick(wxCommandEvent &){
				Close();
			}

			virtual void OnOkClick(wxCommandEvent &){
				if (Validar()) {
					m_Ok=true;
					Close();
				}
			}

			bool Validar() {
				if(m_pName->GetValue() != wxEmptyString) {
					//no puede duplicar un nombre que est en la lista y que no sea el mismo
					std::string nombre (m_pName->GetValue().ToUTF8());
					if (nombre != m_nombreEditar) {
						for (std::list<std::string>::iterator it = m_listaNombres.begin(); it != m_listaNombres.end(); ++it)
						{
							if ((*it) == nombre) {
								wxMessageBox(_("Profile name can't be repeated"),_("Info"),wxOK | wxICON_INFORMATION, this);
								return false;
							}
						}
					}
					return true;
				}else{
					wxMessageBox(_("You must fill in name field to continue"),_("Info"),wxOK | wxICON_INFORMATION, this);
				}
				return false;
			}

			bool m_Ok;
			std::list<std::string> m_listaNombres;
			std::string m_nombreEditar;
		};


		////////////////-------------------------------------------------------------------------------------/////////////////////////////

		PanelConfiguracionPermisos::PanelConfiguracionPermisos(wxWindow* pParent,IDialogoConfiguracion* pDialogo): PanelConfiguracionPermisosBase(pParent), IPasoConfiguracion(pDialogo)
		{
			this->m_pTreeListProfiles->AddColumn(_("Name"), 200, wxALIGN_LEFT, -1, true, false);
			this->m_pTreeListProfiles->AddColumn(_("Active"), 50, wxALIGN_LEFT, -1, true, false);
			Recargar();
			m_permisosCambiados = false;

			m_pTreeListProfiles->Connect(wxEVT_COMMAND_TREE_ITEM_ACTIVATED, wxTreeEventHandler( PanelConfiguracionPermisos::OnListaPermisosDClick ), NULL, this );
			m_pTreeListProfiles->Connect(wxEVT_COMMAND_TREE_SEL_CHANGED, wxTreeEventHandler( PanelConfiguracionPermisos::OnListaPermisosChangeSelection ), NULL, this );
		}

		PanelConfiguracionPermisos::~PanelConfiguracionPermisos()
		{
			m_profiles.clear();
		}

		void PanelConfiguracionPermisos::Recargar()
		{
			GNC::GCS::ConfigurationController::TListGroups profiles;
			GNC::GCS::ConfigurationController::Instance()->readGroupGeneral("/GinkgoCore/Profiles", profiles);

			std::string strTmp, xml;
			bool apply;
			bool primero =true;
			m_pTreeListProfiles->DeleteRoot();
			wxTreeItemId idRoot = m_pTreeListProfiles->AddRoot(wxT("Root"));

			for (GNC::GCS::ConfigurationController::TListGroups::iterator it = profiles.begin(); it != profiles.end(); ++it) {
				(*it).readStringValue("Name", strTmp);
				wxTreeItemId idItem = m_pTreeListProfiles->AppendItem(idRoot,wxString::FromUTF8(strTmp.c_str()));
				(*it).readBoolValue("Apply", apply, false);
				(*it).readStringValue("XML", xml);

				if(apply) {
					m_pTreeListProfiles->SetItemText(idItem, 1, _("Yes"));
				} else {
					m_pTreeListProfiles->SetItemText(idItem, 1, _("No"));
				}
				m_profiles.push_back(TipoProfile(strTmp,xml,apply));
				if(primero) {
					m_pTreeListProfiles->SelectItem(idItem);
					m_pBEdit->Enable(true);
					m_pBDelete->Enable(true);
					m_pBActive->Enable(true);
					primero = false;
				}
			}
		}

		//region "Metodos de IPasoConfiguracion"
		wxWindow* PanelConfiguracionPermisos::GetPanel()
		{
			return this;
		}

		std::string PanelConfiguracionPermisos::GetTitle()
		{
			return _Std("Profiles");
		}

		std::string PanelConfiguracionPermisos::GetCabecera()
		{
			return _Std("Profiles Settings");
		}

		bool PanelConfiguracionPermisos::Validar()
		{
			bool ok = true;
			//si modificado... los cambios se aplicarn al volver a reiniciar
			if(m_permisosCambiados) {
				wxMessageBox(_("Ginkgo CADx must restart for the permission changes to take effect"),_("Info"));
			}
			return ok;
		}

		bool PanelConfiguracionPermisos::Guardar()
		{
			GNC::GCS::ConfigurationController::Instance()->deleteEntryGeneral("/GinkgoCore/Profiles");
			GNC::GCS::ConfigurationController::TListGroups profiles;

			for(TipoListaProfiles::iterator it = m_profiles.begin(); it!= m_profiles.end(); it++){
				GNC::GCS::ConfigurationController::TMapValues profile;
				profile["Name"] = (*it).nombre;
				profile.insertBool("Apply", (*it).aplicar);
				profile["XML"] = (*it).xml;
				profiles.push_back(profile);
			}
			GNC::GCS::ConfigurationController::Instance()->writeGroupGeneral("/GinkgoCore/Profiles", profiles, "Profile");

			return true;
		}
		//endregion


		void PanelConfiguracionPermisos::OnListaPermisosDClick(wxTreeEvent& )
		{
			wxCommandEvent evt;
			OnEditarClick(evt);
		}

		void PanelConfiguracionPermisos::OnListaPermisosChangeSelection(wxTreeEvent& event)
		{
			if(event.GetItem().IsOk()) {
				m_pBEdit->Enable(true);
				m_pBDelete->Enable(true);
				m_pBActive->Enable(true);
			} else {
				m_pBEdit->Enable(false);
				m_pBDelete->Enable(false);
				m_pBActive->Enable(false);
			}
		}

		void PanelConfiguracionPermisos::OnSetActive(wxCommandEvent &)
		{
			wxTreeItemId item = m_pTreeListProfiles->GetSelection();
			if (item.IsOk()) {
				std::string nombreSeleccionado( m_pTreeListProfiles->GetItemText(item).ToUTF8() );

				for(TipoListaProfiles::iterator it = m_profiles.begin(); it != m_profiles.end(); it++) {
					if((*it).nombre == nombreSeleccionado) {
						(*it).aplicar = true;
					} else {
						(*it).aplicar = false;
					}
				}

				wxTreeItemIdValue cookie;
				wxTreeItemId itemActual = m_pTreeListProfiles->GetFirstChild(m_pTreeListProfiles->GetRootItem(), cookie);
				while (itemActual.IsOk())
				{
					if (itemActual == item) {
						m_pTreeListProfiles->SetItemText(itemActual,1,_("Yes"));
					} else {
						m_pTreeListProfiles->SetItemText(itemActual,1,_("No"));
					}
					itemActual = m_pTreeListProfiles->GetNextChild(m_pTreeListProfiles->GetRootItem(), cookie);
				}

				OnPropiedadCambiada();
			}
		}

		void PanelConfiguracionPermisos::OnNuevoClick(wxCommandEvent &){
			//se le pasa la lista de identificadores para que no duplique
			std::list<std::string> listaNombres;
			for (TipoListaProfiles::iterator it = m_profiles.begin(); it != m_profiles.end(); ++it)
			{
				listaNombres.push_back((*it).nombre);
			}

			ProfileDialog dialogo(this, listaNombres, true);
			dialogo.ShowModal();
			if(dialogo.m_Ok){
				bool es_unico = false;

				if (m_pTreeListProfiles->GetChildrenCount(m_pTreeListProfiles->GetRootItem(), false) == 0) {
					es_unico = true;
				}

				TipoProfile tp;
				dialogo.GetParametros(tp.nombre, tp.xml);
				tp.aplicar = es_unico;
				m_profiles.push_back(tp);

				wxTreeItemId idItem = m_pTreeListProfiles->AppendItem(m_pTreeListProfiles->GetRootItem(),wxString::FromUTF8(tp.nombre.c_str()));
				if(tp.aplicar) {
					m_pTreeListProfiles->SetItemText(idItem, 1, _("Yes"));
				} else {
					m_pTreeListProfiles->SetItemText(idItem, 1, _("No"));
				}
				m_pTreeListProfiles->SelectItem(idItem);

				OnPropiedadCambiada();
			}
		}

		void PanelConfiguracionPermisos::OnEditarClick(wxCommandEvent &){
			wxTreeItemId item = m_pTreeListProfiles->GetSelection();
			if (item.IsOk()) {
				//se le pasa la lista de identificadores para que no duplique
				std::list<std::string> listaNombres;
				for (TipoListaProfiles::iterator it = m_profiles.begin(); it != m_profiles.end(); ++it)
				{
					listaNombres.push_back((*it).nombre);
				}
				//item seleccionado
				std::string nombreSeleccionado( m_pTreeListProfiles->GetItemText(item).ToUTF8() );

				for(TipoListaProfiles::iterator it = m_profiles.begin(); it != m_profiles.end(); it++){
					if((*it).nombre == nombreSeleccionado) {
						ProfileDialog dialogo(this, listaNombres);

						dialogo.SetParametros((*it).nombre,(*it).xml);

						dialogo.ShowModal();
						if(dialogo.m_Ok){
							dialogo.GetParametros((*it).nombre, (*it).xml);
							//se cambia el nombre en el arbol...
							m_pTreeListProfiles->SetItemText(item, wxString::FromUTF8((*it).nombre.c_str()) );
							OnPropiedadCambiada();
						}
					}
				}
			}
		}

		void PanelConfiguracionPermisos::OnEliminarClick(wxCommandEvent &){
			wxTreeItemId item = m_pTreeListProfiles->GetSelection();
			if(item.IsOk()){
				std::string nombre(m_pTreeListProfiles->GetItemText(item).ToUTF8());
				int answer = wxMessageBox(_("Confirm the removal of the profile ") + wxString::FromUTF8(nombre.c_str()), _("Data modified"), wxYES_NO | wxCANCEL, this);
				if(answer == wxYES){
					for(TipoListaProfiles::iterator it = m_profiles.begin(); it != m_profiles.end(); it++){
						if((*it).nombre == nombre){
							m_pTreeListProfiles->Delete(item);
							m_profiles.erase(it);
							break;
						}
					}
					OnPropiedadCambiada();
				}
			}
		}

		void PanelConfiguracionPermisos::OnPropiedadCambiada()
		{
			m_permisosCambiados = true;
			IPasoConfiguracion::OnPropiedadCambiada();
		}

		void PanelConfiguracionPermisos::OnTextoCambiado(wxCommandEvent & )
		{
		}

		void PanelConfiguracionPermisos::OnSize(wxSizeEvent & event){
			event.Skip(true);
		}
	}
}
