/*
 *
 *  $Id: countdownmessage.cpp 4044 2011-07-22 12:21:07Z tovar $
 *  Ginkgo CADx Project
 *
 *  Copyright 2008-10 MetaEmotion S.L. All rights reserved.
 *  http://ginkgo-cadx.com
 *
 *  This file is licensed under LGPL v3 license.
 *  See License.txt for details
 *
 *
 */

#include "countdownmessage.h"
#include <wx/ginkgostyle/ginkgostyle.h>

namespace GNC {
	namespace GUI {
		CountdownMessage::CountdownMessage(wxWindow* pParent): CountdownMessageBase(pParent)
		{
			m_last = 5;
			m_pLabelInactivity->SetLabel(wxString::Format(_("Ginkgo CADx has detected inactivity and it will be closed in %d seconds.\nDo you want to continue?"), m_last));
			m_pFormPanel->Layout();
			m_pBody->Layout();
			Layout();
			m_cancelled = false;
			this->Start(1000, true);
		}

		CountdownMessage::~CountdownMessage()
		{
		}

		bool CountdownMessage::Cancel()
		{
			return m_cancelled;
		}

		void CountdownMessage::Notify()
		{
			Freeze();
			if (m_last > 0) {
				m_last--;
				m_pLabelInactivity->SetLabel(wxString::Format(_("Ginkgo CADx has detected inactivity and it will be closed in %d seconds.\nDo you want to continue?"), m_last));
				m_pFormPanel->Layout();
				m_pBody->Layout();
				Layout();
				this->Start(1000, true);
			} else {
				Close();
			}
			Thaw();
		}

		void CountdownMessage::OnCancel(wxCommandEvent &)
		{
			m_cancelled = true;
			Close();
		}
	}
}
