/*
 *  
 *  $Id: panelserie.h 4501 2011-12-20 11:13:41Z carlos $
 *  Ginkgo CADx Project
 *
 *  Copyright 2008-10 MetaEmotion S.L. All rights reserved.
 *  http://ginkgo-cadx.com
 *
 *  This file is licensed under LGPL v3 license.
 *  See License.txt for details
 *
 *
 */
#pragma once

#include "panelhistorial2base.h"
#include "ipanelhistorial.h"
#include <list>
#include <map>
#include <yasper/yasper.h>
#include <main/controllers/controladorhistorial.h>
#include <api/icontroladoreventos.h>

#include <wx/timer.h>
#include <wx/effects.h>

namespace GNC {
	namespace GCS {
		class IVista;
		class IControladorModulo;
	}
	namespace GUI {
		class NotificadorPreview;
	}
}

namespace GIL{
	class IModeloIntegracion;
}

namespace GNC {
	namespace GUI {
		class TimerPanelSerie;
		class PanelSerie: public PanelSerieBase, public ISeleccionableHistorial, public INodoHistorial, public IAbribleHistorial {
		public:
			PanelSerie(INodoHistorial* pPadre,  wxWindow* pParentWindow, const std::string& descripcion, const std::string& fecha,
				const std::string& hora, const std::string& id_importador, const std::string& id_modalidad, const std::string& uidSerie,
				const int numeroSlices, const std::string& uidEstudio, const std::string uidTransferSyntax);
			~PanelSerie();
			void SetModeloIntegracion (GnkPtr<GIL::IModeloIntegracion> pModeloIntegracion);

			std::list<GNC::GCS::IVista*> m_pVistas;

			void Seleccionar(bool seleccionar,bool force=false);
			void SetAbierto(bool abierto);
			void SetModificado(bool modificado);
			void UpdateStatus();
			void SetImage(wxImage* pImage);
			void GenerarThumbnail();
			void OnTimerParpadeo();

			//eventos
			virtual void OnMouseAbrir(wxMouseEvent& event);
			virtual void OnMouseSeleccionar(wxMouseEvent &event);
			virtual void OnMenuMouse(wxMouseEvent &event);
			virtual void OnKeyDown(wxKeyEvent &event);
			virtual void OnMouseWheel( wxMouseEvent& event );
			//

			int RefrescarNumeroSlices();
			void IncrementarNumeroSlices();
		//	bool InsertarDCM(const GNC::GCS::ControladorHistorial::ModeloDCM& modeloDCM);

			//movidas de estudio para ver si esta abierto y tal
			virtual void AddVista(GNC::GCS::IVista* pVista);
			virtual void VistaModificada(GNC::GCS::IVista* pVista);
			virtual void VistaGuardada(GNC::GCS::IVista* pVista);
			virtual void RemoveVista(GNC::GCS::IVista* pVista);
			//
			void OnAbrir(wxCommandEvent& event);
			void Abrir(bool forzarEstudio = false);
			void OnAbrirCon(wxCommandEvent& event);
			void AbrirDICOM(GNC::GCS::IControladorModulo* pModulo, int idModo, bool forzarEstudio);
			void OnEliminar(wxCommandEvent &event);
			bool DoDelete(bool ask);
			void OnLimpiarHistorial(wxCommandEvent &event);
			void OnUploadPACS(wxCommandEvent &event);
			void OnReprocessIntegration(wxCommandEvent &event);

			void Detach(wxWindow* pHijo);
			void Eliminar();
			void OnPaint(wxPaintEvent &event);
			
			std::string GetModalidad();

		protected:

			bool m_modificado;
			//en una serie todo deberia importarse con el mismo importador, y todo deberia ser de la misma modalidad...
			GnkPtr<GIL::IModeloIntegracion> m_pModeloIntegracion;
			int					  m_numeroSlices;
			std::string			  m_uidEstudio;
			std::string			  m_uidSerie;
			std::string         m_idImportador;
			std::string         m_idModalidad;
			std::string			  m_uidTransferSyntax;
			NotificadorPreview* m_pNotificadorPreview;
			TimerPanelSerie*    m_pTimer;
			wxWindow*           m_pBWin;
			bool					  m_dibujada;
		};
	}
}
