/*
 *  
 *  $Id: toolslider.cpp 4492 2011-12-14 11:14:13Z tovar $
 *  Ginkgo CADx Project
 *
 *  Copyright 2008-10 MetaEmotion S.L. All rights reserved.
 *  http://ginkgo-cadx.com
 *
 *  This file is licensed under LGPL v3 license.
 *  See License.txt for details
 *
 *
 */
//#define _GINKGO_TRACE
#include <api/globals.h>
#include <api/iwidgetsmanager.h>
#include "toolslider.h"
#include <resources/ginkgoresourcemanager.h>


#include <iostream>
#ifdef __DEPRECATED
#undef __DEPRECATED
#endif
#include <vtk/vtkginkgoimageviewer.h>


GNC::ToolSlider::ToolSlider() {
	m_Activa = false;

	m_Descripcion = _Std("Browse slices\tCtrl+S");
	m_Icono = GinkgoResourcesManager::IconosHerramientas::GetIcoSlider();
	m_pBuilder = NULL;
}

GNC::ToolSlider::~ToolSlider() {
	;
}

//region "Realización de la interfaz IHerramienta"

void GNC::ToolSlider::CrearPaneles( wxPanel* /*panel*/ ) {
	m_pAbstractPanelHerramientaOpciones = NULL;
}

void GNC::ToolSlider::ConectarContratoFalso(bool activar) {
	if (TContractableWidgets::m_pListaActiva == NULL) {
		//std::cerr << "Error: Se trato de activar el modo deshabilitado de una vista sin haber asignado la vista activa. Error en la logica de activacion. Accion ignorada" << std::endl;
		return;
	}

	for (TContractableWidgets::IteradorListaContratos it = TContractableWidgets::m_pListaActiva->begin(); it != TContractableWidgets::m_pListaActiva->end(); it++) {
		TContratoWidgets* pC = (*it);
		if (pC->Inicializado()) {
			pC->GetManager()->EnableAnotacionDinamica(activar);
			if (activar) {
				pC->GetViewer()->SetInteractionStyle(vtkGinkgoImageViewer::ZOOM_INTERACTION);
				pC->GetManager()->SetCursor(GNC::GCS::Widgets::CUR_FLECHA);
				GTRACE( "ToolSlider: Conectando contrato falso de vista " << TContractableWidgets::m_pVistaActiva );
			} else {
				pC->GetViewer()->SetInteractionStyle(vtkGinkgoImageViewer::ZOOM_INTERACTION);
				pC->GetManager()->SetCursor(GNC::GCS::Widgets::CUR_FLECHA);
				GTRACE( "ToolSlider: Desconectando contrato falso de vista " << TContractableWidgets::m_pVistaActiva );
			}
		}
	}
}

void GNC::ToolSlider::SetVistaActiva(GNC::GCS::IVista* pVista) {
	if (pVista == NULL) {
		;
	}
	TContractableWidgets::EstablecerVistaActiva(pVista);
	TContractableTool::EstablecerVistaActiva(pVista);
	GTRACE("GNC::ToolSlider::SetVistaActiva(" <<  pVista << ")");

}

void GNC::ToolSlider::ConectarContratos(bool activar) {

	TContractableWidgets::ListaContratos* lista1 = TContractableWidgets::ObtenerContratosDeActiva();
	TContractableTool::ListaContratos* lista2  = TContractableTool::ObtenerContratosDeActiva();
	if (lista1 == NULL || lista2 == NULL) {
		if (activar) {
			std::cerr << "Error: Se trataron de conectar contratos sin haber asignado la vista activa. Error en la logica de activacion. Accion ignorada" << std::endl;
		} else {
			if (m_pBuilder != NULL)
			{
				delete m_pBuilder;
				m_pBuilder = NULL;
			}
		}
		return;
	}
	
	TContractableWidgets::IteradorListaContratos it1 = lista1->begin();
	for (TContractableTool::IteradorListaContratos it2 = lista2->begin(); it1 != lista1->end() && it2 != lista2->end(); it1++, it2++) {
		TContratoWidgets* pC = (*it1);
		TContractTool* pS = (*it2);
		if (pC->Inicializado()) {
			if (activar) {
				GTRACE( "ToolSlider: Conectando contratos de vista " << TContractableWidgets::m_pVistaActiva );
				m_pBuilder = new TBuilder(pC->GetManager(), pS, GetTriggerButton(), (unsigned long)this);
				pC->GetViewer()->SetInteractionStyle(vtkGinkgoImageViewer::ZOOM_INTERACTION);
				pC->GetManager()->SetCursor(m_pBuilder->GetCursor());
			}
			else {
				GTRACE( "ToolSlider: Desconectando contratos de vista " << TContractableWidgets::m_pVistaActiva );
				pC->GetViewer()->SetInteractionStyle(vtkGinkgoImageViewer::ZOOM_INTERACTION);
				pC->GetManager()->SetCursor(GNC::GCS::Widgets::CUR_FLECHA);
				// DesSubscribimos los eventos de la ventana a un metodo especifico del panel de esta herramienta
				if (m_pBuilder != NULL) {
					delete m_pBuilder;
					m_pBuilder = NULL;
				}
			}
		}
	}
}

//endregion


//region "Eventos refinados desde los paneles"

//endregion
