/*
 *  
 *  $Id: wanotacionposicion.cpp 3535 2011-03-18 17:57:05Z carlos $
 *  Ginkgo CADx Project
 *
 *  Copyright 2008-10 MetaEmotion S.L. All rights reserved.
 *  http://ginkgo-cadx.com
 *
 *  This file is licensed under LGPL v3 license.
 *  See License.txt for details
 *
 *
 */
//#define _GINKGO_TRACE

#include "wanotacionposicion.h"
#include <api/ianotador.h>

#include <main/managers/widgetsmanager.h>
#include <eventos/eventosginkgo.h>
#include <main/entorno.h>
#include <main/controllers/controladoreventos.h>


//region "Constructor y destructor"

GNC::GCS::Widgets::WAnotacionPosicion::WAnotacionPosicion(GNC::GCS::IAnotador* annotator, IWidgetsManager* pManager, long vid, const char* nombre, long gid) : GNC::GCS::Widgets::IWidget(pManager, vid, nombre, gid)
{
	m_Oculto = false;
	m_TopLevel = true;
	m_ReservaRecursos = false;
	m_pAnnotator = annotator;
	
	GTRACE("Anotador posicion creado");
}

GNC::GCS::Widgets::WAnotacionPosicion::~WAnotacionPosicion()
{
	GTRACE("Anotador posicion destruido");

	std::ostringstream os;
	os << "Ginkgo CADx" << GNC::Entorno::Instance()->GetGinkgoCopyRight() << " " << "Metaemotion Healthcare";
	std::string mensaje = os.str();
	GNC::GCS::ControladorEventos::Instance()->ProcesarEvento(new GNC::GCS::Eventos::EventoMensajes(NULL,mensaje));	
}

//endregion

//region "Interfaz generica"

void GNC::GCS::Widgets::WAnotacionPosicion::OnMouseEvents(GNC::GCS::Eventos::EventoRaton& evento)
{
	if(m_Oculto){
		return;
	}

	if( evento.Moving() || evento.Dragging()) {
		GNC::GCS::Vector newpos = evento.iP;
		std::string posstr = m_pAnnotator->GetAnotacionPosicion(&newpos);
		GNC::GCS::ControladorEventos::Instance()->ProcesarEvento(new GNC::GCS::Eventos::EventoMensajes(NULL,posstr));
	}
}

void GNC::GCS::Widgets::WAnotacionPosicion::OnKeyEvents(GNC::GCS::Eventos::EventoTeclado& /*evento*/)
{
}

bool GNC::GCS::Widgets::WAnotacionPosicion::HitTest(float , float , float /*umbralCuadrado*/)
{
	return false;
}

bool GNC::GCS::Widgets::WAnotacionPosicion::HitTest(GNC::GCS::Vector* , int )
{
	return false;
}

void GNC::GCS::Widgets::WAnotacionPosicion::Render(GNC::GCS::Contexto3D* /*c*/)
{
}


void GNC::GCS::Widgets::WAnotacionPosicion::Seleccionar(bool )
{
}

void GNC::GCS::Widgets::WAnotacionPosicion::Iluminar(bool )
{
}

void GNC::GCS::Widgets::WAnotacionPosicion::Ocultar(bool oculto)
{
	if(oculto != m_Oculto){
		m_Oculto = oculto;
	}
}

//region "Interfaz especifica"
void GNC::GCS::Widgets::WAnotacionPosicion::SetAnotador(GNC::GCS::IAnotador* anotador)
{
	m_pAnnotator = anotador;
}
//endregion

