/*
   Copyright (c) 2004, 2005 by AOSASA Shigeru and Red Hat, Inc.
   All rights reserved.

   Redistribution and use in source and binary forms, with or without
   modification, are permitted provided that the following conditions are
   met:

   - Redistributions of source code must retain the above copyright
   notice, this list of conditions and the following disclaimer.

   - Redistributions in binary form must reproduce the above
   copyright notice, this list of conditions and the following
   disclaimer in the documentation and/or other materials provided
   with the distribution.  

   - Neither the name of the AOSASA Shigeru, Red Hat, Inc
   nor the names of its contributors may be used to endorse or
   promote products derived from this software without specific
   prior written permission.

   THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
   "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
   LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS
   FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE
   COPYRIGHT OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT,
   INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
   (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
   SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
   HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT,
   STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
   ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED
   OF THE POSSIBILITY OF SUCH DAMAGE.
*/

/*
   This software development was supported by
   Information-technorogy Promotion Agency, Japan (IPA).
*/

#include "ginspector-builtin.h"

#include "ginspector-core.h"
#include "ginspector-gtk.h"

#include "gtktreecontainer.h"

#include "glrr-gobject.h"



static void builtin_module_init (void);

static gpointer create_panel_object_class_signals    (gpointer data,
						      gpointer func_data,
						      gpointer invoke_data);
static gpointer create_panel_object_class_properties (gpointer data,
						      gpointer func_data,
						      gpointer invoke_data);



void
g_inspector_builtin_register_module_panel_object_class (void)
{
  {
    static GInspectorBuiltinModuleInfo builtin_module_info;

    builtin_module_info.name       = "builtin-panel-object-class";
    builtin_module_info.data       = NULL;
    builtin_module_info.init       = builtin_module_init;
    builtin_module_info.activate   = NULL;
    builtin_module_info.deactivate = NULL;

    g_inspector_builtin_register_module (&builtin_module_info);
  }
}

static void
builtin_module_init (void)
{
  g_inspector_register_procedure ("create-panel-object-class-signals",
				  "",
				  G_INSPECTOR_PROCEDURE_TYPE_PANEL,
				  G_INSPECTOR_ELEMENT_TYPE_GTYPECLASS,
				  G_TYPE_NONE,
				  create_panel_object_class_signals,
				  NULL);

  g_inspector_register_procedure ("create-panel-object-class-properties",
				  "",
				  G_INSPECTOR_PROCEDURE_TYPE_PANEL,
				  G_INSPECTOR_ELEMENT_TYPE_GTYPECLASS,
				  G_TYPE_NONE,
				  create_panel_object_class_properties,
				  NULL);
}



/*
 *
 */

static gpointer
create_panel_object_class_signals (gpointer data,
				   gpointer func_data,
				   gpointer invoke_data)
{
  GType type;

  GtkWidget *top;
  GtkWidget *frame;
  GtkWidget *vbox;

  guint *signal_ids;
  guint  n_signal_ids;
  guint   i;
  GtkWidget *label;


  type = GPOINTER_TO_TYPE (data);


  frame = gtk_frame_new ("Signals");
  top = frame;

  vbox = gtk_vbox_new (0, FALSE);
  gtk_container_add (GTK_CONTAINER (frame), vbox);


  signal_ids = g_signal_list_ids (type, &n_signal_ids);

  for (i = 0; i < n_signal_ids; ++i)
    {
      label = gtk_label_new (g_signal_name (signal_ids[i]));
      gtk_box_pack_start (GTK_BOX (vbox), label, FALSE, FALSE, 0);
    }

  if (n_signal_ids > 0)
    {
      g_free (signal_ids);
    }


  return top;
}


/*
 *
 */
static gpointer
create_panel_object_class_properties (gpointer data,
				      gpointer func_data,
				      gpointer invoke_data)
{
  GType type;

  GtkWidget *top;
  GtkWidget *frame;
  GtkWidget *vbox;

  GObjectClass *object_class;
  GParamSpec **properties;
  guint n_properties;
  GParamSpec *spec;
  guint i;
  GtkWidget *label;


  type = GPOINTER_TO_TYPE (data);


  frame = gtk_frame_new ("Signals");
  top = frame;

  vbox = gtk_vbox_new (0, FALSE);
  gtk_container_add (GTK_CONTAINER (frame), vbox);


  object_class = g_type_class_ref (type);

  properties = g_object_class_list_properties (object_class,
                                               &n_properties);
    
  for (i = 0; i < n_properties; ++i)
    {
      spec = properties[i];

      label = gtk_label_new (spec->name);
      gtk_box_pack_start (GTK_BOX (vbox), label, FALSE, FALSE, 0);
    }

  if (properties != NULL) {
    g_free (properties);
  }


  g_type_class_unref (object_class);


  return top;
}
