/*
   Copyright (c) 2004, 2005 by AOSASA Shigeru and Red Hat, Inc.
   All rights reserved.

   Redistribution and use in source and binary forms, with or without
   modification, are permitted provided that the following conditions are
   met:

   - Redistributions of source code must retain the above copyright
   notice, this list of conditions and the following disclaimer.

   - Redistributions in binary form must reproduce the above
   copyright notice, this list of conditions and the following
   disclaimer in the documentation and/or other materials provided
   with the distribution.  

   - Neither the name of the AOSASA Shigeru, Red Hat, Inc
   nor the names of its contributors may be used to endorse or
   promote products derived from this software without specific
   prior written permission.

   THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
   "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
   LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS
   FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE
   COPYRIGHT OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT,
   INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
   (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
   SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
   HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT,
   STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
   ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED
   OF THE POSSIBILITY OF SUCH DAMAGE.
*/

/*
   This software development was supported by
   Information-technorogy Promotion Agency, Japan (IPA).
*/

#include "ginspector-builtin.h"

#include "ginspector-core.h"
#include "ginspector-gtk.h"
#include "ginspector-ui.h"

#include "gtktreecontainer.h"

#include "glrr-gobject.h"



static void builtin_module_init (void);

static gpointer create_panel_type_class_hierarchy_ancestors   (gpointer data,
							       gpointer func_data,
							       gpointer invoke_data);
static gpointer create_panel_type_class_hierarchy_descendants (gpointer data,
							       gpointer func_data,
							       gpointer invoke_data);
static gpointer create_panel_type_class_hierarchy             (gpointer data,
							       gpointer func_data,
							       gpointer invoke_data);
static gpointer create_panel_all_types_hierarchy              (gpointer data,
							       gpointer func_data,
							       gpointer invoke_data);



void
g_inspector_builtin_register_module_panel_type_class_hierarchy (void)
{
  {
    static GInspectorBuiltinModuleInfo builtin_module_info;

    builtin_module_info.name       = "builtin-panel-type-class-hierarchy";
    builtin_module_info.data       = NULL;
    builtin_module_info.init       = builtin_module_init;
    builtin_module_info.activate   = NULL;
    builtin_module_info.deactivate = NULL;

    g_inspector_builtin_register_module (&builtin_module_info);
  }
}

static void
builtin_module_init (void)
{
  g_inspector_register_procedure ("create-panel-type-class-ancestors",
				  "",
				  G_INSPECTOR_PROCEDURE_TYPE_PANEL,
				  G_INSPECTOR_ELEMENT_TYPE_GTYPECLASS,
				  G_TYPE_NONE,
				  create_panel_type_class_hierarchy_ancestors,
				  NULL);

  g_inspector_register_procedure ("create-panel-type-class-descendants",
				  "",
				  G_INSPECTOR_PROCEDURE_TYPE_PANEL,
				  G_INSPECTOR_ELEMENT_TYPE_GTYPECLASS,
				  G_TYPE_NONE,
				  create_panel_type_class_hierarchy_descendants,
				  NULL);

  g_inspector_register_procedure ("create-panel-type-class-hierarchy",
				  "",
				  G_INSPECTOR_PROCEDURE_TYPE_PANEL,
				  G_INSPECTOR_ELEMENT_TYPE_GTYPECLASS,
				  G_TYPE_NONE,
				  create_panel_type_class_hierarchy,
				  NULL);

  g_inspector_register_procedure ("create-panel-all-types-hierarchy",
				  "",
				  G_INSPECTOR_PROCEDURE_TYPE_PANEL,
				  G_INSPECTOR_ELEMENT_TYPE_GTYPECLASS,
				  G_TYPE_NONE,
				  create_panel_all_types_hierarchy,
				  NULL);
}



static void
construct_ancestors (GInspectorElementTree *element_tree,
		     GType                  type)
{
  GtkWidget *node_widget;
  GtkWidget *parent_node_widget;
  GList     *ancestors;
  GList     *tmp;
  GType      tmp_type;

  ancestors = NULL;
  tmp_type = type;
  do {
    ancestors = g_list_prepend (ancestors, GTYPE_TO_POINTER(tmp_type));
    tmp_type = g_type_parent (tmp_type);
  } while (tmp_type != G_TYPE_INVALID);

  tmp = ancestors;
  parent_node_widget = NULL;
  while (tmp != NULL) {
    tmp_type = GPOINTER_TO_TYPE (tmp->data);
    tmp = g_list_next (tmp);

    node_widget = g_inspector_element_tree_create_node_label (g_type_name (tmp_type));
    g_inspector_element_tree_node_widget_set_element (node_widget,
						      G_INSPECTOR_ELEMENT_TYPE_GTYPECLASS,
						      GTYPE_TO_POINTER (tmp_type));

    gtk_tree_container_append_node_widget (GTK_TREE_CONTAINER (element_tree),
					   node_widget,
					   parent_node_widget);

    parent_node_widget = node_widget;
  }

  g_list_free (ancestors);
}

static void
construct_descendants_recurse (GInspectorElementTree *element_tree,
			       GType                  type,
			       GtkWidget             *parent_node_widget)
{
  GtkWidget *node_widget;


  node_widget = g_inspector_element_tree_create_node_label (g_type_name (type));
  g_inspector_element_tree_node_widget_set_element (node_widget,
						    G_INSPECTOR_ELEMENT_TYPE_GTYPECLASS,
						    GTYPE_TO_POINTER (type));

  gtk_tree_container_append_node_widget (GTK_TREE_CONTAINER (element_tree),
					 node_widget,
					 parent_node_widget);

  {
    GType *children_types;
    guint n_children_types;
    guint i;

    children_types = g_type_children (type, &n_children_types);
    for (i = 0; i < n_children_types; ++i)
      {
	construct_descendants_recurse (element_tree,
				       children_types[i],
				       node_widget);
      }
    g_free (children_types);
  }
}

static void
construct_descendants (GInspectorElementTree *element_tree,
		       GType                  type)
{
  construct_descendants_recurse (element_tree,
				 type,
				 NULL);
}

static void
construct_all_types (GInspectorElementTree *element_tree)
{
  GList *fundamental_type_list;
  GList *tmp;
  GType type;

  fundamental_type_list = g_type_get_fundamental_type_list ();

  tmp = fundamental_type_list;
  while (tmp != NULL)
    {
      type = GPOINTER_TO_TYPE (tmp->data);
      tmp = g_list_next (tmp);

      construct_descendants (element_tree, type);
    }

  g_list_free (fundamental_type_list);
}

static void
update_ancestors (GInspectorElementTree *element_tree,
		  gpointer               user_data)
{
  GType type;

  type = GPOINTER_TO_TYPE (user_data);


  gtk_widget_hide (GTK_WIDGET (element_tree));
  g_inspector_element_tree_clear (element_tree);

  construct_ancestors (element_tree,
		       type);

  gtk_widget_show_all (GTK_WIDGET (element_tree));
}

static void
update_descendants (GInspectorElementTree *element_tree,
		    gpointer               user_data)
{
  GType type;

  type = GPOINTER_TO_TYPE (user_data);


  gtk_widget_hide (GTK_WIDGET (element_tree));
  g_inspector_element_tree_clear (element_tree);

  construct_descendants (element_tree,
			 type);

  gtk_widget_show_all (GTK_WIDGET (element_tree));
}

static void
update_all_types (GInspectorElementTree *element_tree,
		  gpointer               user_data)
{
  gtk_widget_hide (GTK_WIDGET (element_tree));
  g_inspector_element_tree_clear (element_tree);

  construct_all_types (element_tree);

  gtk_widget_show_all (GTK_WIDGET (element_tree));
}





static GtkWidget *
create_element_tree_ancestors (GType type)
{
  GtkWidget *element_tree;
  
  element_tree = g_inspector_element_tree_new ();

  g_signal_connect (element_tree,
		    "update",
		    G_CALLBACK (update_ancestors),
		    GTYPE_TO_POINTER (type));


  return element_tree;
}

static GtkWidget *
create_element_tree_descendants (GType type)
{
  GtkWidget *element_tree;
  
  element_tree = g_inspector_element_tree_new ();

  g_signal_connect (element_tree,
		    "update",
		    G_CALLBACK (update_descendants),
		    GTYPE_TO_POINTER (type));


  return element_tree;
}

static GtkWidget *
create_element_tree_all_types (void)
{
  GtkWidget *element_tree;
  
  element_tree = g_inspector_element_tree_new ();

  g_signal_connect (element_tree,
		    "update",
		    G_CALLBACK (update_all_types),
		    NULL);


  return element_tree;
}


static gpointer
create_panel_type_class_hierarchy_ancestors (gpointer data,
					     gpointer func_data,
					     gpointer invoke_data)
{
  GType type;

  GtkWidget *top;
  GtkWidget *panel;
  GtkWidget *frame;
  GtkWidget *scrolled_window;
  GtkWidget *element_tree;


  type = GPOINTER_TO_TYPE (data);


  {
    panel = g_object_new (G_TYPE_INSPECTOR_PANEL,
                          NULL);
    top = panel;
  }

  {
    frame = g_inspector_panel_frame_new ();
    g_inspector_panel_frame_set_title (G_INSPECTOR_PANEL_FRAME (frame), "Hierarchy (ancestors)");

    gtk_container_add (GTK_CONTAINER (panel), frame);
  }

  {
    scrolled_window = gtk_scrolled_window_new (NULL, NULL);
    gtk_scrolled_window_set_policy (GTK_SCROLLED_WINDOW (scrolled_window),
				    GTK_POLICY_AUTOMATIC, GTK_POLICY_AUTOMATIC);

    gtk_container_add (GTK_CONTAINER (frame), scrolled_window);
  }

  {
    element_tree = create_element_tree_ancestors (type);

    gtk_scrolled_window_add_with_viewport (GTK_SCROLLED_WINDOW (scrolled_window),
					   element_tree);

#if 1
    gtk_viewport_set_shadow_type (GTK_VIEWPORT (GTK_BIN (scrolled_window)->child),
				  GTK_SHADOW_NONE);
#endif
  }

  {
    g_signal_connect_swapped (panel,
			      "update",
			      G_CALLBACK (g_inspector_element_tree_update),
			      element_tree);
  }

  {
    g_signal_connect_swapped (gtk_frame_get_label_widget (GTK_FRAME (frame)),
			      "clicked",
			      G_CALLBACK (g_inspector_panel_update),
			      panel);
  }




  g_inspector_panel_update (G_INSPECTOR_PANEL (panel));


  return top;
}

static gpointer
create_panel_type_class_hierarchy_descendants (gpointer data,
					       gpointer func_data,
					       gpointer invoke_data)
{
  GType type;

  GtkWidget *top;
  GtkWidget *panel;
  GtkWidget *frame;
  GtkWidget *scrolled_window;
  GtkWidget *element_tree;


  type = GPOINTER_TO_TYPE (data);


  {
    panel = g_object_new (G_TYPE_INSPECTOR_PANEL,
                          NULL);
    top = panel;
  }

  {
    frame = g_inspector_panel_frame_new ();
    g_inspector_panel_frame_set_title (G_INSPECTOR_PANEL_FRAME (frame), "Hierarchy (descendants)");

    gtk_container_add (GTK_CONTAINER (panel), frame);
  }

  {
    scrolled_window = gtk_scrolled_window_new (NULL, NULL);
    gtk_scrolled_window_set_policy (GTK_SCROLLED_WINDOW (scrolled_window),
				    GTK_POLICY_AUTOMATIC, GTK_POLICY_AUTOMATIC);

    gtk_container_add (GTK_CONTAINER (frame), scrolled_window);
  }

  {
    element_tree = create_element_tree_descendants (type);

    gtk_scrolled_window_add_with_viewport (GTK_SCROLLED_WINDOW (scrolled_window),
					   element_tree);

#if 1
    gtk_viewport_set_shadow_type (GTK_VIEWPORT (GTK_BIN (scrolled_window)->child),
				  GTK_SHADOW_NONE);
#endif
  }

  {
    g_signal_connect_swapped (panel,
			      "update",
			      G_CALLBACK (g_inspector_element_tree_update),
			      element_tree);
  }

  {
    g_signal_connect_swapped (gtk_frame_get_label_widget (GTK_FRAME (frame)),
			      "clicked",
			      G_CALLBACK (g_inspector_panel_update),
			      panel);
  }




  g_inspector_panel_update (G_INSPECTOR_PANEL (panel));


  return top;
}

static gpointer
create_panel_type_class_hierarchy (gpointer data,
				   gpointer func_data,
				   gpointer invoke_data)
{
  GType type;

  GtkWidget *top;
  GtkWidget *panel;
  GtkWidget *frame;
  GtkWidget *vbox;
  GtkWidget *scrolled_window_ancestors;
  GtkWidget *scrolled_window_descendants;
  GtkWidget *element_tree_ancestors;
  GtkWidget *element_tree_descendants;


  type = GPOINTER_TO_TYPE (data);


  {
    panel = g_object_new (G_TYPE_INSPECTOR_PANEL,
                          NULL);
    top = panel;
  }

  {
    frame = g_inspector_panel_frame_new ();
    g_inspector_panel_frame_set_title (G_INSPECTOR_PANEL_FRAME (frame), "Hierarchy");

    gtk_container_add (GTK_CONTAINER (panel), frame);
  }

  {
    vbox = gtk_vbox_new (FALSE, 0);
    gtk_container_add (GTK_CONTAINER (frame), vbox);
  }

  {
    scrolled_window_ancestors = gtk_scrolled_window_new (NULL, NULL);
    gtk_scrolled_window_set_policy (GTK_SCROLLED_WINDOW (scrolled_window_ancestors),
				    GTK_POLICY_AUTOMATIC, GTK_POLICY_AUTOMATIC);

    gtk_box_pack_start (GTK_BOX (vbox), scrolled_window_ancestors,
			FALSE, FALSE, 0);
  }

  {
    gtk_box_pack_start (GTK_BOX (vbox), gtk_hseparator_new (),
			FALSE, FALSE, 0);
  }

  {
    scrolled_window_descendants = gtk_scrolled_window_new (NULL, NULL);
    gtk_scrolled_window_set_policy (GTK_SCROLLED_WINDOW (scrolled_window_descendants),
				    GTK_POLICY_AUTOMATIC, GTK_POLICY_AUTOMATIC);

    gtk_box_pack_start (GTK_BOX (vbox), scrolled_window_descendants,
			TRUE, TRUE, 0);
  }

  {
    element_tree_ancestors = create_element_tree_ancestors (type);

    gtk_scrolled_window_add_with_viewport (GTK_SCROLLED_WINDOW (scrolled_window_ancestors),
					   element_tree_ancestors);

#if 1
    gtk_viewport_set_shadow_type (GTK_VIEWPORT (GTK_BIN (scrolled_window_ancestors)->child),
				  GTK_SHADOW_NONE);
#endif
  }

  {
    element_tree_descendants = create_element_tree_descendants (type);

    gtk_scrolled_window_add_with_viewport (GTK_SCROLLED_WINDOW (scrolled_window_descendants),
					   element_tree_descendants);

#if 1
    gtk_viewport_set_shadow_type (GTK_VIEWPORT (GTK_BIN (scrolled_window_descendants)->child),
				  GTK_SHADOW_NONE);
#endif
  }

  {
    g_signal_connect_swapped (panel,
			      "update",
			      G_CALLBACK (g_inspector_element_tree_update),
			      element_tree_ancestors);
  }

  {
    g_signal_connect_swapped (panel,
			      "update",
			      G_CALLBACK (g_inspector_element_tree_update),
			      element_tree_descendants);
  }

  {
    g_signal_connect_swapped (gtk_frame_get_label_widget (GTK_FRAME (frame)),
			      "clicked",
			      G_CALLBACK (g_inspector_panel_update),
			      panel);
  }




  g_inspector_panel_update (G_INSPECTOR_PANEL (panel));


  return top;
}

static gpointer
create_panel_all_types_hierarchy (gpointer data,
				  gpointer func_data,
				  gpointer invoke_data)
{
  GtkWidget *top;
  GtkWidget *panel;
  GtkWidget *frame;
  GtkWidget *scrolled_window;
  GtkWidget *element_tree;


  {
    panel = g_object_new (G_TYPE_INSPECTOR_PANEL,
                          NULL);
    top = panel;
  }

  {
    frame = g_inspector_panel_frame_new ();
    g_inspector_panel_frame_set_title (G_INSPECTOR_PANEL_FRAME (frame), "GType Tree");

    gtk_container_add (GTK_CONTAINER (panel), frame);
  }

  {
    scrolled_window = gtk_scrolled_window_new (NULL, NULL);
    gtk_scrolled_window_set_policy (GTK_SCROLLED_WINDOW (scrolled_window),
				    GTK_POLICY_AUTOMATIC, GTK_POLICY_AUTOMATIC);

    gtk_container_add (GTK_CONTAINER (frame), scrolled_window);
  }

  {
    element_tree = create_element_tree_all_types ();

    gtk_scrolled_window_add_with_viewport (GTK_SCROLLED_WINDOW (scrolled_window),
					   element_tree);

#if 1
    gtk_viewport_set_shadow_type (GTK_VIEWPORT (GTK_BIN (scrolled_window)->child),
				  GTK_SHADOW_NONE);
#endif
  }

  {
    g_signal_connect_swapped (panel,
			      "update",
			      G_CALLBACK (g_inspector_element_tree_update),
			      element_tree);
  }

  {
    g_signal_connect_swapped (gtk_frame_get_label_widget (GTK_FRAME (frame)),
			      "clicked",
			      G_CALLBACK (g_inspector_panel_update),
			      panel);
  }




  g_inspector_panel_update (G_INSPECTOR_PANEL (panel));


  return top;
}
