/*
   Copyright (c) 2004, 2005 by AOSASA Shigeru and Red Hat, Inc.
   All rights reserved.

   Redistribution and use in source and binary forms, with or without
   modification, are permitted provided that the following conditions are
   met:

   - Redistributions of source code must retain the above copyright
   notice, this list of conditions and the following disclaimer.

   - Redistributions in binary form must reproduce the above
   copyright notice, this list of conditions and the following
   disclaimer in the documentation and/or other materials provided
   with the distribution.  

   - Neither the name of the AOSASA Shigeru, Red Hat, Inc
   nor the names of its contributors may be used to endorse or
   promote products derived from this software without specific
   prior written permission.

   THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
   "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
   LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS
   FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE
   COPYRIGHT OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT,
   INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
   (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
   SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
   HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT,
   STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
   ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED
   OF THE POSSIBILITY OF SUCH DAMAGE.
*/

/*
   This software development was supported by
   Information-technorogy Promotion Agency, Japan (IPA).
*/

#ifndef __G_INSPECTOR_CONTEXT_H__
#define __G_INSPECTOR_CONTEXT_H__


#include <glib-object.h>


G_BEGIN_DECLS



#define G_TYPE_INSPECTOR_CONTEXT            (g_inspector_context_get_type ())
#define G_INSPECTOR_CONTEXT(obj)            (G_TYPE_CHECK_INSTANCE_CAST ((obj), G_TYPE_INSPECTOR_CONTEXT, GInspectorContext))
#define G_INSPECTOR_CONTEXT_CLASS(klass)    (G_TYPE_CHECK_CLASS_CAST ((klass), G_TYPE_INSPECTOR_CONTEXT, GInspectorContextClass))
#define G_IS_INSPECTOR_CONTEXT(obj)         (G_TYPE_CHECK_INSTANCE_TYPE ((obj), G_TYPE_INSPECTOR_CONTEXT))
#define G_IS_INSPECTOR_CONTEXT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), G_TYPE_INSPECTOR_CONTEXT))
#define G_INSPECTOR_CONTEXT_GET_CLASS(obj)  (G_TYPE_INSTANCE_GET_CLASS ((obj), G_TYPE_INSPECTOR_CONTEXT, GInspectorContextClass))


typedef struct _GInspectorContext        GInspectorContext;
typedef struct _GInspectorContextClass   GInspectorContextClass;

struct _GInspectorContext
{
  GObject object;

  gboolean active;
};

struct _GInspectorContextClass
{
  GObjectClass parent_class;

  void (* activate)   (GInspectorContext *context);
  void (* deactivate) (GInspectorContext *context);
};


GType g_inspector_context_get_type (void) G_GNUC_CONST;

void g_inspector_context_activate   (GInspectorContext *context);
void g_inspector_context_deactivate (GInspectorContext *context);



G_END_DECLS


#endif /* __G_INSPECTOR_CONTEXT_H__ */
