/*
   Copyright (c) 2004, 2005 by AOSASA Shigeru and Red Hat, Inc.
   All rights reserved.

   Redistribution and use in source and binary forms, with or without
   modification, are permitted provided that the following conditions are
   met:

   - Redistributions of source code must retain the above copyright
   notice, this list of conditions and the following disclaimer.

   - Redistributions in binary form must reproduce the above
   copyright notice, this list of conditions and the following
   disclaimer in the documentation and/or other materials provided
   with the distribution.  

   - Neither the name of the AOSASA Shigeru, Red Hat, Inc
   nor the names of its contributors may be used to endorse or
   promote products derived from this software without specific
   prior written permission.

   THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
   "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
   LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS
   FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE
   COPYRIGHT OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT,
   INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
   (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
   SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
   HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT,
   STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
   ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED
   OF THE POSSIBILITY OF SUCH DAMAGE.
*/

/*
   This software development was supported by
   Information-technorogy Promotion Agency, Japan (IPA).
*/

#include "ginspector-core.h"
#include "ginspector-gtk.h"

#include "ginspector-ui-dnd.h"

#include "ginspectorwindow.h"

#include "glrr-gobject.h"

#include <stdlib.h>
#include <string.h>



typedef enum {
  G_INSPECTOR_DND_TYPE_NONE          = 0,

  G_INSPECTOR_DND_TYPE_ELEMENT       = 1,

  G_INSPECTOR_DND_TYPE_LAST          = G_INSPECTOR_DND_TYPE_ELEMENT
} GInspectorDndType;


#define G_INSPECTOR_TARGET_ELEMENT \
  { "application/x-ginspector-element", GTK_TARGET_SAME_APP, G_INSPECTOR_DND_TYPE_ELEMENT }




static GtkTargetEntry target_entries[] = {
  G_INSPECTOR_TARGET_ELEMENT
};
static guint n_target_entries = G_N_ELEMENTS (target_entries);


GdkDragContext*
g_inspector_dnd_drag_begin (GtkWidget         *widget,
			    GdkDragAction      actions,
			    gint               button,
			    GdkEvent          *event)
{
  GdkDragContext *drag_context;
  GtkTargetList *target_list;

  g_return_val_if_fail (widget != NULL, NULL);
  g_return_val_if_fail (GTK_IS_WIDGET (widget), NULL);
  

  target_list = gtk_target_list_new (target_entries,
				     n_target_entries);

  drag_context = gtk_drag_begin (widget,
				 target_list,
				 actions,
				 button,
				 event);

  gtk_target_list_unref (target_list);


  return drag_context;
}

void
g_inspector_dnd_drag_source_set (GtkWidget       *widget,
				 GdkModifierType  start_button_mask,
				 GdkDragAction    actions)
{
  g_return_if_fail (widget != NULL);
  g_return_if_fail (GTK_IS_WIDGET (widget));


  gtk_drag_source_set (widget,
		       start_button_mask,
		       target_entries,
		       n_target_entries,
		       actions);
}

void
g_inspector_dnd_drag_dest_set (GtkWidget       *widget,
			       GtkDestDefaults  flags,
			       GdkDragAction    actions)
{
  g_return_if_fail (widget != NULL);
  g_return_if_fail (GTK_IS_WIDGET (widget));


  gtk_drag_dest_set (widget,
		     flags,
		     target_entries,
		     n_target_entries,
		     actions);
}






static void set_drag_widget (GdkDragContext *context,
			     gchar          *label_text);
static void set_drag_widget_gtypeinstance (GdkDragContext *context,
					   GTypeInstance  *instance);
static void set_drag_widget_gtypeclass    (GdkDragContext *context,
					   GType           type);

void
g_inspector_dnd_set_drag_widget_element (GdkDragContext          *context,
					 GInspectorElementHolder *element_holder)
{
  GInspectorElementType element_type;
  gpointer              element;

  g_return_if_fail (context != NULL);
  g_return_if_fail (element_holder != NULL);
  g_return_if_fail (GDK_IS_DRAG_CONTEXT (context));
  g_return_if_fail (G_IS_INSPECTOR_ELEMENT_HOLDER (element_holder));


  element_type = g_inspector_element_holder_get_element_type (element_holder);
  element = g_inspector_element_holder_get_element (element_holder);

  switch (element_type)
    {
    case G_INSPECTOR_ELEMENT_TYPE_GTYPEINSTANCE:
      {
	set_drag_widget_gtypeinstance (context,
				       (GTypeInstance *)element);
      }
      break;

    case G_INSPECTOR_ELEMENT_TYPE_GTYPECLASS:
      {
	set_drag_widget_gtypeclass (context,
				    GPOINTER_TO_TYPE (element));
      }
      break;

    default:
      {
      }
      break;
    }
}

void
g_inspector_dnd_selection_data_set_element (GtkSelectionData        *selection_data,
					    GInspectorElementHolder *element_holder)
{
  guchar *data;
  gint    data_len;

  g_return_if_fail (selection_data != NULL);
  g_return_if_fail (element_holder != NULL);
  g_return_if_fail (G_IS_INSPECTOR_ELEMENT_HOLDER (element_holder));


  data     = g_strdup_printf ("%p", element_holder);
  data_len = strlen (data);

  gtk_selection_data_set (selection_data,
			  selection_data->target,
			  8,
			  data, data_len);

  if (data != NULL)
    {
      g_free (data);
    }
}

GInspectorElementHolder*
g_inspector_dnd_selection_data_get_element (GtkSelectionData *selection_data)
{
  GInspectorElementHolder *element_holder;

  g_return_val_if_fail (selection_data != NULL, NULL);


  element_holder = (gpointer)strtoul (selection_data->data, NULL, 16);

  return element_holder;
}


/***/
static gint label_expose (GtkWidget      *widget,
                          GdkEventExpose *event,
                          gpointer        user_data);

static void
set_drag_widget (GdkDragContext *context,
		 gchar          *label_text)
{
  GtkWidget *top;
  GtkWidget *window;
  GtkWidget *label;


  window = g_inspector_window_new_full (GTK_WINDOW_POPUP);
  top = window;


  label = gtk_label_new (label_text);
  gtk_misc_set_padding (GTK_MISC (label), 2, 1);

  g_signal_connect (label,
                    "expose_event",
                    G_CALLBACK (label_expose),
                    NULL);

  gtk_container_add (GTK_CONTAINER (window),
		     label);


  gtk_widget_show_all (top);


  gtk_drag_set_icon_widget (context,
			    top,
			    -8, -8);


#if 0
  {
    g_object_unref (top);
  }
#else
  {
    GClosure *closure;

    closure = g_cclosure_new (G_CALLBACK (gtk_true), NULL, NULL);

    g_closure_add_finalize_notifier (closure,
				     top,
				     (GClosureNotify)gtk_widget_destroy);

    g_signal_connect_closure (context,
			      "notify",
			      closure,
			      FALSE);
  }
#endif
}

static gint
label_expose (GtkWidget	     *widget,
	      GdkEventExpose *event,
	      gpointer	      user_data)
{
  if (GTK_WIDGET_DRAWABLE (widget))
    {
      gint x;
      gint y;
      gint width;
      gint height;
      GtkStateType state;

      x = widget->allocation.x;
      y = widget->allocation.y;
      width  = (widget->allocation.width  - 1);
      height = (widget->allocation.height - 1);

      state = GTK_STATE_PRELIGHT;

      gdk_gc_set_clip_rectangle (widget->style->fg_gc[state], &event->area);
      gdk_gc_set_clip_rectangle (widget->style->bg_gc[state], &event->area);

      gdk_draw_rectangle (widget->window,
			  widget->style->bg_gc[state], TRUE,
			  x, y, width, height);

      gdk_draw_rectangle (widget->window,
			  widget->style->fg_gc[state], FALSE,
			  x, y, width, height);

      gdk_gc_set_clip_rectangle (widget->style->fg_gc[state], NULL);
      gdk_gc_set_clip_rectangle (widget->style->bg_gc[state], NULL);
    }

  return FALSE;
}

static void
set_drag_widget_gtypeinstance (GdkDragContext *context,
			       GTypeInstance  *instance)
{
  gchar *text;

  text = g_strdup_printf ("%s: %p",
			  g_type_name (G_TYPE_FROM_INSTANCE (instance)),
			  instance);


  set_drag_widget (context, text);


  g_free (text);
}

static void
set_drag_widget_gtypeclass (GdkDragContext *context,
			    GType           type)
{
  gchar *text;

  text = g_strdup_printf ("%s",
			  g_type_name (type));


  set_drag_widget (context, text);


  g_free (text);
}
