/*
   Copyright (c) 2004, 2005 by AOSASA Shigeru and Red Hat, Inc.
   All rights reserved.

   Redistribution and use in source and binary forms, with or without
   modification, are permitted provided that the following conditions are
   met:

   - Redistributions of source code must retain the above copyright
   notice, this list of conditions and the following disclaimer.

   - Redistributions in binary form must reproduce the above
   copyright notice, this list of conditions and the following
   disclaimer in the documentation and/or other materials provided
   with the distribution.  

   - Neither the name of the AOSASA Shigeru, Red Hat, Inc
   nor the names of its contributors may be used to endorse or
   promote products derived from this software without specific
   prior written permission.

   THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
   "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
   LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS
   FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE
   COPYRIGHT OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT,
   INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
   (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
   SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
   HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT,
   STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
   ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED
   OF THE POSSIBILITY OF SUCH DAMAGE.
*/

/*
   This software development was supported by
   Information-technorogy Promotion Agency, Japan (IPA).
*/

#include <gtk/gtk.h>
#include <gtk/gtkiconfactory.h>

#include "ginspector-ui-stock.h"
#include "ginspector-ui-stock-pixbufs.h"


static struct {
  gchar        *stock_id;
  GtkIconSize   icon_size;
  const guint8 *data;
} g_inspector_stock_pixbuf_data[] =
{
  { G_INSPECTOR_STOCK_CONNECTED,	GTK_ICON_SIZE_MENU,	stock_connected_16	},
  { G_INSPECTOR_STOCK_CONNECTED,	GTK_ICON_SIZE_BUTTON,	stock_connected_20	},
  { G_INSPECTOR_STOCK_DISCONNECTED,	GTK_ICON_SIZE_MENU,	stock_disconnected_16	},
  { G_INSPECTOR_STOCK_DISCONNECTED,	GTK_ICON_SIZE_BUTTON,	stock_disconnected_20	}
};


void
g_inspector_ui_stock_init (void)
{
  GtkIconFactory *icon_factory;
  guint i;

  icon_factory = gtk_icon_factory_new ();

  for (i = 0; i < G_N_ELEMENTS (g_inspector_stock_pixbuf_data); ++i)
    {
      gchar         *stock_id;
      const guint8  *data;
      GtkIconSize    icon_size;
      GtkIconSource *icon_source;
      GtkIconSet    *icon_set;
      GdkPixbuf     *pixbuf;

      icon_size = g_inspector_stock_pixbuf_data[i].icon_size;
      stock_id  = g_inspector_stock_pixbuf_data[i].stock_id;
      data      = g_inspector_stock_pixbuf_data[i].data;
  

      icon_source = gtk_icon_source_new ();
      pixbuf = gdk_pixbuf_new_from_inline (-1, data, FALSE, NULL);

      icon_set = gtk_icon_factory_lookup (icon_factory, stock_id);
      if (icon_set == NULL)
	{
	  icon_set = gtk_icon_set_new ();
	  gtk_icon_factory_add (icon_factory, stock_id, icon_set);
	  gtk_icon_set_unref (icon_set);
	}
      

      gtk_icon_source_set_size            (icon_source, icon_size);
      gtk_icon_source_set_size_wildcarded (icon_source, FALSE);
      gtk_icon_source_set_pixbuf          (icon_source, pixbuf);

      gtk_icon_set_add_source (icon_set, icon_source);

      g_object_unref (pixbuf);
      gtk_icon_source_free (icon_source);
    }

  gtk_icon_factory_add_default (icon_factory);


  for (i = 0; i < G_N_ELEMENTS (g_inspector_stock_pixbuf_data); ++i)
    {
      gchar         *stock_id;
      GtkStockItem   stock_item;


      stock_id = g_inspector_stock_pixbuf_data[i].stock_id;

      stock_item.stock_id = stock_id;
      stock_item.label    = NULL;
      stock_item.modifier = 0;
      stock_item.keyval   = 0;
      stock_item.translation_domain = NULL;

      gtk_stock_add (&stock_item, 1);
    }
}
