/*
   Copyright (c) 2004, 2005 by AOSASA Shigeru and Red Hat, Inc.
   All rights reserved.

   Redistribution and use in source and binary forms, with or without
   modification, are permitted provided that the following conditions are
   met:

   - Redistributions of source code must retain the above copyright
   notice, this list of conditions and the following disclaimer.

   - Redistributions in binary form must reproduce the above
   copyright notice, this list of conditions and the following
   disclaimer in the documentation and/or other materials provided
   with the distribution.  

   - Neither the name of the AOSASA Shigeru, Red Hat, Inc
   nor the names of its contributors may be used to endorse or
   promote products derived from this software without specific
   prior written permission.

   THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
   "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
   LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS
   FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE
   COPYRIGHT OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT,
   INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
   (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
   SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
   HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT,
   STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
   ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED
   OF THE POSSIBILITY OF SUCH DAMAGE.
*/

/*
   This software development was supported by
   Information-technorogy Promotion Agency, Japan (IPA).
*/

#include "ginspector-builtin.h"

#include "ginspector-core.h"
#include "ginspector-gtk.h"
#include "ginspector-ui.h"

#include "glrr-glib.h"
#include "glrr-gobject.h"
#include "glrr-gtk.h"

#include "misc-utils.h"

#include <string.h>



static void builtin_module_init (void);

static gpointer create_panel_general_info  (gpointer data,
					    gpointer func_data,
					    gpointer invoke_data);
static gpointer create_panel_qdata_list    (gpointer data,
					    gpointer func_data,
					    gpointer invoke_data);
static gpointer create_panel_property_list (gpointer data,
					    gpointer func_data,
					    gpointer invoke_data);



void
g_inspector_builtin_register_module_panel_object_instance (void)
{
  {
    static GInspectorBuiltinModuleInfo builtin_module_info;

    builtin_module_info.name       = "builtin-panel-object-instance";
    builtin_module_info.data       = NULL;
    builtin_module_info.init       = builtin_module_init;
    builtin_module_info.activate   = NULL;
    builtin_module_info.deactivate = NULL;

    g_inspector_builtin_register_module (&builtin_module_info);
  }
}

static void
builtin_module_init (void)
{
  g_inspector_register_procedure ("create-panel-object-instance-general-info",
				  "",
				  G_INSPECTOR_PROCEDURE_TYPE_PANEL,
				  G_INSPECTOR_ELEMENT_TYPE_GTYPEINSTANCE,
				  G_TYPE_OBJECT,
				  create_panel_general_info,
				  NULL);

  g_inspector_register_procedure ("create-panel-object-instance-qdata-list",
				  "",
				  G_INSPECTOR_PROCEDURE_TYPE_PANEL,
				  G_INSPECTOR_ELEMENT_TYPE_GTYPEINSTANCE,
				  G_TYPE_OBJECT,
				  create_panel_qdata_list,
				  NULL);

  g_inspector_register_procedure ("create-panel-object-instance-property-list",
				  "",
				  G_INSPECTOR_PROCEDURE_TYPE_PANEL,
				  G_INSPECTOR_ELEMENT_TYPE_GTYPEINSTANCE,
				  G_TYPE_OBJECT,
				  create_panel_property_list,
				  NULL);
}



/*
 *
 */
static gpointer
create_panel_general_info (gpointer data,
			   gpointer func_data,
			   gpointer invoke_data)
{
  GObject *object;

  GtkWidget *top;
  GtkWidget *panel;
  GtkWidget *frame;
  GtkWidget *table;

  GList *label_list;
  GtkWidget *label;


  object = G_OBJECT (data);


  {
    panel = g_object_new (G_TYPE_INSPECTOR_PANEL,
			  NULL);
    top = panel;
  }


  {
    frame = g_inspector_panel_frame_new ();
    g_inspector_panel_frame_set_title (G_INSPECTOR_PANEL_FRAME (frame),
				       "General");
    gtk_container_add (GTK_CONTAINER (top), frame);
  }


  {
    gint n;
    gint i;

    label_list
      = g_list_new (gtk_label_new        ("GObject:"),
		    gtk_label_new_printf ("%p", object),

		    gtk_label_new        ("GType:"),
		    gtk_label_new_printf ("%s", g_type_name (G_OBJECT_TYPE (object))),

		    NULL);


    n = g_list_length (label_list);



    table = gtk_table_new (2, n/2, FALSE);
    gtk_container_add (GTK_CONTAINER (frame), table);
    gtk_container_set_border_width (GTK_CONTAINER (table), 4);


    for (i = 0; i < n; ++i)
      {
	label = g_list_nth_data (label_list, i);

	{
	  gtk_misc_set_alignment (GTK_MISC (label), 0.0, 0.5);
	}

	{
	  gint left_attach;
	  gint top_attach;

	  left_attach = (i % 2);
	  top_attach  = (i / 2);

	  gtk_table_attach (GTK_TABLE (table),
			    label,
			    (left_attach + 0),
			    (left_attach + 1),
			    (top_attach + 0),
			    (top_attach + 1),
			    GTK_FILL, GTK_FILL,
			    4, 0);
	}
      }

    g_list_free (label_list);
  }


  return top;
}


/*
 *
 */

static void
panel_qdata_update (GInspectorPanel *panel,
		    gpointer         user_data)
{
  GObject *object;
  GtkWidget *table;


  object = G_OBJECT (panel->element);


  table = gtk_container_find_descendant_by_name (GTK_CONTAINER (panel), "table");


  {
    gtk_container_foreach (GTK_CONTAINER (table),
			   (GtkCallback)gtk_widget_destroy,
			   NULL);
  }


  {
    GData **qdata;
    GList *key_id_list;

    qdata = &(object->qdata);
    key_id_list = g_datalist_get_key_id_list (qdata);

    if (key_id_list != NULL)
      {
	GtkWidget *label;

	guint rows;
	guint columns;

	GQuark qdata_key_id;
	gpointer qdata_data;
	GtkWidget *widgets[2];
	guint i, j;




	rows = g_list_length (key_id_list);
	columns = 2;

	gtk_table_resize (GTK_TABLE (table), rows, columns);

	for (j = 0; j < rows; ++j)
	  {
	    qdata_key_id = GPOINTER_TO_QUARK (g_list_nth_data (key_id_list, j));
	    qdata_data   = g_datalist_id_get_data (qdata, qdata_key_id);

	    widgets[0] = gtk_label_new        (g_quark_to_string (qdata_key_id));
	    widgets[1] = gtk_label_new_printf ("%p", qdata_data);

	    for (i = 0; i < columns; ++i)
	      {
		label = widgets[i];
		gtk_misc_set_alignment (GTK_MISC (label), 0.0, 0.5);

		gtk_table_attach (GTK_TABLE (table),
				  label, i, i+1, j, j+1,
				  GTK_FILL, GTK_FILL,
				  4, 0);
	      }
	  }

	g_list_free (key_id_list);


	gtk_widget_show_all (table);
      }
  }
}

static gpointer
create_panel_qdata_list (gpointer data,
			 gpointer func_data,
			 gpointer invoke_data)
{
  GObject *object;

  GtkWidget *top;
  GtkWidget *panel;
  GtkWidget *frame;
  GtkWidget *table;


  object = G_OBJECT (data);

  {
    panel = g_object_new (G_TYPE_INSPECTOR_PANEL,
			  NULL);

    G_INSPECTOR_PANEL (panel)->element_type = G_INSPECTOR_ELEMENT_TYPE_GTYPEINSTANCE;
    G_INSPECTOR_PANEL (panel)->element = object;

    top = panel;
  }

  {
    frame = g_inspector_panel_frame_new ();
    g_inspector_panel_frame_set_title (G_INSPECTOR_PANEL_FRAME (frame), "QData");

    gtk_container_add (GTK_CONTAINER (top), frame);
  }

  {
    table = gtk_table_new (1, 2, FALSE);
    gtk_widget_set_name (table, "table");
    gtk_container_set_border_width (GTK_CONTAINER (table), 4);

    gtk_container_add (GTK_CONTAINER (frame), table);
  }

  {
    g_signal_connect (panel,
		      "update",
		      G_CALLBACK (panel_qdata_update),
		      NULL);
  }

  {
    g_signal_connect_swapped (gtk_frame_get_label_widget (GTK_FRAME (frame)),
			      "clicked",
			      G_CALLBACK (g_inspector_panel_update),
			      panel);
  }


  g_inspector_panel_update (G_INSPECTOR_PANEL (panel));


  return top;
}


/*
 *
 */

#define PARAM_SPEC "param-spec"

static void
object_notify (GObject    *object,
	       GParamSpec *pspec,
	       gpointer    user_data)
{
  GInspectorPanel *panel;
  GtkWidget *label;

  panel = G_INSPECTOR_PANEL (user_data);

  
  label = gtk_container_find_descendant_by_data (GTK_CONTAINER (panel),
						 PARAM_SPEC,
						 pspec);

  if (label != NULL)
    {
      gchar *text;

      if (pspec->flags & G_PARAM_READABLE)
	{
	  GValue value;

	  g_value_fill0 (&value);
	  g_value_init (&value, pspec->value_type);

	  g_object_get_property (object, pspec->name, &value);

#if 0
	  text = g_strdup_value_contents (&value);
#else
	  text = g_value_to_string (&value);
#endif
	}
      else
	{
	  text = NULL;
	}

      gtk_label_set_text (GTK_LABEL (label), text);

      if (text != NULL)
	{
	  g_free (text);
	}
    }
}

static void
panel_property_list_update (GInspectorPanel *panel,
			    gpointer         user_data)
{
  GObject *object;
  GtkWidget *table;


  object = G_OBJECT (panel->element);


  table = gtk_container_find_descendant_by_name (GTK_CONTAINER (panel), "table");

  {
    gtk_container_foreach (GTK_CONTAINER (table),
			   (GtkCallback)gtk_widget_destroy,
			   NULL);
  }


  {
    GParamSpec **properties;
    guint n_properties;
    GList *label_list;

    {
      GObjectClass *object_class;
    
      object_class = g_type_class_ref (G_OBJECT_TYPE (object));

      properties = g_object_class_list_properties (object_class,
						   &n_properties);

      g_type_class_unref (object_class);
    }


    {
      GtkWidget *label;
      GParamSpec *pspec;
      guint i;

      label_list = NULL;

      for (i = 0; i < n_properties; ++i)
	{
	  pspec = properties[i];

	  {
	    label = gtk_label_new (pspec->name);

	    label_list = g_list_append (label_list,
					label);
	  }


	  {
	    label = gtk_label_new (NULL);
	    g_object_set_data (G_OBJECT (label),
			       PARAM_SPEC,
			       pspec);

	    label_list = g_list_append (label_list,
					label);
	  }
	}
    }

    {
      GtkWidget *label;
      gint n;
      gint i;


      n = g_list_length (label_list);

      gtk_table_resize (GTK_TABLE (table), n/2, 2);


      for (i = 0; i < n; ++i)
	{
	  label = g_list_nth_data (label_list, i);

	  {
	    gtk_misc_set_alignment (GTK_MISC (label), 0.0, 0.5);
	  }

	  {
	    gint left_attach;
	    gint top_attach;

	    left_attach = (i % 2);
	    top_attach  = (i / 2);

	    gtk_table_attach (GTK_TABLE (table),
			      label,
			      (left_attach + 0),
			      (left_attach + 1),
			      (top_attach + 0),
			      (top_attach + 1),
			      GTK_FILL, GTK_FILL,
			      4, 0);
	  }
	}
    }
    
    {
      GParamSpec *pspec;
      guint i;

      for (i = 0; i < n_properties; ++i)
	{
	  pspec = properties[i];

	  object_notify (object, pspec, panel);
	}
    }

    if (label_list != NULL)
      {
	g_list_free (label_list);
      }

    if (properties != NULL)
      {
	g_free (properties);
      }


    gtk_widget_show_all (table);
  }
}

static gpointer
create_panel_property_list (gpointer data,
			    gpointer func_data,
			    gpointer invoke_data)
{
  GObject *object;

  GtkWidget *top;
  GtkWidget *panel;
  GtkWidget *frame;
  GtkWidget *table;


  object = G_OBJECT (data);


  {
    panel = g_object_new (G_TYPE_INSPECTOR_PANEL,
			  NULL);

    G_INSPECTOR_PANEL (panel)->element_type = G_INSPECTOR_ELEMENT_TYPE_GTYPEINSTANCE;
    G_INSPECTOR_PANEL (panel)->element = object;

    top = panel;
  }

  {
    frame = g_inspector_panel_frame_new ();
    g_inspector_panel_frame_set_title (G_INSPECTOR_PANEL_FRAME (frame), "Properties");

    gtk_container_add (GTK_CONTAINER (top), frame);
  }

  {
    GtkWidget *scrolled_window;

    scrolled_window = gtk_scrolled_window_new (NULL, NULL);
    gtk_scrolled_window_set_policy (GTK_SCROLLED_WINDOW (scrolled_window),
				    GTK_POLICY_NEVER,
				    GTK_POLICY_AUTOMATIC);
	  
    gtk_container_add (GTK_CONTAINER (frame), scrolled_window);

    table = gtk_table_new (1, 2, FALSE);
    gtk_widget_set_name (table, "table");

    gtk_scrolled_window_add_with_viewport (GTK_SCROLLED_WINDOW (scrolled_window),
					   table);
    gtk_viewport_set_shadow_type  (GTK_VIEWPORT (GTK_BIN (scrolled_window)->child),
				   GTK_SHADOW_NONE);
  }

  {
    g_signal_connect (panel,
		      "update",
		      G_CALLBACK (panel_property_list_update),
		      NULL);
  }

  {
    g_signal_connect_swapped (gtk_frame_get_label_widget (GTK_FRAME (frame)),
			      "clicked",
			      G_CALLBACK (g_inspector_panel_update),
			      panel);
  }

  {
    GClosure *closure;

    closure = g_cclosure_new (G_CALLBACK (object_notify),
			      panel,
			      NULL);

    g_object_watch_closure (G_OBJECT (panel),
			    closure);

    g_signal_connect_closure (object,
			      "notify",
			      closure,
			      FALSE);
  }


  g_inspector_panel_update (G_INSPECTOR_PANEL (panel));


  return top;
}
