/*
   Copyright (c) 2004, 2005 by AOSASA Shigeru and Red Hat, Inc.
   All rights reserved.

   Redistribution and use in source and binary forms, with or without
   modification, are permitted provided that the following conditions are
   met:

   - Redistributions of source code must retain the above copyright
   notice, this list of conditions and the following disclaimer.

   - Redistributions in binary form must reproduce the above
   copyright notice, this list of conditions and the following
   disclaimer in the documentation and/or other materials provided
   with the distribution.  

   - Neither the name of the AOSASA Shigeru, Red Hat, Inc
   nor the names of its contributors may be used to endorse or
   promote products derived from this software without specific
   prior written permission.

   THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
   "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
   LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS
   FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE
   COPYRIGHT OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT,
   INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
   (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
   SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
   HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT,
   STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
   ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED
   OF THE POSSIBILITY OF SUCH DAMAGE.
*/

/*
   This software development was supported by
   Information-technorogy Promotion Agency, Japan (IPA).
*/

#include "ginspector-procedure.h"

#include <string.h>
#include "gtype-utils.h"


static GList *procedure_info_list = NULL;


void
g_inspector_register_procedure (gchar                   *name,
				gchar                   *detail,
				GInspectorProcedureType  procedure_type,
				GInspectorElementType    target_element_type,
				GType                    gtype,
				GInspectorProcedureFunc  func,
				gpointer                 func_data)
{
  GInspectorProcedureInfo *info;

  g_return_if_fail (name != NULL);
  g_return_if_fail (func != NULL);


  info = g_new (GInspectorProcedureInfo, 1);

  info->name                = name;
  info->detail              = detail;
  info->procedure_type      = procedure_type;
  info->target_element_type = target_element_type;
  info->gtype               = gtype;
  info->func                = func;
  info->func_data           = func_data;

  procedure_info_list = g_list_append (procedure_info_list,
				       (gpointer)info);
}


static GInspectorProcedureInfo*
g_inspector_find_procedure_info_by_name (gchar *name)
{
  GInspectorProcedureInfo *info;


  info = NULL;

  if (name != NULL)
    {
      GInspectorProcedureInfo *tmp_info;
      GList *tmp;


      tmp = procedure_info_list;
      while (tmp != NULL)
	{
	  tmp_info = tmp->data;
	  tmp = g_list_next (tmp);

	  if (strcmp (tmp_info->name, name) == 0)
	    {
	      info = tmp_info;
	      break;
	    }
	}
    }

  return info;
}

GList*
g_inspector_get_procedure_info_list (void)
{
  return procedure_info_list;
}

gpointer
g_inspector_invoke_procedure_by_name (gchar    *name,
				      gpointer  data,
				      gpointer  invoke_data)
{
  GInspectorProcedureInfo *info;
  gpointer r;

  g_return_val_if_fail (name != NULL, NULL);


  info = g_inspector_find_procedure_info_by_name (name);
  r = NULL;

  if (info != NULL)
    {
      r = (* info->func) (data, info->func_data, invoke_data);
    }
  else
    {
      g_print ("%s(): %s: not registerd\n", __FUNCTION__, name);
    }

  return r;
}
