/*
   Copyright (c) 2004, 2005 by AOSASA Shigeru and Red Hat, Inc.
   All rights reserved.

   Redistribution and use in source and binary forms, with or without
   modification, are permitted provided that the following conditions are
   met:

   - Redistributions of source code must retain the above copyright
   notice, this list of conditions and the following disclaimer.

   - Redistributions in binary form must reproduce the above
   copyright notice, this list of conditions and the following
   disclaimer in the documentation and/or other materials provided
   with the distribution.  

   - Neither the name of the AOSASA Shigeru, Red Hat, Inc
   nor the names of its contributors may be used to endorse or
   promote products derived from this software without specific
   prior written permission.

   THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
   "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
   LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS
   FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE
   COPYRIGHT OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT,
   INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
   (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
   SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
   HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT,
   STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
   ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED
   OF THE POSSIBILITY OF SUCH DAMAGE.
*/

/*
   This software development was supported by
   Information-technorogy Promotion Agency, Japan (IPA).
*/

#include "ginspectorelementholder.h"

#include "glrr-gobject.h"


enum {
  CHANGED,
  LAST_SIGNAL
};

enum {
  PROP_0,
  PROP_VALUE,
};


static void g_inspector_element_holder_set_property (GObject      *object,
						     guint         prop_id,
						     const GValue *value,
						     GParamSpec   *pspec);
static void g_inspector_element_holder_get_property (GObject      *object,
						     guint         prop_id,
						     GValue       *value,
						     GParamSpec   *pspec);


static guint inspector_element_holder_signals[LAST_SIGNAL] = { 0 };


G_DEFINE_TYPE (GInspectorElementHolder, g_inspector_element_holder, G_TYPE_OBJECT);


static void
g_inspector_element_holder_class_init (GInspectorElementHolderClass *klass)
{
  GObjectClass *gobject_class;
  GObjectClass *object_class;
  GInspectorElementHolderClass *inspector_element_holder_class;

  gobject_class = G_OBJECT_CLASS (klass);
  object_class = (GObjectClass*) klass;
  inspector_element_holder_class = (GInspectorElementHolderClass*) klass;

  gobject_class->set_property = g_inspector_element_holder_set_property;
  gobject_class->get_property = g_inspector_element_holder_get_property;


  inspector_element_holder_signals[CHANGED] =
    g_signal_new ("changed",
                  G_TYPE_FROM_CLASS (gobject_class),
                  G_SIGNAL_RUN_FIRST,
                  G_STRUCT_OFFSET (GInspectorElementHolderClass, changed),
                  NULL, NULL,
                  g_cclosure_marshal_VOID__VOID,
                  G_TYPE_NONE, 0);
}

static void
g_inspector_element_holder_init (GInspectorElementHolder *inspector_element_holder)
{
  inspector_element_holder->element_type = G_INSPECTOR_ELEMENT_TYPE_NONE;
  inspector_element_holder->element = NULL;
}

static void
g_inspector_element_holder_set_property (GObject      *object,
					 guint         prop_id,
					 const GValue *value,
					 GParamSpec   *pspec)
{
  switch (prop_id)
    {
    default:
      G_OBJECT_WARN_INVALID_PROPERTY_ID (object, prop_id, pspec);
      break;
    }
}

static void
g_inspector_element_holder_get_property (GObject    *object,
					 guint       prop_id,
					 GValue     *value,
					 GParamSpec *pspec)
{
  switch (prop_id)
    {
    default:
      G_OBJECT_WARN_INVALID_PROPERTY_ID (object, prop_id, pspec);
      break;
    }
}

GInspectorElementHolder*
g_inspector_element_holder_new (void)
{
  GInspectorElementHolder *element_holder;

  element_holder = g_object_new (G_TYPE_INSPECTOR_ELEMENT_HOLDER,
				 NULL);

  return element_holder;
}

static void
g_inspector_element_holder_changed (GInspectorElementHolder *element_holder)
{
  g_signal_emit (element_holder,
		 inspector_element_holder_signals[CHANGED],
		 0);
}

static gboolean
g_inspector_element_holder_set_internal (GInspectorElementHolder *element_holder,
					 GInspectorElementType    element_type,
					 gpointer                 element)
{
  gboolean changed;

  if ((element_holder->element_type != element_type) ||
      (element_holder->element != element))
    {
      element_holder->element_type = element_type;
      element_holder->element = element;

      changed = TRUE;
    }
  else
    {
      changed = FALSE;
    }

  return changed;
}

static gboolean
g_inspector_element_holder_unset_internal (GInspectorElementHolder *element_holder)
{
  gboolean changed;

  changed = g_inspector_element_holder_set_internal (element_holder,
						     G_INSPECTOR_ELEMENT_TYPE_NONE,
						     NULL);

  return changed;
}

void
g_inspector_element_holder_set (GInspectorElementHolder *element_holder,
				GInspectorElementType    element_type,
				gpointer                 element)
{
  gboolean changed;

  g_return_if_fail (element_holder != NULL);
  g_return_if_fail (G_IS_INSPECTOR_ELEMENT_HOLDER (element_holder));


  changed = g_inspector_element_holder_set_internal (element_holder,
						     element_type,
						     element);

  if (changed == TRUE)
    {
      g_inspector_element_holder_changed (element_holder);
    }
}

void
g_inspector_element_holder_unset (GInspectorElementHolder *element_holder)
{
  gboolean changed;

  g_return_if_fail (element_holder != NULL);
  g_return_if_fail (G_IS_INSPECTOR_ELEMENT_HOLDER (element_holder));


  changed = g_inspector_element_holder_unset_internal (element_holder);

  if (changed == TRUE)
    {
      g_inspector_element_holder_changed (element_holder);
    }
}

GInspectorElementType
g_inspector_element_holder_get_element_type (GInspectorElementHolder *element_holder)
{
  GInspectorElementType element_type;

  g_return_val_if_fail (element_holder != NULL, G_INSPECTOR_ELEMENT_TYPE_NONE);
  g_return_val_if_fail (G_IS_INSPECTOR_ELEMENT_HOLDER (element_holder), G_INSPECTOR_ELEMENT_TYPE_NONE);


  element_type = element_holder->element_type;

  return element_type;
}

gpointer
g_inspector_element_holder_get_element (GInspectorElementHolder *element_holder)
{
  gpointer element;

  g_return_val_if_fail (element_holder != NULL, NULL);
  g_return_val_if_fail (G_IS_INSPECTOR_ELEMENT_HOLDER (element_holder), NULL);


  element = element_holder->element;

  return element;
}






void
g_inspector_element_holder_set_gtypeinstance (GInspectorElementHolder *element_holder,
					      GTypeInstance           *instance)
{
  g_return_if_fail (element_holder != NULL);
  g_return_if_fail (instance != NULL);
  g_return_if_fail (G_IS_INSPECTOR_ELEMENT_HOLDER (element_holder));

  g_inspector_element_holder_set (element_holder,
                                  G_INSPECTOR_ELEMENT_TYPE_GTYPEINSTANCE,
                                  (gpointer)instance);
}

void
g_inspector_element_holder_set_gobject (GInspectorElementHolder *element_holder,
					GObject                 *gobject)
{
  g_return_if_fail (element_holder != NULL);
  g_return_if_fail (gobject != NULL);
  g_return_if_fail (G_IS_INSPECTOR_ELEMENT_HOLDER (element_holder));
  g_return_if_fail (G_IS_OBJECT (gobject));

  g_inspector_element_holder_set_gtypeinstance (element_holder,
						(GTypeInstance*)gobject);
}

void
g_inspector_element_holder_set_gtype (GInspectorElementHolder *element_holder,
				      GType                    gtype)
{
  g_return_if_fail (element_holder != NULL);
  g_return_if_fail (G_IS_INSPECTOR_ELEMENT_HOLDER (element_holder));

  g_inspector_element_holder_set (element_holder,
                                  G_INSPECTOR_ELEMENT_TYPE_GTYPECLASS,
                                  GTYPE_TO_POINTER (gtype));
}
