/*
 * Copyright (C) 2000-2010  Innocent De Marchi
 * email: tangram.peces@gmail.com
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */


#ifndef FORMULARIPRINCIPAL_H
#define FORMULARIPRINCIPAL_H

//#include <QMainWindow>
//#include <QPair>

#include "comuns/constants.h"
#include "comuns/rellotge.h"
#include "formularis/desafigura.h"
/*
class QAction;
class QActionGroup;
class QGraphicsItem;
class QGraphicsScene;
class QGraphicsView;
class QFrame;
class QLabel;
class QTreeWidget;
class QSettings;
class QTimer;
*/
class Peca;
class ConjuntPeces;
class Configuracio;
class Rellotge;


class formulariPrincipal : public QMainWindow
{
    Q_OBJECT

public:
    formulariPrincipal();
    QGraphicsScene *sceneJoc;
    QGraphicsScene *sceneMostra;
    QFrame *sceneFrame;
    QFrame *contadorsFrame;

    QTreeWidget *arbreFiguresTreeWidget;

    ConjuntPeces *conjuntJoc;
    ConjuntPeces *conjuntFigura;
    ConjuntPeces *conjuntMostra;
   // Peca *pecaSeleccionada;
    Configuracio *configuracioJoc;
    /*
    Controla l'estat del joc
    */
    EstatsDelJoc estatDelJoc;
    /*
      El rellotge que controla el temps
    */
    Rellotge *rellotgeLabel;
    QLabel *numFigures;
    QLabel *punts;
    //Llista de les figures ja resoltes
    QStringList *figuresResoltesList;

    //LLista amb les dades de les figures semblants
    //(funció de cerca de figures semblants en la
    //creació de figures)
    QStringList *figuresSemblantsList;

private slots:


     void closeEvent(QCloseEvent *event);
    /*
     Gestiona la selecció d'una figura a l'arbre
     (conectat amb arbreFiguresTreeWidget::itemSelectionChanged ()
    */
    void seleccioFigura();

    void creaArxiuImatge(QString nomArxiu);

    void canvisSceneJoc();

 /*
  Slots d'eliminació de records
*/
    void eliminaRecordSlot();
    void eliminaTotsRecordsSlot();

    void carregaFiguresProgramaSlot();
    void carregaFiguresArxiuSlot();
/*
  Slots de creació dels tangrams
*/
    void tangramBrugnerSlot();
    void tangram4Slot();
    void tangram4IISlot();
    void tangram5Slot();
    void tangramSLSlot();
    void tangramRegulusSlot();
    void tangram6Slot();
    void tangram6IISlot();
    void tangramHexagramaSlot();
    void tangramClassicSlot();
    void tangramFletcherSlot();
    void tangramHEPSlot();
    void tangram7ISlot();
    void tangram7IISlot();
    void tangramXinesSlot();
    void tangramSaviesaSlot();
    void tangram8Slot();
    void tangramCIISlot();
    void tangram9Slot();
    void tangram9TSlot();
    void tangramOuSlot();
    void tangramCorSlot();
    void tangram10Slot();
    void tangramESlot();
    void tangramELSlot();
    void tangramCISlot();
    void tangram11Slot();
    void tangramRusSlot();
    void tangram13Slot();
    void tangram14Slot();
    void tangramStomachSlot();
    void tangramStomachionSlot();
    void tangramStomachionIISlot();
    void creaTangram(int tipusTangram);
 //final slots de creació dels tangrams

/*
  Slots del nivell de joc
*/
void nivellInfantilSlot();
void nivellPrincipiantSlot();
void nivellIniciatSlot();
void nivellExpertSlot();
void canviaNivellJoc(int pnivellJoc);

/*
Creació de noves figures
*/
void comprovaMostraSlot();
void esborraMostraSlot();
void desaFiguraSlot();
void simetriaVerticalSlot();
void simetriaHoritzontalSlot();
void cercaFiguraSlot();
void figuraSeguentSlot();
void figuraAnteriorSlot();

/*
  Ajuda per resoldre les figures
*/
void mostraSolucioSlot();
void colocaPecaSlot();

void proposaFiguraSlot();
void cercaNomFiguraSlot();
void continuaCercaNomFiguraSlot();

/*
 Gestió de concurs
*/
void creaConcursSlot();
void carregaConcursSlot();

/*
  Selecció d'idioma
*/
void seleccioIdioma(QString locale);
void localeSistemaSlot();
void localeCatalaSlot();
void localeCastellaSlot();
void localeGallegSlot();
void localeEuskeraSlot();
void localePortuguesSlot();
void localeFrancesSlot();
void localeItaliaSlot();
void localeAlemanySlot();
void localeAnglesSlot();

//Ajuda
void ajudaSlot();
void webProgramaSlot();
void creditsProgramaSlot();
void colaboraProgramaSlot();

private:

    void creaAcccions();
    void creaMenus();
    void creaBarraTasques();
    void actualitzaMenus();

    void carregaArbreFigures(QString nomArxiu);
    void llegeixArxiuFigures( QString nomArxiu);

    void canviaEstatDelJoc(EstatsDelJoc estat);

    float figuraSolucionada();
    bool figuraSolucionadaNivellInfantil();

    void carregaContadors();
    void desaContadors();
    void actualitzaPuntuacio(int numFig=0,int afegeixPunts=0);
    void reiniciaContadors();

    void carregaFiguresResoltes();
    void desaFiguresResoltes();
    void eliminaFiguresResoltes(int tipus=0);
    QString nomArxiuFiguresResoltes();
    bool figuraJaResolta(QString nomFigura);


    void colocaPeca(int indexPecaAColocar);
    void colocaPeca(int indexPecaAColocar,int pecaFigura);
    bool pecaJaColocada(int indexPecaAColocar);
    bool colocaPecaNivellInfantil(int indexPeca);

    int pecaSeleccionadaNivellInfantil;

    QString nomFiguraPerCercar;
    int indexFiguraPerCercar;

    void tradueixGUI();
    //Afegeix a la llista de figures semblants (creació de figures)
    //les dades d'una figura
    void afegeixFiguraSemblant(float percentatge,int index);
    int indexLlistaFiguraSemblant;
    void mostraFiguraSemblant(int index);

    /*
      Retorna el icone corresponent al nivel de dificultat
      de la figura
    */
   // QIcon iconeFigura(int tipus);


    QMenu *aplicacioMenu;
    QToolBar *tangramsToolBar;


    QMenu *jocMenu;
    QMenu *jocsTangramMenu;
    QMenu *creaFiguraMenu;
    QMenu *concursMenu;
    QMenu *idiomaMenu;
    QMenu *ajudaMenu;
    /*
      Tangram actual
    */
    int tangramActual;
    int nivellJocActual;
/*
  Accions del programa
*/
    QAction *surtAction; //tanca el programa
    QAction *elimnaRecordAction;
    QAction *eliminaTotsRecordsAction;


    QAction *carregaFiguresProgramaAction;
    QAction *carregaFiguresArxiuAction;
    /*
    * Accions de creació de tangram
    */
    QAction *tangramBrugnerAction;
    QAction *tangram4Action;
    QAction *tangram4IIAction;
    QAction *tangram5Action;
    QAction *tangramSLAction;
    QAction *tangramRegulusAction;
    QAction *tangram6Action;
    QAction *tangram6IIAction;
    QAction *tangramHexagramaAction;
    QAction *tangramClassicAction;
    QAction *tangramFletcherAction;
    QAction *tangramHEPAction;
    QAction *tangram7IAction;
    QAction *tangram7IIAction;
    QAction *tangramXinesAction;
    QAction *tangramSaviesaAction;
    QAction *tangram8Action;
    QAction *tangramCIIAction;
    QAction *tangram9Action;
    QAction *tangram9TAction;
    QAction *tangramOuAction;
    QAction *tangramCorAction;
    QAction *tangram10Action;
    QAction *tangramEAction;
    QAction *tangramELAction;
    QAction *tangramCIAction;
    QAction *tangram11Action;
    QAction *tangramRusAction;
    QAction *tangram13Action;
    QAction *tangram14Action;
    QAction *tangramStomachAction;
    QAction *tangramStomachionAction;
    QAction *tangramStomachionIIAction;

    /*
      Procedimens de nivell del joc
    */
    QAction *nivellInfantilAction;
    QAction *nivellPrincipiantAction;
    QAction *nivellIniciatAction;
    QAction *nivellExpertAction;

    QActionGroup *nivellJocGroup;

    /*
      Creació de noves figures
    */
    QAction *comprovaMostraAction;
    QAction *esborraMostraAction;
    QAction *desaFiguraAction;
    QAction *simetriaVerticalAction;
    QAction *simetriaHoritzontalAction;
    QAction *cercaFiguraAction;
    QAction *figuraSeguentAction;
    QAction *figuraAnteriorAction;


    /*
      Ajudes per resoldre figures
    */
    QAction *mostraSolucioAction;
    QAction *colocaPecaAction;

    QAction *proposaFigura;


    QAction *cercaNomFigura;
    QAction *continuaCercaNomFigura;

/*
  Creació de concurs
*/
QAction *creaConcursAction;
QAction *carregaConcursAction;

    /*
      Idiomes
    */
    QAction *localeSistema;
    QAction *localeCatala;
    QAction *localeCastella;
    QAction *localeGalleg;
    QAction *localeEuskera;
    QAction *localePortugues;
    QAction *localeFrances;
    QAction *localeItalia;
    QAction *localeAlemany;
    QAction *localeAngles;

//Menu de l'ajuda
    QAction *ajuda;
    QAction *webPrograma;
    QAction *creditsPrograma;
    QAction *colaboraPrograma;

    QGraphicsView *viewJoc;
    QGraphicsView *viewMostra;

    QString charPathSeparator;
};

#endif
