/*
   Copyright (c) 2004, 2005 by AOSASA Shigeru and Red Hat, Inc.
   All rights reserved.

   Redistribution and use in source and binary forms, with or without
   modification, are permitted provided that the following conditions are
   met:

   - Redistributions of source code must retain the above copyright
   notice, this list of conditions and the following disclaimer.

   - Redistributions in binary form must reproduce the above
   copyright notice, this list of conditions and the following
   disclaimer in the documentation and/or other materials provided
   with the distribution.  

   - Neither the name of the AOSASA Shigeru, Red Hat, Inc
   nor the names of its contributors may be used to endorse or
   promote products derived from this software without specific
   prior written permission.

   THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
   "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
   LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS
   FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE
   COPYRIGHT OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT,
   INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
   (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
   SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
   HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT,
   STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
   ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED
   OF THE POSSIBILITY OF SUCH DAMAGE.
*/

/*
   This software development was supported by
   Information-technorogy Promotion Agency, Japan (IPA).
*/

#include "gtksimpletogglebutton.h"

#include "gtksimplebutton.h"


static void gtk_simple_toggle_button_class_init
			(GtkSimpleToggleButtonClass *klass);
static void gtk_simple_toggle_button_init
			(GtkSimpleToggleButton      *simple_toggle_button);

static GtkToggleButtonClass *parent_class = NULL;


GType
gtk_simple_toggle_button_get_type (void)
{
  static GType simple_toggle_button_type = 0;

  if (!simple_toggle_button_type)
    {
      static const GTypeInfo simple_toggle_button_info =
      {
	sizeof (GtkSimpleToggleButtonClass),
	NULL,		/* base_init */
	NULL,		/* base_finalize */
	(GClassInitFunc) gtk_simple_toggle_button_class_init,
	NULL,		/* class_finalize */
	NULL,		/* class_data */
	sizeof (GtkSimpleToggleButton),
	0,		/* n_preallocs */
	(GInstanceInitFunc) gtk_simple_toggle_button_init,
        NULL,           /* value_table */
      };

      simple_toggle_button_type =
	g_type_register_static (GTK_TYPE_TOGGLE_BUTTON,
				"GtkSimpleToggleButton",
				&simple_toggle_button_info, 0);
    }

  return simple_toggle_button_type;
}

static void
gtk_simple_toggle_button_class_init (GtkSimpleToggleButtonClass *class)
{
  GObjectClass *gobject_class;
  GtkWidgetClass *widget_class;
  GtkContainerClass *container_class;
  GtkButtonClass *button_class;
  GtkToggleButtonClass *toggle_button_class;
  GtkSimpleToggleButtonClass *simple_toggle_button_class;

  gobject_class = G_OBJECT_CLASS (class);
  widget_class = (GtkWidgetClass*) class;
  container_class = (GtkContainerClass*) class;
  button_class = (GtkButtonClass*) class;
  toggle_button_class = (GtkToggleButtonClass *) class;
  simple_toggle_button_class = (GtkSimpleToggleButtonClass *) class;

  parent_class = g_type_class_peek_parent (class);

  widget_class->size_request  = _gtk_simple_button_size_request;
  widget_class->size_allocate = _gtk_simple_button_size_allocate;
  widget_class->expose_event  = _gtk_simple_button_expose;
}

static void
gtk_simple_toggle_button_init (GtkSimpleToggleButton *simple_toggle_button)
{
}


GtkWidget*
gtk_simple_toggle_button_new (void)
{
  return g_object_new (GTK_TYPE_SIMPLE_TOGGLE_BUTTON,
		       NULL);
}

GtkWidget*
gtk_simple_toggle_button_new_with_label (const gchar *label)
{
  return g_object_new (GTK_TYPE_SIMPLE_TOGGLE_BUTTON,
		       "label", label,
		       NULL);
}
