/*
    Glurp - A GTK+ client for Music Player Daemon
    Copyright (C) 2004, 2005 Andrej Kacian

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

    http://musicpd.org/glurp.shtml

*/

#ifndef __SUPPORT_H
#define __SUPPORT_H

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif /* HAVE_CONFIG_H */

#ifdef GLURP_DEBUG
#define debug(str, ARGS...)	debug_real(__FILE__, __LINE__, __FUNCTION__, str, ##ARGS)
#else
#define debug(str, ARGS...)
#endif

void debug_real(const char *file, const int line, const char *function, const char *msg, ...);

void statusbar_print(const char *string, ...);
gboolean statusbar_reset();
gchar *status_string();

void title_print(GtkWidget *window, const char *string, ...);

GlurpSong *get_nth_song_from_playlist(gint pos);
gchar *strip_dirs(gchar *path);
gchar *glade_path();

gchar *glurp_filename(gchar *path);

GlurpSong *get_song_by_pos(gint pos);
GlurpSong *get_song_by_id(gint id);
gint get_song_pos(GlurpSong *song);
gint get_num_songs();

void update_song(mpd_Song *song);
void add_song(mpd_Song *song);

void debug_print_playlist();

GlurpStream *get_stream_history(gchar *urls);
void print_stream_history();
gchar *dump_stream_history();
void push_stream(gchar *url);

/* convenience macros */
#define NONBLOCKING_UPDATE_CAPABLE_MPD	((glurp->conn->version[0] > 0 || \
					 glurp->conn->version[1] >= 11) ? TRUE : FALSE)

#define STREAM_CAPABLE_MPD	((glurp->conn->version[0] > 0 || \
				 glurp->conn->version[1] >= 11) ? TRUE : FALSE)

#define OUTPUTS_CAPABLE_MPD	((glurp->conn->version[0] > 0 || \
				 glurp->conn->version[1] >= 12) ? TRUE : FALSE)

#define GLURP_TITLE_PREFIX	"Glurp v"GLURP_VERSION

#define MAX_STREAM_HISTORY	5

#endif /* __SUPPORT_H */
