-------------------------------------------------------------------------------
--                                                                           --
--                     GNADE  : GNat Ada Database Environment                --
--                                                                           --
--  Filename        : $Source: /cvsroot/gnade/gnade/esql/esql_parser.ads,v $
--| Description     : Scanner for the embedded SQL translator                --
--  Author          : Michael Erdmann <Michael.Erdmann@snafu.de>             --
--  Created On      : 22-Dec-2000                                            --
--  Last Modified By: $Author: merdmann $
--  Last Modified On: $Date: 2002/05/11 20:27:34 $                           --
--  Status          : $State: Exp $                                          --
--                                                                           --
--  Copyright (C) 2000-2002 Michael Erdmann                                  --
--                                                                           --
--  GNADE is free software;  you can redistribute it  and/or modify it under --
--  terms of the  GNU General Public License as published  by the Free Soft- --
--  ware  Foundation;  either version 2,  or (at your option) any later ver- --
--  sion.  GNAT is distributed in the hope that it will be useful, but WITH- --
--  OUT ANY WARRANTY;  without even the  implied warranty of MERCHANTABILITY --
--  or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License --
--  for  more details.  You should have  received  a copy of the GNU General --
--  Public License  distributed with GNAT;  see file COPYING.  If not, write --
--  to  the Free Software Foundation,  59 Temple Place - Suite 330,  Boston, --
--  MA 02111-1307, USA.                                                      --
--                                                                           --
--  As a special exception,  if other files  instantiate  generics from this --
--  unit, or you link  this unit with other files  to produce an executable, --
--  this  unit  does not  by itself cause  the resulting  executable  to  be --
--  covered  by the  GNU  General  Public  License.  This exception does not --
--  however invalidate  any other reasons why  the executable file  might be --
--  covered by the  GNU Public License.                                      --
--                                                                           --
--  GNADE is implemented to work with GNAT, the GNU Ada compiler.            --
--                                                                           --
--  Functional Description                                                   --
--  ======================                                                   --
--  This package contains the esql parser. The result of the                 --
--  parse process is stored in the ESQL_Reader data. As a consequence        --
--  the code generation is a part of this package as well.                   --
--                                                                           --
--  Restrictions                                                             --
--  ============                                                             --
--                                                                           --
--  References                                                               --
--  ==========                                                               --
--                                                                           --
-------------------------------------------------------------------------------

--* Translator packages
with Scanner;

package ESQL_Parser is

   type ESQL_Reader is private;

   Syntax_Exception      : exception ;
   End_Of_File_Exception : exception ;

   --|
   --| Create new instance of the ESQL Parser.
   --|
   function New_ESQL_Parser(
      F : in Scanner.File_Reader ) return ESQL_Reader;

   --|
   --| delete the parser and close all resources
   --|
   procedure Delete_ESQL_Reader(
      E : in out ESQL_Reader );

   --|
   --| Parse the a ESQL Statement. This prepares the data
   --| for the code generation
   --|
   procedure Embedded_SQL_Statement(
      e : in out ESQL_Reader );

   function Number_Of_Errors(
      E : ESQL_Reader ) return Natural;

   function Number_Of_Warnings(
      E : ESQL_Reader ) return Natural;

   -------------------------------------------------------------------------
private
   type ESQL_Reader_Type;
   type ESQL_Reader is access ESQL_Reader_Type;

end ESQL_Parser;


