/* SqliteDatabase.c generated by valac 0.11.3, the Vala compiler
 * generated from SqliteDatabase.vala, do not modify */

/*
 * Copyright (C) 2009 Sebastian Pölsterl
 *
 * This file is part of GNOME DVB Daemon.
 *
 * GNOME DVB Daemon is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * GNOME DVB Daemon is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with GNOME DVB Daemon.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <glib.h>
#include <glib-object.h>
#include <sqlite3.h>
#include <gio/gio.h>
#include <stdlib.h>
#include <string.h>


#define DVB_DATABASE_SQLITE_TYPE_SQLITE_DATABASE (dvb_database_sqlite_sqlite_database_get_type ())
#define DVB_DATABASE_SQLITE_SQLITE_DATABASE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), DVB_DATABASE_SQLITE_TYPE_SQLITE_DATABASE, DVBdatabasesqliteSqliteDatabase))
#define DVB_DATABASE_SQLITE_SQLITE_DATABASE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), DVB_DATABASE_SQLITE_TYPE_SQLITE_DATABASE, DVBdatabasesqliteSqliteDatabaseClass))
#define DVB_DATABASE_SQLITE_IS_SQLITE_DATABASE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), DVB_DATABASE_SQLITE_TYPE_SQLITE_DATABASE))
#define DVB_DATABASE_SQLITE_IS_SQLITE_DATABASE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), DVB_DATABASE_SQLITE_TYPE_SQLITE_DATABASE))
#define DVB_DATABASE_SQLITE_SQLITE_DATABASE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), DVB_DATABASE_SQLITE_TYPE_SQLITE_DATABASE, DVBdatabasesqliteSqliteDatabaseClass))

typedef struct _DVBdatabasesqliteSqliteDatabase DVBdatabasesqliteSqliteDatabase;
typedef struct _DVBdatabasesqliteSqliteDatabaseClass DVBdatabasesqliteSqliteDatabaseClass;
typedef struct _DVBdatabasesqliteSqliteDatabasePrivate DVBdatabasesqliteSqliteDatabasePrivate;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _sqlite3_close0(var) ((var == NULL) ? NULL : (var = (sqlite3_close (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _sqlite3_finalize0(var) ((var == NULL) ? NULL : (var = (sqlite3_finalize (var), NULL)))

typedef enum  {
	DVB_DATABASE_SQL_ERROR_ERROR,
	DVB_DATABASE_SQL_ERROR_INTERNAL,
	DVB_DATABASE_SQL_ERROR_PERM,
	DVB_DATABASE_SQL_ERROR_ABORT,
	DVB_DATABASE_SQL_ERROR_BUSY,
	DVB_DATABASE_SQL_ERROR_LOCKED,
	DVB_DATABASE_SQL_ERROR_NOMEM,
	DVB_DATABASE_SQL_ERROR_READONLY,
	DVB_DATABASE_SQL_ERROR_INTERRUPT,
	DVB_DATABASE_SQL_ERROR_IOERR,
	DVB_DATABASE_SQL_ERROR_CORRUPT,
	DVB_DATABASE_SQL_ERROR_NOTFOUND,
	DVB_DATABASE_SQL_ERROR_FULL,
	DVB_DATABASE_SQL_ERROR_CANTOPEN,
	DVB_DATABASE_SQL_ERROR_PROTOCOL,
	DVB_DATABASE_SQL_ERROR_EMPTY,
	DVB_DATABASE_SQL_ERROR_SCHEMA,
	DVB_DATABASE_SQL_ERROR_TOOBIG,
	DVB_DATABASE_SQL_ERROR_CONSTRAINT,
	DVB_DATABASE_SQL_ERROR_MISMATCH,
	DVB_DATABASE_SQL_ERROR_MISUSE,
	DVB_DATABASE_SQL_ERROR_NOLFS,
	DVB_DATABASE_SQL_ERROR_AUTH,
	DVB_DATABASE_SQL_ERROR_FORMAT,
	DVB_DATABASE_SQL_ERROR_RANGE,
	DVB_DATABASE_SQL_ERROR_NOTADB
} DVBdatabaseSqlError;
#define DVB_DATABASE_SQL_ERROR dvb_database_sql_error_quark ()
struct _DVBdatabasesqliteSqliteDatabase {
	GObject parent_instance;
	DVBdatabasesqliteSqliteDatabasePrivate * priv;
	sqlite3* db;
};

struct _DVBdatabasesqliteSqliteDatabaseClass {
	GObjectClass parent_class;
	void (*create) (DVBdatabasesqliteSqliteDatabase* self, GError** error);
	void (*upgrade) (DVBdatabasesqliteSqliteDatabase* self, gint old_version, gint new_version, GError** error);
	void (*on_open) (DVBdatabasesqliteSqliteDatabase* self);
};

struct _DVBdatabasesqliteSqliteDatabasePrivate {
	GFile* _database_file;
	gint new_version;
};


static gpointer dvb_database_sqlite_sqlite_database_parent_class = NULL;

GType dvb_database_sqlite_sqlite_database_get_type (void) G_GNUC_CONST;
GQuark dvb_database_sql_error_quark (void);
#define DVB_DATABASE_SQLITE_SQLITE_DATABASE_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), DVB_DATABASE_SQLITE_TYPE_SQLITE_DATABASE, DVBdatabasesqliteSqliteDatabasePrivate))
enum  {
	DVB_DATABASE_SQLITE_SQLITE_DATABASE_DUMMY_PROPERTY,
	DVB_DATABASE_SQLITE_SQLITE_DATABASE_DATABASE_FILE
};
DVBdatabasesqliteSqliteDatabase* dvb_database_sqlite_sqlite_database_construct (GType object_type, GFile* dbfile, gint version);
void dvb_database_sqlite_sqlite_database_open (DVBdatabasesqliteSqliteDatabase* self, GError** error);
GFile* dvb_database_sqlite_sqlite_database_get_database_file (DVBdatabasesqliteSqliteDatabase* self);
void dvb_utils_mkdirs (GFile* directory, GError** error);
void dvb_database_sqlite_sqlite_database_throw_last_error (DVBdatabasesqliteSqliteDatabase* self, const gchar* errmsg, GError** error);
gint dvb_database_sqlite_sqlite_database_get_version (DVBdatabasesqliteSqliteDatabase* self);
void dvb_database_sqlite_sqlite_database_create (DVBdatabasesqliteSqliteDatabase* self, GError** error);
void dvb_database_sqlite_sqlite_database_upgrade (DVBdatabasesqliteSqliteDatabase* self, gint old_version, gint new_version, GError** error);
void dvb_database_sqlite_sqlite_database_set_version (DVBdatabasesqliteSqliteDatabase* self, gint version);
void dvb_database_sqlite_sqlite_database_set_journal_mode (DVBdatabasesqliteSqliteDatabase* self);
void dvb_database_sqlite_sqlite_database_on_open (DVBdatabasesqliteSqliteDatabase* self);
void dvb_database_sqlite_sqlite_database_exec_sql (DVBdatabasesqliteSqliteDatabase* self, const gchar* sql, GError** error);
gint dvb_database_sqlite_sqlite_database_simple_query_int (DVBdatabasesqliteSqliteDatabase* self, const gchar* sql, GError** error);
void dvb_database_sqlite_sqlite_database_begin_transaction (DVBdatabasesqliteSqliteDatabase* self, GError** error);
void dvb_database_sqlite_sqlite_database_end_transaction (DVBdatabasesqliteSqliteDatabase* self, GError** error);
void dvb_database_sqlite_sqlite_database_throw_last_error_reset (DVBdatabasesqliteSqliteDatabase* self, sqlite3_stmt* stmnt, GError** error);
static void dvb_database_sqlite_sqlite_database_real_create (DVBdatabasesqliteSqliteDatabase* self, GError** error);
static void dvb_database_sqlite_sqlite_database_real_upgrade (DVBdatabasesqliteSqliteDatabase* self, gint old_version, gint new_version, GError** error);
static void dvb_database_sqlite_sqlite_database_real_on_open (DVBdatabasesqliteSqliteDatabase* self);
static void dvb_database_sqlite_sqlite_database_set_database_file (DVBdatabasesqliteSqliteDatabase* self, GFile* value);
static void dvb_database_sqlite_sqlite_database_finalize (GObject* obj);
static void _vala_dvb_database_sqlite_sqlite_database_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
static void _vala_dvb_database_sqlite_sqlite_database_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec);


DVBdatabasesqliteSqliteDatabase* dvb_database_sqlite_sqlite_database_construct (GType object_type, GFile* dbfile, gint version) {
	DVBdatabasesqliteSqliteDatabase * self = NULL;
	g_return_val_if_fail (dbfile != NULL, NULL);
	self = (DVBdatabasesqliteSqliteDatabase*) g_object_new (object_type, "database-file", dbfile, NULL);
	self->priv->new_version = version;
	return self;
}


/**
         * Open database and create or upgrade tables if neccessary
         */
static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


void dvb_database_sqlite_sqlite_database_open (DVBdatabasesqliteSqliteDatabase* self, GError** error) {
	GFile* _tmp0_;
	GFile* dbfile;
	gboolean _tmp1_;
	gboolean create_tables;
	GFile* _tmp2_ = NULL;
	GFile* dbfile_dir;
	gboolean _tmp3_;
	gchar* _tmp4_ = NULL;
	gchar* _tmp5_;
	sqlite3* _tmp6_ = NULL;
	gint _tmp7_;
	gboolean _tmp8_;
	gint _tmp9_;
	gint version;
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	if (self->db != NULL) {
		return;
	}
	_tmp0_ = _g_object_ref0 (self->priv->_database_file);
	dbfile = _tmp0_;
	_tmp1_ = g_file_query_exists (dbfile, NULL);
	create_tables = !_tmp1_;
	_tmp2_ = g_file_get_parent (dbfile);
	dbfile_dir = _tmp2_;
	_tmp3_ = g_file_query_exists (dbfile_dir, NULL);
	if (!_tmp3_) {
		dvb_utils_mkdirs (dbfile_dir, &_inner_error_);
		if (_inner_error_ != NULL) {
			goto __catch0_g_error;
		}
		goto __finally0;
		__catch0_g_error:
		{
			GError * e;
			e = _inner_error_;
			_inner_error_ = NULL;
			g_critical ("SqliteDatabase.vala:51: Could not create directory: %s", e->message);
			_g_error_free0 (e);
			_g_object_unref0 (dbfile_dir);
			_g_object_unref0 (dbfile);
			return;
		}
		__finally0:
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == DVB_DATABASE_SQL_ERROR) {
				g_propagate_error (error, _inner_error_);
				_g_object_unref0 (dbfile_dir);
				_g_object_unref0 (dbfile);
				return;
			} else {
				_g_object_unref0 (dbfile_dir);
				_g_object_unref0 (dbfile);
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
				g_clear_error (&_inner_error_);
				return;
			}
		}
	}
	_tmp4_ = g_file_get_path (dbfile);
	_tmp5_ = _tmp4_;
	_tmp7_ = sqlite3_open (_tmp5_, &_tmp6_);
	_sqlite3_close0 (self->db);
	self->db = _tmp6_;
	if ((_tmp8_ = _tmp7_ != SQLITE_OK, _g_free0 (_tmp5_), _tmp8_)) {
		dvb_database_sqlite_sqlite_database_throw_last_error (self, NULL, &_inner_error_);
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == DVB_DATABASE_SQL_ERROR) {
				g_propagate_error (error, _inner_error_);
				_g_object_unref0 (dbfile_dir);
				_g_object_unref0 (dbfile);
				return;
			} else {
				_g_object_unref0 (dbfile_dir);
				_g_object_unref0 (dbfile);
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
				g_clear_error (&_inner_error_);
				return;
			}
		}
	}
	_tmp9_ = dvb_database_sqlite_sqlite_database_get_version (self);
	version = _tmp9_;
	if (create_tables) {
		g_debug ("SqliteDatabase.vala:63: Creating tables");
		dvb_database_sqlite_sqlite_database_create (self, &_inner_error_);
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == DVB_DATABASE_SQL_ERROR) {
				g_propagate_error (error, _inner_error_);
				_g_object_unref0 (dbfile_dir);
				_g_object_unref0 (dbfile);
				return;
			} else {
				_g_object_unref0 (dbfile_dir);
				_g_object_unref0 (dbfile);
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
				g_clear_error (&_inner_error_);
				return;
			}
		}
	} else {
		if (self->priv->new_version > version) {
			g_debug ("SqliteDatabase.vala:66: Updating tables");
			dvb_database_sqlite_sqlite_database_upgrade (self, version, self->priv->new_version, &_inner_error_);
			if (_inner_error_ != NULL) {
				if (_inner_error_->domain == DVB_DATABASE_SQL_ERROR) {
					g_propagate_error (error, _inner_error_);
					_g_object_unref0 (dbfile_dir);
					_g_object_unref0 (dbfile);
					return;
				} else {
					_g_object_unref0 (dbfile_dir);
					_g_object_unref0 (dbfile);
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
					g_clear_error (&_inner_error_);
					return;
				}
			}
		}
	}
	dvb_database_sqlite_sqlite_database_set_version (self, self->priv->new_version);
	dvb_database_sqlite_sqlite_database_set_journal_mode (self);
	dvb_database_sqlite_sqlite_database_on_open (self);
	_g_object_unref0 (dbfile_dir);
	_g_object_unref0 (dbfile);
}


/**
         * Set database version
         */
void dvb_database_sqlite_sqlite_database_set_version (DVBdatabasesqliteSqliteDatabase* self, gint version) {
	gchar* _tmp0_ = NULL;
	gchar* _tmp1_;
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = g_strdup_printf ("PRAGMA user_version = %d", version);
	_tmp1_ = _tmp0_;
	dvb_database_sqlite_sqlite_database_exec_sql (self, _tmp1_, &_inner_error_);
	_g_free0 (_tmp1_);
	if (_inner_error_ != NULL) {
		if (_inner_error_->domain == DVB_DATABASE_SQL_ERROR) {
			goto __catch1_dvb_database_sql_error;
		}
		g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
	goto __finally1;
	__catch1_dvb_database_sql_error:
	{
		GError * e;
		e = _inner_error_;
		_inner_error_ = NULL;
		g_critical ("SqliteDatabase.vala:82: %s", e->message);
		_g_error_free0 (e);
	}
	__finally1:
	if (_inner_error_ != NULL) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
}


void dvb_database_sqlite_sqlite_database_set_journal_mode (DVBdatabasesqliteSqliteDatabase* self) {
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	dvb_database_sqlite_sqlite_database_exec_sql (self, "PRAGMA journal_mode = TRUNCATE", &_inner_error_);
	if (_inner_error_ != NULL) {
		if (_inner_error_->domain == DVB_DATABASE_SQL_ERROR) {
			goto __catch2_dvb_database_sql_error;
		}
		g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
	goto __finally2;
	__catch2_dvb_database_sql_error:
	{
		GError * e;
		e = _inner_error_;
		_inner_error_ = NULL;
		g_critical ("SqliteDatabase.vala:90: %s", e->message);
		_g_error_free0 (e);
	}
	__finally2:
	if (_inner_error_ != NULL) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
}


/**
         * Get database version
         */
gint dvb_database_sqlite_sqlite_database_get_version (DVBdatabasesqliteSqliteDatabase* self) {
	gint result = 0;
	gint version;
	gint _tmp0_;
	gint _tmp1_;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (self != NULL, 0);
	version = 0;
	_tmp0_ = dvb_database_sqlite_sqlite_database_simple_query_int (self, "PRAGMA user_version", &_inner_error_);
	_tmp1_ = _tmp0_;
	if (_inner_error_ != NULL) {
		if (_inner_error_->domain == DVB_DATABASE_SQL_ERROR) {
			goto __catch3_dvb_database_sql_error;
		}
		g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return 0;
	}
	version = _tmp1_;
	goto __finally3;
	__catch3_dvb_database_sql_error:
	{
		GError * e;
		e = _inner_error_;
		_inner_error_ = NULL;
		g_critical ("SqliteDatabase.vala:102: %s", e->message);
		_g_error_free0 (e);
	}
	__finally3:
	if (_inner_error_ != NULL) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return 0;
	}
	result = version;
	return result;
}


gint dvb_database_sqlite_sqlite_database_simple_query_int (DVBdatabasesqliteSqliteDatabase* self, const gchar* sql, GError** error) {
	gint result = 0;
	sqlite3_stmt* st;
	sqlite3_stmt* _tmp0_ = NULL;
	gint ret;
	gint _tmp1_;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (self != NULL, 0);
	g_return_val_if_fail (sql != NULL, 0);
	st = NULL;
	sqlite3_prepare (self->db, sql, -1, &_tmp0_, NULL);
	_sqlite3_finalize0 (st);
	st = _tmp0_;
	ret = 0;
	_tmp1_ = sqlite3_step (st);
	if (_tmp1_ == SQLITE_ROW) {
		gint _tmp2_;
		_tmp2_ = sqlite3_column_int (st, 0);
		ret = _tmp2_;
	} else {
		dvb_database_sqlite_sqlite_database_throw_last_error (self, NULL, &_inner_error_);
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == DVB_DATABASE_SQL_ERROR) {
				g_propagate_error (error, _inner_error_);
				_sqlite3_finalize0 (st);
				return 0;
			} else {
				_sqlite3_finalize0 (st);
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
				g_clear_error (&_inner_error_);
				return 0;
			}
		}
	}
	result = ret;
	_sqlite3_finalize0 (st);
	return result;
}


static gint _sqlite3_exec (sqlite3* self, const gchar* sql, sqlite3_callback sqlite3_callback, void* sqlite3_callback_target, gchar** errmsg) {
	gchar* _errmsg = NULL;
	gint result = 0;
	const gchar* sqlite_errmsg;
	const gchar* _tmp0_ = NULL;
	gint _tmp1_;
	gint ec;
	g_return_val_if_fail (self != NULL, 0);
	g_return_val_if_fail (sql != NULL, 0);
	sqlite_errmsg = NULL;
	_tmp1_ = sqlite3_exec (self, sql, sqlite3_callback, sqlite3_callback_target, (char**) (&_tmp0_));
	sqlite_errmsg = _tmp0_;
	ec = _tmp1_;
	if ((&_errmsg) != NULL) {
		gchar* _tmp2_;
		gchar* _tmp3_;
		_tmp2_ = g_strdup (sqlite_errmsg);
		_tmp3_ = _tmp2_;
		_g_free0 (_errmsg);
		_errmsg = _tmp3_;
	}
	sqlite3_free ((void*) sqlite_errmsg);
	result = ec;
	if (errmsg) {
		*errmsg = _errmsg;
	} else {
		_g_free0 (_errmsg);
	}
	return result;
}


void dvb_database_sqlite_sqlite_database_exec_sql (DVBdatabasesqliteSqliteDatabase* self, const gchar* sql, GError** error) {
	gchar* errmsg;
	gchar* _tmp0_ = NULL;
	gint _tmp1_;
	gint val;
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (sql != NULL);
	errmsg = NULL;
	_tmp1_ = _sqlite3_exec (self->db, sql, NULL, NULL, &_tmp0_);
	_g_free0 (errmsg);
	errmsg = _tmp0_;
	val = _tmp1_;
	if (val != SQLITE_OK) {
		dvb_database_sqlite_sqlite_database_throw_last_error (self, NULL, &_inner_error_);
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == DVB_DATABASE_SQL_ERROR) {
				g_propagate_error (error, _inner_error_);
				_g_free0 (errmsg);
				return;
			} else {
				_g_free0 (errmsg);
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
				g_clear_error (&_inner_error_);
				return;
			}
		}
	}
	_g_free0 (errmsg);
}


void dvb_database_sqlite_sqlite_database_begin_transaction (DVBdatabasesqliteSqliteDatabase* self, GError** error) {
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	dvb_database_sqlite_sqlite_database_exec_sql (self, "BEGIN;", &_inner_error_);
	if (_inner_error_ != NULL) {
		if (_inner_error_->domain == DVB_DATABASE_SQL_ERROR) {
			g_propagate_error (error, _inner_error_);
			return;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
	}
}


void dvb_database_sqlite_sqlite_database_end_transaction (DVBdatabasesqliteSqliteDatabase* self, GError** error) {
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	dvb_database_sqlite_sqlite_database_exec_sql (self, "END;", &_inner_error_);
	if (_inner_error_ != NULL) {
		if (_inner_error_->domain == DVB_DATABASE_SQL_ERROR) {
			g_propagate_error (error, _inner_error_);
			return;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
	}
}


void dvb_database_sqlite_sqlite_database_throw_last_error_reset (DVBdatabasesqliteSqliteDatabase* self, sqlite3_stmt* stmnt, GError** error) {
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (stmnt != NULL);
	sqlite3_reset (stmnt);
	dvb_database_sqlite_sqlite_database_throw_last_error (self, NULL, &_inner_error_);
	if (_inner_error_ != NULL) {
		if (_inner_error_->domain == DVB_DATABASE_SQL_ERROR) {
			g_propagate_error (error, _inner_error_);
			return;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
	}
}


void dvb_database_sqlite_sqlite_database_throw_last_error (DVBdatabasesqliteSqliteDatabase* self, const gchar* errmsg, GError** error) {
	gint _tmp0_;
	gint code;
	gchar* msg;
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = sqlite3_errcode (self->db);
	code = _tmp0_;
	msg = NULL;
	if (errmsg == NULL) {
		const gchar* _tmp1_ = NULL;
		gchar* _tmp2_ = NULL;
		gchar* _tmp3_;
		_tmp1_ = sqlite3_errmsg (self->db);
		_tmp2_ = g_strdup_printf ("SqlError: %d: %s", code, _tmp1_);
		_tmp3_ = _tmp2_;
		_g_free0 (msg);
		msg = _tmp3_;
	} else {
		gchar* _tmp4_;
		gchar* _tmp5_;
		_tmp4_ = g_strdup (errmsg);
		_tmp5_ = _tmp4_;
		_g_free0 (msg);
		msg = _tmp5_;
	}
	switch (code) {
		case 1:
		{
			GError* _tmp6_ = NULL;
			_tmp6_ = g_error_new_literal (DVB_DATABASE_SQL_ERROR, DVB_DATABASE_SQL_ERROR_ERROR, msg);
			_inner_error_ = _tmp6_;
			if (_inner_error_->domain == DVB_DATABASE_SQL_ERROR) {
				g_propagate_error (error, _inner_error_);
				_g_free0 (msg);
				return;
			} else {
				_g_free0 (msg);
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
				g_clear_error (&_inner_error_);
				return;
			}
		}
		case 2:
		{
			GError* _tmp7_ = NULL;
			_tmp7_ = g_error_new_literal (DVB_DATABASE_SQL_ERROR, DVB_DATABASE_SQL_ERROR_INTERNAL, msg);
			_inner_error_ = _tmp7_;
			if (_inner_error_->domain == DVB_DATABASE_SQL_ERROR) {
				g_propagate_error (error, _inner_error_);
				_g_free0 (msg);
				return;
			} else {
				_g_free0 (msg);
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
				g_clear_error (&_inner_error_);
				return;
			}
		}
		case 3:
		{
			GError* _tmp8_ = NULL;
			_tmp8_ = g_error_new_literal (DVB_DATABASE_SQL_ERROR, DVB_DATABASE_SQL_ERROR_PERM, msg);
			_inner_error_ = _tmp8_;
			if (_inner_error_->domain == DVB_DATABASE_SQL_ERROR) {
				g_propagate_error (error, _inner_error_);
				_g_free0 (msg);
				return;
			} else {
				_g_free0 (msg);
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
				g_clear_error (&_inner_error_);
				return;
			}
		}
		case 4:
		{
			GError* _tmp9_ = NULL;
			_tmp9_ = g_error_new_literal (DVB_DATABASE_SQL_ERROR, DVB_DATABASE_SQL_ERROR_ABORT, msg);
			_inner_error_ = _tmp9_;
			if (_inner_error_->domain == DVB_DATABASE_SQL_ERROR) {
				g_propagate_error (error, _inner_error_);
				_g_free0 (msg);
				return;
			} else {
				_g_free0 (msg);
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
				g_clear_error (&_inner_error_);
				return;
			}
		}
		case 5:
		{
			GError* _tmp10_ = NULL;
			_tmp10_ = g_error_new_literal (DVB_DATABASE_SQL_ERROR, DVB_DATABASE_SQL_ERROR_BUSY, msg);
			_inner_error_ = _tmp10_;
			if (_inner_error_->domain == DVB_DATABASE_SQL_ERROR) {
				g_propagate_error (error, _inner_error_);
				_g_free0 (msg);
				return;
			} else {
				_g_free0 (msg);
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
				g_clear_error (&_inner_error_);
				return;
			}
		}
		case 6:
		{
			GError* _tmp11_ = NULL;
			_tmp11_ = g_error_new_literal (DVB_DATABASE_SQL_ERROR, DVB_DATABASE_SQL_ERROR_LOCKED, msg);
			_inner_error_ = _tmp11_;
			if (_inner_error_->domain == DVB_DATABASE_SQL_ERROR) {
				g_propagate_error (error, _inner_error_);
				_g_free0 (msg);
				return;
			} else {
				_g_free0 (msg);
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
				g_clear_error (&_inner_error_);
				return;
			}
		}
		case 7:
		{
			GError* _tmp12_ = NULL;
			_tmp12_ = g_error_new_literal (DVB_DATABASE_SQL_ERROR, DVB_DATABASE_SQL_ERROR_NOMEM, msg);
			_inner_error_ = _tmp12_;
			if (_inner_error_->domain == DVB_DATABASE_SQL_ERROR) {
				g_propagate_error (error, _inner_error_);
				_g_free0 (msg);
				return;
			} else {
				_g_free0 (msg);
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
				g_clear_error (&_inner_error_);
				return;
			}
		}
		case 8:
		{
			GError* _tmp13_ = NULL;
			_tmp13_ = g_error_new_literal (DVB_DATABASE_SQL_ERROR, DVB_DATABASE_SQL_ERROR_READONLY, msg);
			_inner_error_ = _tmp13_;
			if (_inner_error_->domain == DVB_DATABASE_SQL_ERROR) {
				g_propagate_error (error, _inner_error_);
				_g_free0 (msg);
				return;
			} else {
				_g_free0 (msg);
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
				g_clear_error (&_inner_error_);
				return;
			}
		}
		case 9:
		{
			GError* _tmp14_ = NULL;
			_tmp14_ = g_error_new_literal (DVB_DATABASE_SQL_ERROR, DVB_DATABASE_SQL_ERROR_INTERRUPT, msg);
			_inner_error_ = _tmp14_;
			if (_inner_error_->domain == DVB_DATABASE_SQL_ERROR) {
				g_propagate_error (error, _inner_error_);
				_g_free0 (msg);
				return;
			} else {
				_g_free0 (msg);
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
				g_clear_error (&_inner_error_);
				return;
			}
		}
		case 10:
		{
			GError* _tmp15_ = NULL;
			_tmp15_ = g_error_new_literal (DVB_DATABASE_SQL_ERROR, DVB_DATABASE_SQL_ERROR_IOERR, msg);
			_inner_error_ = _tmp15_;
			if (_inner_error_->domain == DVB_DATABASE_SQL_ERROR) {
				g_propagate_error (error, _inner_error_);
				_g_free0 (msg);
				return;
			} else {
				_g_free0 (msg);
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
				g_clear_error (&_inner_error_);
				return;
			}
		}
		case 11:
		{
			GError* _tmp16_ = NULL;
			_tmp16_ = g_error_new_literal (DVB_DATABASE_SQL_ERROR, DVB_DATABASE_SQL_ERROR_CORRUPT, msg);
			_inner_error_ = _tmp16_;
			if (_inner_error_->domain == DVB_DATABASE_SQL_ERROR) {
				g_propagate_error (error, _inner_error_);
				_g_free0 (msg);
				return;
			} else {
				_g_free0 (msg);
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
				g_clear_error (&_inner_error_);
				return;
			}
		}
		case 12:
		{
			GError* _tmp17_ = NULL;
			_tmp17_ = g_error_new_literal (DVB_DATABASE_SQL_ERROR, DVB_DATABASE_SQL_ERROR_NOTFOUND, msg);
			_inner_error_ = _tmp17_;
			if (_inner_error_->domain == DVB_DATABASE_SQL_ERROR) {
				g_propagate_error (error, _inner_error_);
				_g_free0 (msg);
				return;
			} else {
				_g_free0 (msg);
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
				g_clear_error (&_inner_error_);
				return;
			}
		}
		case 13:
		{
			GError* _tmp18_ = NULL;
			_tmp18_ = g_error_new_literal (DVB_DATABASE_SQL_ERROR, DVB_DATABASE_SQL_ERROR_FULL, msg);
			_inner_error_ = _tmp18_;
			if (_inner_error_->domain == DVB_DATABASE_SQL_ERROR) {
				g_propagate_error (error, _inner_error_);
				_g_free0 (msg);
				return;
			} else {
				_g_free0 (msg);
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
				g_clear_error (&_inner_error_);
				return;
			}
		}
		case 14:
		{
			GError* _tmp19_ = NULL;
			_tmp19_ = g_error_new_literal (DVB_DATABASE_SQL_ERROR, DVB_DATABASE_SQL_ERROR_CANTOPEN, msg);
			_inner_error_ = _tmp19_;
			if (_inner_error_->domain == DVB_DATABASE_SQL_ERROR) {
				g_propagate_error (error, _inner_error_);
				_g_free0 (msg);
				return;
			} else {
				_g_free0 (msg);
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
				g_clear_error (&_inner_error_);
				return;
			}
		}
		case 15:
		{
			GError* _tmp20_ = NULL;
			_tmp20_ = g_error_new_literal (DVB_DATABASE_SQL_ERROR, DVB_DATABASE_SQL_ERROR_PROTOCOL, msg);
			_inner_error_ = _tmp20_;
			if (_inner_error_->domain == DVB_DATABASE_SQL_ERROR) {
				g_propagate_error (error, _inner_error_);
				_g_free0 (msg);
				return;
			} else {
				_g_free0 (msg);
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
				g_clear_error (&_inner_error_);
				return;
			}
		}
		case 16:
		{
			GError* _tmp21_ = NULL;
			_tmp21_ = g_error_new_literal (DVB_DATABASE_SQL_ERROR, DVB_DATABASE_SQL_ERROR_EMPTY, msg);
			_inner_error_ = _tmp21_;
			if (_inner_error_->domain == DVB_DATABASE_SQL_ERROR) {
				g_propagate_error (error, _inner_error_);
				_g_free0 (msg);
				return;
			} else {
				_g_free0 (msg);
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
				g_clear_error (&_inner_error_);
				return;
			}
		}
		case 17:
		{
			GError* _tmp22_ = NULL;
			_tmp22_ = g_error_new_literal (DVB_DATABASE_SQL_ERROR, DVB_DATABASE_SQL_ERROR_SCHEMA, msg);
			_inner_error_ = _tmp22_;
			if (_inner_error_->domain == DVB_DATABASE_SQL_ERROR) {
				g_propagate_error (error, _inner_error_);
				_g_free0 (msg);
				return;
			} else {
				_g_free0 (msg);
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
				g_clear_error (&_inner_error_);
				return;
			}
		}
		case 18:
		{
			GError* _tmp23_ = NULL;
			_tmp23_ = g_error_new_literal (DVB_DATABASE_SQL_ERROR, DVB_DATABASE_SQL_ERROR_TOOBIG, msg);
			_inner_error_ = _tmp23_;
			if (_inner_error_->domain == DVB_DATABASE_SQL_ERROR) {
				g_propagate_error (error, _inner_error_);
				_g_free0 (msg);
				return;
			} else {
				_g_free0 (msg);
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
				g_clear_error (&_inner_error_);
				return;
			}
		}
		case 19:
		{
			GError* _tmp24_ = NULL;
			_tmp24_ = g_error_new_literal (DVB_DATABASE_SQL_ERROR, DVB_DATABASE_SQL_ERROR_CONSTRAINT, msg);
			_inner_error_ = _tmp24_;
			if (_inner_error_->domain == DVB_DATABASE_SQL_ERROR) {
				g_propagate_error (error, _inner_error_);
				_g_free0 (msg);
				return;
			} else {
				_g_free0 (msg);
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
				g_clear_error (&_inner_error_);
				return;
			}
		}
		case 20:
		{
			GError* _tmp25_ = NULL;
			_tmp25_ = g_error_new_literal (DVB_DATABASE_SQL_ERROR, DVB_DATABASE_SQL_ERROR_MISMATCH, msg);
			_inner_error_ = _tmp25_;
			if (_inner_error_->domain == DVB_DATABASE_SQL_ERROR) {
				g_propagate_error (error, _inner_error_);
				_g_free0 (msg);
				return;
			} else {
				_g_free0 (msg);
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
				g_clear_error (&_inner_error_);
				return;
			}
		}
		case 21:
		{
			GError* _tmp26_ = NULL;
			_tmp26_ = g_error_new_literal (DVB_DATABASE_SQL_ERROR, DVB_DATABASE_SQL_ERROR_MISUSE, msg);
			_inner_error_ = _tmp26_;
			if (_inner_error_->domain == DVB_DATABASE_SQL_ERROR) {
				g_propagate_error (error, _inner_error_);
				_g_free0 (msg);
				return;
			} else {
				_g_free0 (msg);
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
				g_clear_error (&_inner_error_);
				return;
			}
		}
		case 22:
		{
			GError* _tmp27_ = NULL;
			_tmp27_ = g_error_new_literal (DVB_DATABASE_SQL_ERROR, DVB_DATABASE_SQL_ERROR_NOLFS, msg);
			_inner_error_ = _tmp27_;
			if (_inner_error_->domain == DVB_DATABASE_SQL_ERROR) {
				g_propagate_error (error, _inner_error_);
				_g_free0 (msg);
				return;
			} else {
				_g_free0 (msg);
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
				g_clear_error (&_inner_error_);
				return;
			}
		}
		case 23:
		{
			GError* _tmp28_ = NULL;
			_tmp28_ = g_error_new_literal (DVB_DATABASE_SQL_ERROR, DVB_DATABASE_SQL_ERROR_AUTH, msg);
			_inner_error_ = _tmp28_;
			if (_inner_error_->domain == DVB_DATABASE_SQL_ERROR) {
				g_propagate_error (error, _inner_error_);
				_g_free0 (msg);
				return;
			} else {
				_g_free0 (msg);
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
				g_clear_error (&_inner_error_);
				return;
			}
		}
		case 24:
		{
			GError* _tmp29_ = NULL;
			_tmp29_ = g_error_new_literal (DVB_DATABASE_SQL_ERROR, DVB_DATABASE_SQL_ERROR_FORMAT, msg);
			_inner_error_ = _tmp29_;
			if (_inner_error_->domain == DVB_DATABASE_SQL_ERROR) {
				g_propagate_error (error, _inner_error_);
				_g_free0 (msg);
				return;
			} else {
				_g_free0 (msg);
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
				g_clear_error (&_inner_error_);
				return;
			}
		}
		case 25:
		{
			GError* _tmp30_ = NULL;
			_tmp30_ = g_error_new_literal (DVB_DATABASE_SQL_ERROR, DVB_DATABASE_SQL_ERROR_RANGE, msg);
			_inner_error_ = _tmp30_;
			if (_inner_error_->domain == DVB_DATABASE_SQL_ERROR) {
				g_propagate_error (error, _inner_error_);
				_g_free0 (msg);
				return;
			} else {
				_g_free0 (msg);
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
				g_clear_error (&_inner_error_);
				return;
			}
		}
		case 26:
		{
			GError* _tmp31_ = NULL;
			_tmp31_ = g_error_new_literal (DVB_DATABASE_SQL_ERROR, DVB_DATABASE_SQL_ERROR_NOTADB, msg);
			_inner_error_ = _tmp31_;
			if (_inner_error_->domain == DVB_DATABASE_SQL_ERROR) {
				g_propagate_error (error, _inner_error_);
				_g_free0 (msg);
				return;
			} else {
				_g_free0 (msg);
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
				g_clear_error (&_inner_error_);
				return;
			}
		}
		default:
		{
			break;
		}
	}
	_g_free0 (msg);
}


/**
         * Called when the database is created for the first time.
         * Put the commands required to create all tables here.
         */
static void dvb_database_sqlite_sqlite_database_real_create (DVBdatabasesqliteSqliteDatabase* self, GError** error) {
	g_return_if_fail (self != NULL);
	g_critical ("Type `%s' does not implement abstract method `dvb_database_sqlite_sqlite_database_create'", g_type_name (G_TYPE_FROM_INSTANCE (self)));
	return;
}


void dvb_database_sqlite_sqlite_database_create (DVBdatabasesqliteSqliteDatabase* self, GError** error) {
	DVB_DATABASE_SQLITE_SQLITE_DATABASE_GET_CLASS (self)->create (self, error);
}


/**
         * Called when the database needs to be upgraded.
         */
static void dvb_database_sqlite_sqlite_database_real_upgrade (DVBdatabasesqliteSqliteDatabase* self, gint old_version, gint new_version, GError** error) {
	g_return_if_fail (self != NULL);
	g_critical ("Type `%s' does not implement abstract method `dvb_database_sqlite_sqlite_database_upgrade'", g_type_name (G_TYPE_FROM_INSTANCE (self)));
	return;
}


void dvb_database_sqlite_sqlite_database_upgrade (DVBdatabasesqliteSqliteDatabase* self, gint old_version, gint new_version, GError** error) {
	DVB_DATABASE_SQLITE_SQLITE_DATABASE_GET_CLASS (self)->upgrade (self, old_version, new_version, error);
}


/**
          * Called when the database has been opened.
          */
static void dvb_database_sqlite_sqlite_database_real_on_open (DVBdatabasesqliteSqliteDatabase* self) {
	g_return_if_fail (self != NULL);
	g_critical ("Type `%s' does not implement abstract method `dvb_database_sqlite_sqlite_database_on_open'", g_type_name (G_TYPE_FROM_INSTANCE (self)));
	return;
}


void dvb_database_sqlite_sqlite_database_on_open (DVBdatabasesqliteSqliteDatabase* self) {
	DVB_DATABASE_SQLITE_SQLITE_DATABASE_GET_CLASS (self)->on_open (self);
}


GFile* dvb_database_sqlite_sqlite_database_get_database_file (DVBdatabasesqliteSqliteDatabase* self) {
	GFile* result;
	g_return_val_if_fail (self != NULL, NULL);
	result = self->priv->_database_file;
	return result;
}


static void dvb_database_sqlite_sqlite_database_set_database_file (DVBdatabasesqliteSqliteDatabase* self, GFile* value) {
	GFile* _tmp0_;
	GFile* _tmp1_;
	g_return_if_fail (self != NULL);
	_tmp0_ = _g_object_ref0 (value);
	_tmp1_ = _tmp0_;
	_g_object_unref0 (self->priv->_database_file);
	self->priv->_database_file = _tmp1_;
	g_object_notify ((GObject *) self, "database-file");
}


static void dvb_database_sqlite_sqlite_database_class_init (DVBdatabasesqliteSqliteDatabaseClass * klass) {
	dvb_database_sqlite_sqlite_database_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (DVBdatabasesqliteSqliteDatabasePrivate));
	DVB_DATABASE_SQLITE_SQLITE_DATABASE_CLASS (klass)->create = dvb_database_sqlite_sqlite_database_real_create;
	DVB_DATABASE_SQLITE_SQLITE_DATABASE_CLASS (klass)->upgrade = dvb_database_sqlite_sqlite_database_real_upgrade;
	DVB_DATABASE_SQLITE_SQLITE_DATABASE_CLASS (klass)->on_open = dvb_database_sqlite_sqlite_database_real_on_open;
	G_OBJECT_CLASS (klass)->get_property = _vala_dvb_database_sqlite_sqlite_database_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_dvb_database_sqlite_sqlite_database_set_property;
	G_OBJECT_CLASS (klass)->finalize = dvb_database_sqlite_sqlite_database_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), DVB_DATABASE_SQLITE_SQLITE_DATABASE_DATABASE_FILE, g_param_spec_object ("database-file", "database-file", "database-file", G_TYPE_FILE, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
}


static void dvb_database_sqlite_sqlite_database_instance_init (DVBdatabasesqliteSqliteDatabase * self) {
	self->priv = DVB_DATABASE_SQLITE_SQLITE_DATABASE_GET_PRIVATE (self);
}


static void dvb_database_sqlite_sqlite_database_finalize (GObject* obj) {
	DVBdatabasesqliteSqliteDatabase * self;
	self = DVB_DATABASE_SQLITE_SQLITE_DATABASE (obj);
	_g_object_unref0 (self->priv->_database_file);
	_sqlite3_close0 (self->db);
	G_OBJECT_CLASS (dvb_database_sqlite_sqlite_database_parent_class)->finalize (obj);
}


GType dvb_database_sqlite_sqlite_database_get_type (void) {
	static volatile gsize dvb_database_sqlite_sqlite_database_type_id__volatile = 0;
	if (g_once_init_enter (&dvb_database_sqlite_sqlite_database_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (DVBdatabasesqliteSqliteDatabaseClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) dvb_database_sqlite_sqlite_database_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (DVBdatabasesqliteSqliteDatabase), 0, (GInstanceInitFunc) dvb_database_sqlite_sqlite_database_instance_init, NULL };
		GType dvb_database_sqlite_sqlite_database_type_id;
		dvb_database_sqlite_sqlite_database_type_id = g_type_register_static (G_TYPE_OBJECT, "DVBdatabasesqliteSqliteDatabase", &g_define_type_info, G_TYPE_FLAG_ABSTRACT);
		g_once_init_leave (&dvb_database_sqlite_sqlite_database_type_id__volatile, dvb_database_sqlite_sqlite_database_type_id);
	}
	return dvb_database_sqlite_sqlite_database_type_id__volatile;
}


static void _vala_dvb_database_sqlite_sqlite_database_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	DVBdatabasesqliteSqliteDatabase * self;
	self = DVB_DATABASE_SQLITE_SQLITE_DATABASE (object);
	switch (property_id) {
		case DVB_DATABASE_SQLITE_SQLITE_DATABASE_DATABASE_FILE:
		g_value_set_object (value, dvb_database_sqlite_sqlite_database_get_database_file (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void _vala_dvb_database_sqlite_sqlite_database_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	DVBdatabasesqliteSqliteDatabase * self;
	self = DVB_DATABASE_SQLITE_SQLITE_DATABASE (object);
	switch (property_id) {
		case DVB_DATABASE_SQLITE_SQLITE_DATABASE_DATABASE_FILE:
		dvb_database_sqlite_sqlite_database_set_database_file (self, g_value_get_object (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}



