# mhash.m4 - Macros to locate Mhash
#
# Copyright 2005 Kouji TAKAO
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful, but
# WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
# General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
#
# As a special exception to the GNU General Public License, if you
# distribute this file as part of a program that contains a
# configuration script generated by Autoconf, you may include it under
# the same distribution terms that you use for the rest of that program.

# AM_PATH_MHASH
# =============
# Adds support for Mhash - http://mhash.sourceforge.net/
# export MHASH_INCLUDES, MHASH_LIBS, HAVE_MHASH
# ----------------------------------------------------------
AC_DEFUN(AM_PATH_MHASH,
[
  AC_ARG_WITH(mhash-includes,
  AC_HELP_STRING([--with-mhash-includes=ARG],
                 [include directory for Mhash]),
  [
    AC_MSG_RESULT(using $withval to include mhash.h)
    MHASH_INCLUDES="$withval"
  ])

  AC_ARG_WITH(mhash-libs,
  AC_HELP_STRING([--with-mhash-libs=ARG],
                 [libraries for Mhash]),
  [
    AC_MSG_RESULT(using $withval to link Mhash)
    MHASH_LIBS="$withval"
  ])
  if test -z "$MHASH_LIBS"; then
    AC_CHECK_LIB(mhash, mhash_init, 
                 [MHASH_LIBS=-lmhash], 
                 [AC_MSG_ERROR(libmhash not found)])
  fi
  HAVE_MHASH=yes
  
  AC_SUBST(MHASH_INCLUDES)
  AC_SUBST(MHASH_LIBS)
  AC_SUBST(HAVE_MHASH)
])
