/*
 *  Copyright (C) 2005 Kouji TAKAO <kouji@netlab.jp>
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Library General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#ifndef __GPASS_APPLICATION_H__
#define __GPASS_APPLICATION_H__

#include <glib-object.h>

#include "gpass/file.h"
#include "gpass/entry-factory.h"
#include "view-factory.h"
#include "command.h"

G_BEGIN_DECLS

typedef struct GPassApplication GPassApplication;
typedef struct GPassApplicationClass GPassApplicationClass;

#define GPASS_TYPE_APPLICATION (gpass_application_get_type())
#define GPASS_APPLICATION(obj) \
    (G_TYPE_CHECK_INSTANCE_CAST((obj), GPASS_TYPE_APPLICATION, \
                                GPassApplication))
#define GPASS_APPLICATION_CLASS(klass) \
    (G_TYPE_CHECK_CLASS_CAST((klass), GPASS_TYPE_APPLICATION, \
                             GPassApplicationClass))
#define GPASS_IS_APPLICATION(obj) \
    (G_TYPE_CHECK_INSTANCE_TYPE((obj), GPASS_TYPE_APPLICATION))
#define GPASS_IS_APPLICATION_CLASS(klass) \
    (G_TYPE_CHECK_CLASS_TYPE((klass), GPASS_TYPE_APPLICATION))
#define GPASS_APPLICATION_GET_CLASS(obj) \
    (G_TYPE_INSTANCE_GET_CLASS((obj), GPASS_TYPE_APPLICATION, \
                               GPassApplicationClass))

struct GPassApplication {
    GObject parent;
    
    gchar *file_path;
    GPassFile *file;
    GPassEntry *passwords;
    GPassEntryFactory *entry_factory;
    GPassViewFactory *view_factory;
    GPassCommandStack *command_stack;
    gboolean changed_master_password;
};

struct GPassApplicationClass {
    GObjectClass parent;
};

GType gpass_application_get_type(void);

GError *gpass_application_welcome(GPassApplication *self, gboolean *result);
GError *gpass_application_run(GPassApplication *self, gboolean *result);
void gpass_application_change_master_password(GPassApplication *self,
                                              const gchar *master_password);
gboolean gpass_application_passwords_is_changed(GPassApplication *self);
GError *gpass_application_passwords_save(GPassApplication *self,
                                         gboolean *result);
GError *gpass_application_passwords_edit(GPassApplication *self,
                                         GPassEntry *target,
                                         GPassEntry *edited);
GError *gpass_application_passwords_insert(GPassApplication *self,
                                           GPassEntry *target,
                                           GPassEntry *parent,
                                           GPassEntry *sibling);
GError *gpass_application_passwords_unlink(GPassApplication *self,
                                           GPassEntry *target,
                                           GPassEntry *parent,
                                           GPassEntry *sibling);
GError *gpass_application_passwords_move_after(GPassApplication *self,
                                               GPassEntry *target,
                                               GPassEntry *parent,
                                               GPassEntry *previous);

G_END_DECLS

#endif /* #ifndef __GPASS_APPLICATION_H__ */
