/*  gtk-imonc - imond client for fli4l
 *  gets news from fli4l.de
 *
 *  Copyright (C) 2002 Stefan Strigler <zeank@x-berg.de>
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public Licensse as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#include <gtk/gtk.h>
#include <stdio.h>
#include <stdlib.h>
#include <unistd.h>

#include "news.h"
#include "imonc.h"

void 
get_news																(GtkTextView *news_text)
{
	gchar 		*buf;
	gint 		buffer_size = 0;
	gchar       ch[1];
	gint        web_fd;
	gint        n = 0;

	gchar *text, *utf8_text;
	GtkTextBuffer *gbuf;
	
	GError *error = NULL;

	if ((web_fd = service_connect ("fli4l.de", 80)) < 0)
		return;
	
	send_command (web_fd, "GET http://www.fli4l.de/german/news.txt HTTP/1.0\nHost: www.fli4l.de\n\n"); 
	
	if (buffer_size == 0)
		{
			buffer_size = GRANULARITY;
			buf = g_malloc (buffer_size);
		}
	
	while (read (web_fd, ch, 1) > 0) {
		if (n + 1 == buffer_size)
			{
				buffer_size += GRANULARITY;
				buf = realloc (buf, buffer_size);
			}
		buf[n] = ch[0];         
		n++;
	}
	
	
	
	/* skip http header */
	text = buf;
	while (text[1] != '\0') {
		if(text[0] == '\n' && text[1] == '\r')
			break;
		text++;
	}
	while (*text == '\r' || *text == '\n')
		text++;

	/* get text view's associated buffer */
	gbuf = gtk_text_view_get_buffer(news_text);
	
	utf8_text = g_convert (text, strlen(text), "UTF-8", "ISO-8859-1", 
							NULL, NULL, &error);
	if (error != NULL) {
		g_print("error converting news to utf-8 ...");
		g_free(error);
		return; 
	}

	gtk_text_buffer_set_text(gbuf,utf8_text,-1);
	
	g_free(buf);

	service_disconnect (web_fd);
} /* end get_news */
