#ifndef ENVIRONMENT_H
#define ENVIRONMENT_H

/*
 * Common environment for most program functions
 *
 * Copyright (C) 2003  Enrico Zini <enrico@debian.org>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

#include <string>
#include <vector>

class Environment
{
protected:
	
	// Default iterface to use
	std::string _iface;

	// Default tag to print when nothing is found
	std::string _defprof;

	// Timeout after which we decide we haven't found anything
	int _timeout;

	// Time we wait after initializing an interface
	int _init_timeout;

	// Filter in/out profiles based on their names
	bool _autofilter;

	// Initial delay to set in case of race conditions
	int _initdelay;

	Environment() throw ();

	static void init(Environment* instance) throw ();

public:
	static Environment& get() throw ();

	// Accessor methods
	const std::string& iface() const throw () { return _iface; }
	std::string iface(const std::string& iface) throw () { return _iface = iface; }

	const std::string& defprof() const throw () { return _defprof; }
	std::string defprof(const std::string& defprof) throw () { return _defprof = defprof; }

	int timeout() const throw () { return _timeout; }
	int timeout(int timeout) throw () { return _timeout = timeout; }

	int initTimeout() const throw () { return _init_timeout; }
	int initTimeout(int initTimeout) throw () { return _init_timeout = initTimeout; }

	bool autofilter() const throw () { return _autofilter; }
	bool autofilter(int autofilter) throw () { return _autofilter = autofilter; }

	int initdelay() const throw () { return _initdelay; }
	int initdelay(int initdelay) throw () { return _initdelay = initdelay; }
};

// vim:set ts=4 sw=4:
#endif
