(use-modules (database berkeley))

(define d (db-open "test.db"))
(db-put-text d "1" "foo")
(db-put-text d "2" "bar")
(db-put-binary d '#y(0) '#y(123))
(db-put-binary d '#y(1) '#y(-123))
(db-close d)

(define d (db-open "test.db"))

(display "Test 1 ")
(if (string=? (db-get-text d "1") "foo")
    (display "passed.")
    (display "failed."))
(newline)

(display "Test 2 ")
(if (string=? (db-get-text d "2") "bar")
    (display "passed.")
    (display "failed."))
(newline)

(display "Test 3 ")
(if (= (array-ref (db-get-binary d '#y(0)) 0) 123)
    (display "passed.")
    (display "failed."))
(newline)

(display "Test 4 ")
(if (= (array-ref (db-get-binary d '#y(1)) 0) -123)
    (display "passed.")
    (display "failed."))
(newline)

(db-close d)
