/* IMSpector - Instant Messenger Transparent Proxy Service
 * http://www.imspector.org/
 * (c) Lawrence Manning <lawrence@aslak.net>, 2006
 *          
 * Released under the GPL v2. */

struct protocolplugininfo
{
	std::string pluginname;
	std::string protocolname;
	uint16_t port; 				/* Network byte order. */
#ifdef HAVE_SSL
	uint16_t sslport;
#endif
};

typedef bool (*initprotocolplugintype)(struct protocolplugininfo &protocolplugininfo,
	class Options &options, bool debugmode);
typedef void (*closeprotocolplugintype)(void);
typedef int (*processpackettype)(bool outgoing, class Socket &incomingsock, char *replybuffer, 
	int *replybufferlength, std::vector<struct imevent> &imevents, std::string &clientaddress);
typedef int (*generatemessagepackettype)(struct response &response, char *replybuffer, int *replybufferlength);
	
class ProtocolPlugin
{
	public:
		struct protocolplugininfo protocolplugininfo;
	
		ProtocolPlugin();
		~ProtocolPlugin();
		bool loadplugin(std::string filename);
		bool unloadplugin(void);
		
		bool callinitprotocolplugin(class Options &options, bool debugmode);
		void callcloseprotocolplugin(void);
		int callprocesspacket(bool outgoing, class Socket &incomingsock, char *replybuffer,
			int *replybufferlength, std::vector<struct imevent> &imevents, std::string &clientaddress);
		int callgeneratemessagepacket(struct response &response, char *replybuffer, int *replybufferlength);

	private:
		void *handle;

		initprotocolplugintype initprotocolplugin;
		closeprotocolplugintype closeprotocolplugin;
		processpackettype processpacket;
		generatemessagepackettype generatemessagepacket;
};
