#!/usr/bin/python

"""
PyShellcodeLib - A library to write shellcodes coding in python.
Copyright(c) 2007 Joxean Koret <joxeankoret@yahoo.es>
"""

"""
The dictionary SYSCALLS stores all the system calls for the selected operative system.

OpenBSD
"""

SYSCALLS = {
    "syscall":0,
    "exit":1,
    "fork":2,
    "read":3,
    "write":4,
    "open":5,
    "close":6,
    "wait4":7,
    "compat_43_ocreat":8,
    "link":9,
    "unlink":10,
    "execv":11,
    "chdir":12,
    "fchdir":13,
    "mknod":14,
    "chmod":15,
    "chown":16,
    "break":17,
    "compat_25_ogetfsstat":18,
    "compat_43_olseek":19,
    "getpid":20,
    "mount":21,
    "unmount":22,
    "setuid":23,
    "getuid":24,
    "geteuid":25,
    "ptrace":26,
    "recvmsg":27,
    "sendmsg":28,
    "recvfrom":29,
    "accept":30,
    "getpeername":31,
    "getsockname":32,
    "access":33,
    "chflags":34,
    "fchflags":35,
    "sync":36,
    "kill":37,
    "compat_43_stat43":38,
    "getppid":39,
    "compat_43_lstat43":40,
    "dup":41,
    "opipe":42,
    "getegid":43,
    "profil":44,
    "ktrace":45,
    "sigaction":46,
    "getgid":47,
    "sigprocmask":48,
    "getlogin":49,
    "setlogin":50,
    "acct":51,
    "sigpending":52,
    "osigaltstack":53,
    "ioctl":54,
    "reboot":55,
    "revoke":56,
    "symlink":57,
    "readlink":58,
    "execve":59,
    "umask":60,
    "chroot":61,
    "compat_43_fstat43":62,
    "compat_43_ogetkerninfo":63,
    "compat_43_ogetpagesize":64,
    "compat_25_omsync":65,
    "vfork":66,
    "vread":67,
    "vwrite":68,
    "sbrk":69,
    "sstk":70,
    "compat_43_ommap":71,
    "vadvise":72,
    "munmap":73,
    "mprotect":74,
    "madvise":75,
    "vhangup":76,
    "vlimit":77,
    "mincore":78,
    "getgroups":79,
    "setgroups":80,
    "getpgrp":81,
    "setpgid":82,
    "setitimer":83,
    "compat_43_owait":84,
    "compat_25_swapon":85,
    "getitimer":86,
    "compat_43_ogethostname":87,
    "compat_43_osethostname":88,
    "compat_43_ogetdtablesize":89,
    "dup2":90,
    "getdopt":91,
    "fcntl":92,
    "select":93,
    "setdopt":94,
    "fsync":95,
    "setpriority":96,
    "socketcall":97, # Yes, I'm known, is "socket", but is easier for me
    "connect":98,
    "compat_43_oaccept":99,
    "getpriority":100,
    "compat_43_osend":101,
    "compat_43_orecv":102,
    "sigreturn":103,
    "bind":104,
    "setsockopt":105,
    "listen":106,
    "vtimes":107,
    "compat_43_osigvec":108,
    "compat_43_osigblock":109,
    "compat_43_osigsetmask":110,
    "sigsuspend":111,
    "compat_43_osigstack":112,
    "compat_43_orecvmsg":113,
    "compat_43_osendmsg":114,
    "vtrace":115,
    "gettimeofday":116,
    "getrusage":117,
    "getsockopt":118,
    "resuba":119,
    "readv":120,
    "writev":121,
    "settimeofday":122,
    "fchown":123,
    "fchmod":124,
    "compat_43_orecvfrom":125,
    "setreuid":126,
    "setregid":127,
    "rename":128,
    "compat_43_otruncate":129,
    "compat_43_oftruncate":130,
    "flock":131,
    "mkfifo":132,
    "sendto":133,
    "shutdown":134,
    "socketpair":135,
    "mkdir":136,
    "rmdir":137,
    "utimes":138,
    "sigreturn":139,
    "adjtime":140,
    "compat_43_ogetpeername":141,
    "compat_43_ogethostid":142,
    "compat_43_osethostid":143,
    "compat_43_ogetrlimit":144,
    "compat_43_osetrlimit":145,
    "compat_43_okillpg":146,
    "setsid":147,
    "quotactl":148,
    "compat_43_oquota":149,
    "compat_43_ogetsockname":150,
    "nfssvc":155,
    "compat_43_ogetdirentries":156,
    "compat_25_ostatfs":157,
    "compat_25_ostatfs":158,
    "getfh":161,
    "compat_09_ogetdomainname":162,
    "compat_09_osetdomainname":163,
    "compat_09_ouname":164,
    "sysarch":165,
    "compat_10_osemsys":169,
    "compat_10_omsgsys":170,
    "compat_10_oshmsys":171,
    "pread":173,
    "pwrite":174,
    "ntp_gettime":175,
    "ntp_adjtime":176,
    "setgid":181,
    "setegid":182,
    "seteuid":183,
    "lfs_bmapv":184,
    "lfs_markv":185,
    "lfs_segclean":186,
    "lfs_segwait":187,
    "compat_35_stat35":188,
    "compat_35_fstat35":189,
    "compat_35_lstat35":190,
    "pathconf":191,
    "fpathconf":192,
    "swapctl":193,
    "getrlimit":194,
    "setrlimit":195,
    "getdirentries":196,
    "mmap":197,
    "__syscall":198,
    "lseek":199,
    "truncate":200,
    "ftruncate":201,
    "__sysctl":202,
    "mlock":203,
    "munlock":204,
    "sys_undelete":205,
    "futimes":206,
    "getpgid":207,
    "xfspioctl":208,
    "lkmnosys":210,
    "lkmnosys":211,
    "lkmnosys":212,
    "lkmnosys":213,
    "lkmnosys":214,
    "lkmnosys":215,
    "lkmnosys":216,
    "lkmnosys":217,
    "lkmnosys":218,
    "lkmnosys":219,
    "compat_23_semctl23":220,
    "semget":221,
    "compat_35_semop":222,
    "compat_23_msgctl23":224,
    "msgget":225,
    "msgsnd":226,
    "msgrcv":227,
    "shmat":228,
    "compat_23_shmctl23":229,
    "shmdt":230,
    "compat_35_shmget":231,
    "clock_gettime":232,
    "clock_settime":233,
    "clock_getres":234,
    "timer_create":235,
    "timer_delete":236,
    "timer_settime":237,
    "timer_gettime":238,
    "timer_getoverrun":239,
    "nanosleep":240,
    "minherit":250,
    "rfork":251,
    "poll":252,
    "issetugid":253,
    "lchown":254,
    "getsid":255,
    "msync":256,
    "compat_35_semctl35":257,
    "compat_35_shmctl35":258,
    "compat_35_msgctl35":259,
    "getfsstat":260,
    "statfs":261,
    "fstatfs":262,
    "pipe":263,
    "fhopen":264,
    "compat_35_fhstat":265,
    "fhstatfs":266,
    "preadv":267,
    "pwritev":268,
    "kqueue":269,
    "kevent":270,
    "mlockall":271,
    "munlockall":272,
    "getpeereid":273,
    "sys_extattrctl":274,
    "sys_extattr_set_file":275,
    "sys_extattr_get_file":276,
    "sys_extattr_delete_file":277,
    "sys_extattr_set_fd":278,
    "sys_extattr_get_fd":279,
    "sys_extattr_delete_fd":280,
    "getresuid":281,
    "setresuid":282,
    "getresgid":283,
    "setresgid":284,
    "sys_omquery":285,
    "mquery":286,
    "closefrom":287,
    "sigaltstack":288,
    "shmget":289,
    "semop":290,
    "stat":291,
    "fstat":292,
    "lstat":293,
    "fhstat":294,
    "__semctl":295,
    "shmctl":296,
    "msgctl":297,
    "sched_yield":298,
    "getthrid":299,
    "thrsleep":300,
    "thrwakeup":301,
    "threxit":302,
    "thrsigdivert":303,
    "__getcwd":304,
    "adjfreq":305
}

def getSyscall(syscallName):
    # Get the syscall number
    syscallId = SYSCALLS[syscallName]

    # Encode to hexadecimal
    hexUid = chr(syscallId)
    
    return hexUid
