#!/usr/bin/python

"""
Module protoscan for Inguma based in the Scapy's implementation
Copyright (c) 2007 Joxean Koret <joxeankoret@yahoo.es>

License is GPL
"""
import os
import sys
import time
import socket
import random

from lib.core import getProtocolName
from lib.libexploit import CIngumaModule

try:

    if os.name == "nt":
        from winscapy import sr, IP
    else:
        from scapy import sr, IP

    hasScapy = True
except:
    hasScapy = False

name = "protoscan"
brief_description = "An IP protocol scanner"
type = "gather"

class CProtoScan(CIngumaModule):

    target = ""
    exploitType = 1
    results = {}
    protocols = []
    dict = None

    def help(self):
        print "target = <target host or network>"

    def run(self):
        try:
            a, u = sr(IP(dst=self.target, proto=(1, 254)), timeout=self.timeout)
        except:
            print "protoscan:", sys.exc_info()[1]
            return False

        for x in u:
            self.addToDict(self.target + "_protocols", x.proto)
            self.protocols.append([self.target, x.proto])

        self.protocols.sort()
        
        if len(self.protocols) == 254:
            print "[!] Target appears to have all protocols enabled!"
            return False

        return True

    def printSummary(self):
        print
        print "Protocol scan results"
        print "---------------------"
        print

        for x in self.protocols:
            print "Protocol", getProtocolName(x[1]), "enabled at", x[0]

        print

