# ***** BEGIN LICENSE BLOCK *****
# Version: MPL 1.1/GPL 2.0/LGPL 2.1
#
# The contents of this file are subject to the Mozilla Public License Version
# 1.1 (the "License"); you may not use this file except in compliance with
# the License. You may obtain a copy of the License at
# http://www.mozilla.org/MPL/
#
# Software distributed under the License is distributed on an "AS IS" basis,
# WITHOUT WARRANTY OF ANY KIND, either express or implied. See the License
# for the specific language governing rights and limitations under the
# License.
#
# The Original Code is mozilla.org code.
#
# The Initial Developer of the Original Code is
#   Florian QUEZE <florian@instantbird.org>
# Portions created by the Initial Developer are Copyright (C) 2008
# the Initial Developer. All Rights Reserved.
#
# Contributor(s):
#
# Alternatively, the contents of this file may be used under the terms of
# either of the GNU General Public License Version 2 or later (the "GPL"),
# or the GNU Lesser General Public License Version 2.1 or later (the "LGPL"),
# in which case the provisions of the GPL or the LGPL are applicable instead
# of those above. If you wish to allow use of your version of this file only
# under the terms of either the GPL or the LGPL, and not to allow others to
# use your version of this file under the terms of the MPL, indicate your
# decision by deleting the provisions above and replace them with the notice
# and other provisions required by the GPL or the LGPL. If you do not delete
# the provisions above, a recipient may use your version of this file under
# the terms of any one of the MPL, the GPL or the LGPL.
#
# ***** END LICENSE BLOCK *****

include $(DEPTH)/config/autoconf.mk

MODULE		= purple/$(PROTOCOL)
LIBRARY_NAME	= $(PROTOCOL)
ifneq (,$(filter $(PROTOCOL),$(STATIC_PRPLS)))
FORCE_STATIC_LIB= 1
LIB_IS_C_ONLY   = 1
else
FORCE_SHARED_LIB= 1
endif
IS_COMPONENT	= 1
VISIBILITY_FLAGS=

REQUIRES	= \
		libpurple \
		purplexpcom \
		$(NULL)

ifneq (,$(filter-out WINNT WINCE Darwin,$(OS_ARCH)))
LOCAL_INCLUDES	= $(GLIB_CFLAGS)
EXTRA_LIBS	= ../../libpurple.so $(GLIB_LIBS) -lgmodule-2.0 -lxml2 -lz
else
EXTRA_LIBS	= -L../.. -lpurple -L$(DIST)/lib -lz
REQUIRES	+= \
		glib \
		$(NULL)
endif

ifeq (,$(filter-out WINNT WINCE,$(OS_ARCH)))
EXTRA_LIBS	= ../../purple.lib

ifeq ($(OS_ARCH),WINCE)
EXTRA_LIBS	+= ws2.lib
endif
endif

PURPLE_VERSION	= $(PURPLE_MAJOR_VERSION).$(PURPLE_MINOR_VERSION).$(PURPLE_MICRO_VERSION)
DEFINES		+= -DPACKAGE=\"$(PROTOCOL)\" -DVERSION=\"$(PURPLE_VERSION)\" -DDISPLAY_VERSION=\"$(PURPLE_VERSION)\"

ifneq (,$(filter $(PROTOCOL),$(STATIC_PRPLS)))
DEFINES += -DPURPLE_STATIC_PRPL
endif

GLOBAL_DEPS += $(srcdir)/../prpl.mk $(srcdir)/../prpl-rules.mk
