# $Header: /cvs/src/jbofihe/config.pl,v 1.20 2001/08/03 20:39:54 richard Exp $
#
# To be run with perl.  This builds Makefile from Makefile.in,
# substituting things whose location varies on different systems, and
# has to be looked for.
#
# There is no #! at the top because perl isn't installed in the same
# place on all systems.
#
#
# Copyright (C) Richard P. Curnow  1998-2001
# 
# This program is free software; you can redistribute it and/or modify
# it under the terms of version 2 of the GNU General Public License as
# published by the Free Software Foundation.
# 
# This program is distributed in the hope that it will be useful, but
# WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
# General Public License for more details.
# 
# You should have received a copy of the GNU General Public License along
# with this program; if not, write to the Free Software Foundation, Inc.,
# 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA
# 
#

$prefix="/usr/local";
$debug=0;
$profile=0;
$mmap=1;
$plist=0;
$embed=0;
$plist=0;

while ($_ = shift @ARGV) {
    if (/^--help/ || /^-h/) {
        &print_help();
        exit 0;
    } elsif (/^--prefix=(.*)$/) {
        $prefix = $1;
    } elsif (/^-p/) {
        $prefix = shift @ARGV;
    } elsif (/^--profile$/) {
		$profile = 1;
    } elsif (/^--plist$/) {
        $plist = 1;
    } elsif (/^--debug$/) {
		$debug = 1;
	} elsif (/^--nommap$/) {
        $mmap = 0;
    } elsif (/^--embed$/) {
        $embed = 1;
    }
}


if ($plist) {
    $defines .= " -DPLIST";
    $cmafihe_ldopts=" -lPropList";
} else {
    $cmafihe_ldopts="";
}

$optdebug = $debug ? " -g -Wall" : " -O2";
if ($profile) {
    $optdebug .= " -pg";
}
$mmap_flag = $mmap ? " -DHAVE_MMAP=1" : "";
$defines .= $mmap_flag;
if ($debug) {


    $defines .= " -DEXPOSE_SIGNALS";
}

if ($embed) {
    $dictdata_c = "dictdata.c";
    $defines .= " -DEMBEDDED_DICTIONARY";
} else {
    $dictdata_c = "";
}
    

open(IN, "<Makefile.in");
open(OUT, ">Makefile");
while (<IN>) 
{
    s/\@\@PREFIX\@\@/$prefix/eg;
    s/\@\@OPTDEBUG\@\@/$optdebug/eg;
    s/\@\@CMAFIHE_LDOPTS\@\@/$cmafihe_ldopts/eg;
    s/\@\@DEFINES\@\@/$defines/eg;
    s/\@\@DICTDATA_C\@\@/$dictdata_c/eg;
    print OUT;
}
close(IN);
close(OUT);


sub print_help {

    print <<EOF;
Configuration script for jbofihe & friends

--prefix=<prefix>    Set installation directory parent (default=/usr/local)
-p <prefix>          Ditto
--profile            Build for profiling
--debug              Build a debuggable version
--nommap             Don't use mmap for reading the dictionary file
--embed              Embed minimal dictionary directly into jbofihe program
--plist              Enable PropList output of vocabulary in cmafihe (requires libPropList from http://www.windowmaker.org) 
EOF
}

