'\" t
.\" Manual page created with latex2man on Sat Apr 23 05:39:15 EDT 2011
.\" NOTE: This file is generated, DO NOT EDIT.
.de Vb
.ft CW
.nf
..
.de Ve
.ft R

.fi
..
.TH "JELLYFISH" "1" "2010/10/1" "k\-mer counter " "k\-mer counter "
.SH NAME

.PP
Jellyfish
is a software to count k\-mers in DNA sequences. 
.PP
.SH SYNOPSIS

jellyfish count
[\fB\-o\fP\fIprefix\fP]
[\fB\-m\fP\fImerlength\fP]
[\fB\-t\fP\fIthreads\fP]
[\fB\-s\fP\fIhashsize\fP]
[\fB--both\-strands\fP]
\fIfasta\fP
[\fIfasta \&...
\fP]
.br
jellyfish merge
\fIhash1\fP
\fIhash2\fP
\&...
.br
jellyfish dump
\fIhash\fP
.br
jellyfish stats
\fIhash\fP
.br
jellyfish histo
[\fB\-h\fP\fIhigh\fP]
[\fB\-l\fP\fIlow\fP]
[\fB\-i\fP\fIincrement\fP]
\fIhash\fP
.br
jellyfish query
\fIhash\fP
.PP
.SH DESCRIPTION

.PP
Jellyfish
is a k\-mer counter based on a multi\-threaded hash 
table implementation. 
.PP
To count k\-mers, use a command like: 
.PP
.Vb
jellyfish count \-m 22 \-o output \-c 3 \-s 10000000 \-t 32 input.fasta
.Ve
.PP
This will count the the 22\-mers in species.fasta with 32 threads. The 
counter field in the hash uses only 3 bits and the hash has at least 
10 million entries. Let the size of the table be s=2^l and the max 
reprobe value is less than 2^r, then the memory usage per entry in 
the hash is (in bits, not bytes) 2k\-l+r+1\&. 
.PP
To save space, the hash table supports variable length counter, i.e. a 
k\-mer occurring only a few times will use a small counter, a k\-mer 
occurring many times will used multiple entries in the hash. The 
\fB\-c\fP
specify the length of the small counter. The tradeoff is: a 
low value will save space per entry in the hash but will increase the 
number of entries used, hence maybe requiring a larger hash. In 
practice, use a value for \fB\-c\fP
so that most of you k\-mers 
require only 1 entry. For example, to count k\-mers in a genome, 
where most of the sequence is unique, use \fB\-c\fP\fI1\fP
or 
\fB\-c\fP\fI2\fP\&.
For sequencing reads, use a value for 
\fB\-c\fP
large enough to counts up to twice the coverage. 
.PP
When the orientation of the sequences in the input fasta file is not 
known, e.g. in sequencing reads, using \fB--both\-strands\fP
(\fB\-C\fP)
makes the most sense. 
.PP
The following subcommand are used to look at the result: histo, dump, stats. 
.PP
.SH OPTIONS

.SS COUNT
.PP
Count k\-mers or qmers in fasta or fastq files 
.PP
Usage: jellyfish count [OPTIONS]... [file.f[aq]]... 
.PP
.TP
\fB\-h\fP,\fB--help\fP
 Print help and exit 
.TP
\fB--full\-help\fP
 Print help, including hidden options, and exit 
.TP
\fB\-V\fP,\fB--version\fP
 Print version and exit 
.TP
\fB\-m\fP,
\fB--mer\-len\fP\fI=INT\fP
 Length of mer (mandatory) 
.TP
\fB\-s\fP,
\fB--size\fP\fI=LONG\fP
 Hash size (mandatory) 
.TP
\fB\-t\fP,
\fB--threads\fP\fI=INT\fP
 Number of threads (default=1) 
.TP
\fB\-o\fP,
\fB--output\fP\fI=STRING\fP
 Output prefix (default=mer_counts) 
.TP
\fB\-c\fP,
\fB--counter\-len\fP\fI=Length\fP
 in bits 
Length of counting field (default=7) 
.TP
\fB--out\-counter\-len\fP\fI=Length\fP
 in bytes 
Length of counter field in output 
(default=4) 
.TP
\fB\-C\fP,\fB--both\-strands\fP
 Count both strand, canonical representation 
(default=off) 
.TP
\fB\-p\fP,
\fB--reprobes\fP\fI=INT\fP
 Maximum number of reprobes (default=62) 
.TP
\fB\-r\fP,\fB--raw\fP
 Write raw database (default=off) 
.TP
\fB\-q\fP,\fB--quake\fP
 Quake compatibility mode (default=off) 
.TP
\fB--quality\-start\fP\fI=INT\fP
 Starting ASCII for quality values 
(default=64) 
.TP
\fB--min\-quality\fP\fI=INT\fP
 Minimum quality. A base with lesser quality 
becomes an N (default=0) 
.TP
\fB\-L\fP,
\fB--lower\-count\fP\fI=LONG\fP
 Don\&'t output k\-mer with count < lower\-count 
.TP
\fB\-U\fP,
\fB--upper\-count\fP\fI=LONG\fP
 Don\&'t output k\-mer with count > upper\-count 
.TP
\fB--matrix\fP\fI=Matrix\fP
 file Hash function binary matrix 
.TP
\fB--timing\fP\fI=Timing\fP
 file Print timing information 
.PP
.SS HISTO
.PP
Create an histogram of k\-mer occurrences 
.PP
Usage: jellyfish histo [OPTIONS]... [database.jf]... 
.PP
.TP
\fB--help\fP
 Print help and exit 
.TP
\fB\-V\fP,\fB--version\fP
 Print version and exit 
.TP
\fB\-s\fP,
\fB--buffer\-size\fP\fI=Buffer\fP
 length 
Length in bytes of input buffer 
(default=10000000) 
.TP
\fB\-l\fP,
\fB--low\fP\fI=LONG\fP
 Low count value of histogram (default=1) 
.TP
\fB\-h\fP,
\fB--high\fP\fI=LONG\fP
 High count value of histogram 
(default=10000) 
.TP
\fB\-i\fP,
\fB--increment\fP\fI=LONG\fP
 Increment value for buckets (default=1) 
.TP
\fB\-t\fP,
\fB--threads\fP\fI=INT\fP
 Number of threads (default=1) 
.TP
\fB\-o\fP,
\fB--output\fP\fI=STRING\fP
 Output file (default=/dev/fd/1) 
.PP
.SS DUMP
.PP
Dump k\-mer counts 
.PP
Usage: jellyfish stats [OPTIONS]... [database.jf]... 
.PP
.TP
\fB\-h\fP,\fB--help\fP
 Print help and exit 
.TP
\fB\-V\fP,\fB--version\fP
 Print version and exit 
.TP
\fB\-c\fP,\fB--column\fP
 Column format (default=off) 
.TP
\fB\-t\fP,\fB--tab\fP
 Tab separator (default=off) 
.TP
\fB\-L\fP,
\fB--lower\-count\fP\fI=LONG\fP
 Don\&'t output k\-mer with count < lower\-count 
.TP
\fB\-U\fP,
\fB--upper\-count\fP\fI=LONG\fP
 Don\&'t output k\-mer with count > upper\-count 
.TP
\fB\-o\fP,
\fB--output\fP\fI=STRING\fP
 Output file (default=/dev/fd/1) 
.PP
.SS STATS
.PP
Statistics 
.PP
Usage: jellyfish stats [OPTIONS]... [database.jf]... 
.PP
.TP
\fB\-h\fP,\fB--help\fP
 Print help and exit 
.TP
\fB--full\-help\fP
 Print help, including hidden options, and exit 
.TP
\fB\-V\fP,\fB--version\fP
 Print version and exit 
.TP
\fB\-L\fP,
\fB--lower\-count\fP\fI=LONG\fP
 Don\&'t output k\-mer with count < lower\-count 
.TP
\fB\-U\fP,
\fB--upper\-count\fP\fI=LONG\fP
 Don\&'t output k\-mer with count > upper\-count 
.TP
\fB\-v\fP,\fB--verbose\fP
 Verbose (default=off) 
.TP
\fB\-o\fP,
\fB--output\fP\fI=STRING\fP
 Output file (default=/dev/fd/1) 
.PP
.SS MERGE
.PP
Merge jellyfish databases 
.PP
Usage: jellyfish merge [OPTIONS]... [database.jf]... 
.PP
.TP
\fB\-h\fP,\fB--help\fP
 Print help and exit 
.TP
\fB\-V\fP,\fB--version\fP
 Print version and exit 
.TP
\fB\-s\fP,
\fB--buffer\-size\fP\fI=Buffer\fP
 length 
Length in bytes of input buffer 
(default=10000000) 
.TP
\fB\-o\fP,
\fB--output\fP\fI=STRING\fP
 Output file (default=mer_counts_merged.jf) 
.TP
\fB--out\-counter\-len\fP\fI=INT\fP
 Length (in bytes) of counting field in output 
(default=4) 
.TP
\fB--out\-buffer\-size\fP\fI=LONG\fP
 Size of output buffer per thread 
(default=10000000) 
.TP
\fB\-v\fP,\fB--verbose\fP
 Be verbose (default=off) 
.PP
.SS CITE
.PP
How to cite Jellyfish\&'s paper 
.PP
Usage: jellyfish cite [OPTIONS]... 
.PP
.TP
\fB\-h\fP,\fB--help\fP
 Print help and exit 
.TP
\fB\-V\fP,\fB--version\fP
 Print version and exit 
.TP
\fB\-b\fP,\fB--bibtex\fP
 Bibtex format (default=off) 
.TP
\fB\-o\fP,
\fB--output\fP\fI=STRING\fP
 Output file (default=/dev/fd/1) 
.PP
.SH VERSION

.PP
Version: 1.1 of 2010/10/1
.PP
.SH BUGS

.PP
.TP
.B *
jellyfish merge has not been parallelized and is very
slow. 
.PP
.SH COPYRIGHT & LICENSE

.TP
Copyright 
(C)2010, Guillaume Marcais \fBguillaume@marcais.net\fP
and Carl Kingsford \fBcarlk@umiacs.umd.edu\fP\&.
.PP
.TP
License 
This program is free software: you can redistribute it 
and/or modify it under the terms of the GNU General Public License 
as published by the Free Software Foundation, either version 3 of 
the License, or (at your option) any later version. 
.br
This program is distributed in the hope that it will be useful, but 
WITHOUT ANY WARRANTY; without even the implied warranty of 
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU 
General Public License for more details. 
.br
You should have received a copy of the GNU General Public License 
along with this program. If not, see 
<\fBhttp://www.gnu.org/licenses/\fP>.
.PP
.SH AUTHORS

Guillaume Marcais 
.br
University of Maryland 
.br
\fBgmarcais@umd.edu\fP
.PP
Carl Kingsford 
.br
University of Maryland 
.br
\fBcarlk@umiacs.umd.edu\fP
.PP
.\" NOTE: This file is generated, DO NOT EDIT.
