#include "sdl_glue.h"

wchar_t* do_sdlerror() {
  return KSTRING(SDL_GetError());
}

void sdl_init() {
  SDL_Init(SDL_INIT_TIMER | SDL_INIT_AUDIO | SDL_INIT_VIDEO);
  SDL_EnableUNICODE(1);
}

void* do_newsurface(void* vmptr, kint x, kint y, kint bpp, kint flags) {
  VMState* vm = (VMState*) vmptr;
  int sdlflags = (flags*SDL_FULLSCREEN)|SDL_HWSURFACE|SDL_DOUBLEBUF;
  SDL_Surface* s = SDL_SetVideoMode(x,y,bpp,sdlflags);
  if (s == NULL) {
    vm->kaya_internalError(1);
  }
  return (void*)s;
}

void* do_loadsurface(void* vmptr, wchar_t* rawfn) {
  char* fn = CSTRING(rawfn);
  VMState* vm = (VMState*) vmptr;
  SDL_Surface* s = SDL_LoadBMP(fn);
  if (s == NULL) {
    vm->kaya_internalError(1);
  }
  return (void*)s;
} 

void do_sdlflip(void* screen) {
  SDL_Surface* s = (SDL_Surface*)screen;
  SDL_Flip(s);
}

int do_sdlblit(void* srcptr, void* destptr, 
		kint sl, kint st, kint sw, kint sh,
		kint dl, kint dt, kint dw, kint dh) {
  SDL_Surface* src = (SDL_Surface*)srcptr;
  SDL_Surface* dest = (SDL_Surface*)destptr;
  SDL_Rect srcrect = {sl,st,sw,sh};
  SDL_Rect destrect = {dl,dt,dw,dh};
  return SDL_BlitSurface(src,&srcrect,dest,&destrect);
}

void* do_waitevent() {
  SDL_Event* event = (SDL_Event*)GC_MALLOC(sizeof(SDL_Event));
  int r = SDL_WaitEvent(event);
  return (void*)event;
}

kint event_type(void* eptr) {
  SDL_Event* e = (SDL_Event*)eptr;
  switch(e->type) {
  case SDL_KEYDOWN: return 1;
    //  case SDL_KEYUP: return 2;
  case SDL_MOUSEMOTION: return 3;
  case SDL_MOUSEBUTTONDOWN: return 4;
    //  case SDL_MOUSEBUTTONUP: return 5;
  case SDL_QUIT: return 6;
  }
  return 0;
}

kint do_getkeymod(void* eptr) {
  SDL_Event* e = (SDL_Event*)eptr;
  SDLMod m = e->key.keysym.mod;
  kint r = 0;
  if (m & KMOD_SHIFT) r+=1;
  if (m & KMOD_CTRL) r+=2;
  if (m & KMOD_ALT) r+=4;
  if (m & KMOD_META) r+=8;
  return r;
}

kint do_getkeynum(void* eptr) {
  SDL_Event* e = (SDL_Event*)eptr;
  switch (e->key.keysym.sym) {
  case SDLK_KP1: return -1;
  case SDLK_KP2: return -2;
  case SDLK_KP3: return -3;
  case SDLK_KP4: return -4;
  case SDLK_KP5: return -5;
  case SDLK_KP6: return -6;
  case SDLK_KP7: return -7;
  case SDLK_KP8: return -8;
  case SDLK_KP9: return -9;
  case SDLK_KP0: return -10;
  case SDLK_UP: return -11;
  case SDLK_DOWN: return -12;
  case SDLK_LEFT: return -13;
  case SDLK_RIGHT: return -14;
  case SDLK_INSERT: return -15;
  case SDLK_HOME: return -16;
  case SDLK_END: return -17;
  case SDLK_PAGEUP: return -18;
  case SDLK_PAGEDOWN: return -19;
    // no -20 yet
  case SDLK_F1: return -21;
  case SDLK_F2: return -22;
  case SDLK_F3: return -23;
  case SDLK_F4: return -24;
  case SDLK_F5: return -25;
  case SDLK_F6: return -26;
  case SDLK_F7: return -27;
  case SDLK_F8: return -28;
  case SDLK_F9: return -29;
  case SDLK_F10: return -30;
  case SDLK_F11: return -31;
  case SDLK_F12: return -32;
    // reserved until -40
  }  
  return (kint)e->key.keysym.unicode;
}

kint do_getmmx(void* eptr) {
  SDL_Event* e = (SDL_Event*)eptr;
  return (kint)e->motion.x;
}

kint do_getmmy(void* eptr) {
  SDL_Event* e = (SDL_Event*)eptr;
  return (kint)e->motion.y;
}

kint do_getmpx(void* eptr) {
  SDL_Event* e = (SDL_Event*)eptr;
  return (kint)e->button.x;
}

kint do_getmpy(void* eptr) {
  SDL_Event* e = (SDL_Event*)eptr;
  return (kint)e->button.y;
}

kint do_getmbp(void* eptr) {
  SDL_Event* e = (SDL_Event*)eptr;
  return (kint)e->button.button;
}

void do_setwmtitles(wchar_t* window, wchar_t* icon) {
  SDL_WM_SetCaption(CSTRING(window),CSTRING(icon));
}

void do_sdltransparency(void* sptr, kint r, kint g, kint b, kint a) {
  SDL_Surface* s = (SDL_Surface*)sptr;
  Uint8 rv = (Uint8)r;
  Uint8 gv = (Uint8)g;
  Uint8 bv = (Uint8)b;
  Uint8 av = (Uint8)a;
  Uint32 key = SDL_MapRGB(s->format,rv,gv,bv);
  // slightly annoying to need to do this, since if SDL change their pixel
  // format it will hurt...
  key = key | (av<<24);
  //  cout << key << endl;
  //  SDL_SetAlpha(s,0,SDL_ALPHA_OPAQUE);
  SDL_SetColorKey(s,SDL_SRCCOLORKEY,key);
}

void do_drawrect(void* sptr, 
		 kint l, kint t, kint w, kint h,
		 kint r, kint g, kint b, kint a) {
  SDL_Surface* s = (SDL_Surface*)sptr;
  Uint8 rv = (Uint8)r;
  Uint8 gv = (Uint8)g;
  Uint8 bv = (Uint8)b;
  Uint8 av = (Uint8)a;
  Uint32 colour = SDL_MapRGB(s->format,rv,gv,bv);
  SDL_Rect rect = {l,t,w,h};
  SDL_FillRect(s,&rect,colour);
}

void do_seticon(void* sptr) {
  SDL_Surface* icon = (SDL_Surface*) sptr;
  SDL_WM_SetIcon(icon,NULL);
}
