/***************************************************************************
                          workedcalls  -  description
                             -------------------
    begin                : mar ago 17 2004
    copyright            : (C) 2004 by Jaime Robles
    email                : jaime@kde.org
 ***************************************************************************/

/******************************************************************************
 *                                                                            *
 *   This program is free software; you can redistribute it and/or modify     *
*  it under the terms of the GNU General Public License as published by     *
*  the Free Software Foundation; either version 2 of the License, or        *
*  (at your option) any later version.                                      *
 *                                                                            *
*  This program is distributed in the hope that it will be useful,          *
*  but WITHOUT ANY WARRANTY; without even the implied warranty of           *
*  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the            *
*  GNU General Public License for more details.                             *
 *                                                                            *
*  You should have received a copy of the GNU General Public License        *
*  along with this program; if not, write to the Free Software              *
*  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA*
 *****************************************************************************/ 
#ifndef WORKEDCALLS_H
#define WORKEDCALLS_H
#include <qvaluelist.h>
#include <qstring.h>
#include "calls.h"
/* IMPORTANT NOTE !!
  Maybe just a table with a CALL <-> "array of numbers" with the QSOs of
  the calls would be OK instead of saving all the data related to every
  call.
  Maybe I should optimize this in order to save memory when executing.
*/


class WorkedCalls{
public:

	WorkedCalls();
	~WorkedCalls();
	void addCallToWorkedCalls(const QString& tqrz, int tnum);
	int getWorked(const QString& workedCall);
	bool isThisCallWorked(const QString& workedCall);

private:
	typedef QValueList<Calls> TheWorkedCalls;
	TheWorkedCalls workedCalls;

	Calls call;
	QString  callString;

};
#endif


