#ifndef __CLIENTWCLASS
#define __CLIENTWCLASS

class QToolBar;
class QFrame;
class QKeyEvent;
class QPaintEvent;
class QScrollBar;
class QRect;
class MainWidget;
class NetWidget;
class QMainWindow;

//************ class *************
class ClientW : public QFrame
{	Q_OBJECT
public:
	ClientW(MainWidget *, const QString& sFile);
	ClientW(MainWidget *, Circuit *);
	ClientW(QFrame *, int);
	~ClientW();

	NetWidget *net();
	void show();
	void closeEvent(QCloseEvent *);

public slots:
	void hScroll(int);
	void vScroll(int);
	void up();
	void netChange(int);
	void autoMove(const QPoint&);

private:
	void initFrame();
	void initPosition();
	void keyPressEvent(QKeyEvent *);
	void paintEvent(QPaintEvent *);
	void setWidgets();

	bool m_bIsClient;	// not the main window?

	QScrollBar *m_poHScroll;
	QScrollBar *m_poVScroll;

	QFrame *m_poCircuitFrame;
	NetWidget *m_poCircuitWidget;
	MainWidget *m_poMainWidget;
	QToolBar *m_poToolbar;
	QRect m_oBorder;
	QRect m_oCircuitPos;
	Circuit *m_poCircuit;
};
#endif
