#ifndef __DEVICE_TEXT__
#define __DEVICE_TEXT__

#include <qpainter.h>
#include "xdevice.h"

class TextDevice : public XDevice
{
public:
	TextDevice(const QPoint& oPos, int iSize = -1)
		: XDevice(DeviceType::fTXT, oPos, iSize)
	{
		m_poImage = new Image(1,1);
	}

	virtual ~TextDevice()
	{
		delete m_poImage;
	}

	virtual void init()
	{
		deviceOutputInverted = false;
		setSize(Global::Device::MINSIZE);
		deviceMaxInput = 0;
		deviceMaxOutput = 0;
		hasInputRegion(false);
		hasOutputRegion(false);
		XDevice::init();
	}

	virtual void setEquation()
	{
		Device::setEquation(Operator::NONE);
	}

	virtual void displayName(bool)
	{
	}

	virtual void setName(const QString& sName)
	{
		XDevice::setName(sName);
		setImage();
	}

	virtual bool sizeChangeable() const
	{
		return false;
	}

	virtual void setImage()
	{
		setVOffset(-3);

		QPainter p;
		p.begin(m_poImage);
		p.setFont(Global::Device::getFont());
		QRect r = p.boundingRect(1000, 1000, 1000, 1000, Qt::AlignLeft, getName());
		p.end();

		if (r.width() < 1) r.setWidth(10);
		if (r.height() < 1) r.setHeight(8);
		m_poImage->resize(r.width() + 4, r.height());

		p.begin(m_poImage);
		p.setBrush(Qt::white);
		p.setPen(Qt::black);
		p.drawRect(m_poImage->rect());
		p.setFont(Global::Device::getFont());
		p.drawText(3, m_poImage->height() - 2, getName());
		p.end();

		XObject::setImage(m_poImage);
	}

	virtual void printImage(QPainter *, const QRect &)
	{
	}

	// return device's output value
	virtual int output(int)
	{
		return 0;
	}

	virtual bool outputChanged()
	{
		return 0;
	}

	virtual void Calculate(int)
	{
	}

	virtual void Propagate(int)
	{
	}
private:
	Image *m_poImage;
};

#endif
