#include <pthread.h>
#include <stdlib.h>
#include <string.h>
#include "clickmodes.h"
#include "buffer.h"
#include "vinyl.h"
#include "cd.h"

speciallist_t* clickmodes_create(long rate){
	speciallist_t *sl = speciallist_new();
	buffer_info_t *buf = buffer_new (0, rate);

	buf->chunk_list[0]->readfc = &vinyl;
	buf->pending = BUFFER_STATUS_READY;
	/* LATER: deal with samplerates correctly */
        buf->samplerate_factor = 44100 / (float)rate;
	buffer_set_shortname(buf,"vinyl click");
	speciallist_append (sl,buf);

	buf = buffer_new (0, rate);
        buf->chunk_list[0]->readfc = &cd;
        buf->pending = BUFFER_STATUS_READY;
        /* LATER: deal with samplerates correctly */
        buf->samplerate_factor = 44100 / (float)rate;
        buffer_set_shortname(buf,"cd click");
        speciallist_append (sl,buf);

	return sl;
}

void clickmodes_free(speciallist_t *sl){
	buffer_info_t *buf;
	buffer_info_t *tmp;

	if (sl){
		buf = speciallist_get_first(sl);
		while (buf){
			tmp = buf;
			buf = speciallist_get_next(sl,tmp);
			buffer_delete(tmp);
		}
	}
	sl = NULL;
}

