//
// C++ Interface: 
//
// Description: 
//
//
// Author: Christian Hubinger <chubinger@irrsinnig.org>, (C) 2006
//
// Copyright: See COPYING file that comes with this distribution
//
//

#ifndef KMFHOSTWIDGET_H
#define KMFHOSTWIDGET_H

#include "kmyfirewallhostwidget.h"

#include <qwidget.h>
#include <kdialogbase.h>
#include <kconfig.h>
#include <kglobal.h>
#include <kprocess.h>
#include <qstring.h>
#include <qpixmap.h>
#include <qguardedptr.h>

namespace KMF {
class KMFTarget;

class KMFHostWidget : public KMyFirewallHostWidget
{
  Q_OBJECT

public:
	KMFHostWidget(QWidget* parent = 0, const char* name = 0, WFlags fl = 0 );
  ~KMFHostWidget();
  /*$PUBLIC_FUNCTIONS$*/
  void loadHost( KMFTarget *target );	
  void InitGUI();
  
public slots:
  /*$PUBLIC_SLOTS$*/

	
protected:
  /*$PROTECTED_FUNCTIONS$*/
	void updateView();
	
protected slots:
  /*$PROTECTED_SLOTS$*/
	void slotAddressChanged( int );
	void slotSSHPortChanged( int );
	void slotOSChanged( const QString& );
	void slotBackaendChanged( const QString& );
	void slotDescriptionChanged();
	void slotTestConnection();
	void slotTryAutoConfiguration();
	void slotTryAutoConfiguration_Callback( KMFTarget* );
	signals:
		void sigTargetChanged();
	
	
private:
	QGuardedPtr<KMFTarget> m_target;

};
}
#endif

