/***************************************************************************
                          kpreglistbox.cpp  -  description
                             -------------------
    begin                : Sun Aug 12 2001
    copyright          : (C) 2001-2003 by Huberto Gastal Mayer
    email                : beto@debian-rs.org
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can red_typeistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include "kpreglistbox.h"
#include <kiconloader.h>
#include <klocale.h>

KpregListBox::KpregListBox(QWidget *parent, const char *name) : QWidget(parent, name){
	qlb = new QListBox ( this, "qlb");
	subMenu = new KPopupMenu();
	categoryLabel = new QString ( name );
	categoryIcon = new QString ();
	qcb = KApplication::clipboard();
	connect( qlb, SIGNAL( highlighted(int) ), this, SLOT( clicked_list_box(int) ) );
	connect( qlb, SIGNAL( pressed(QListBoxItem*) ), this, SLOT( startDrag() ) );
	connect( subMenu, SIGNAL( activated (int) ), this, SLOT( clicked_sub_menu (int) ) );
}

KpregListBox::~KpregListBox()
{
}

void KpregListBox::resizeEvent ( QResizeEvent * newSize )
{
	qlb ->resize( newSize->size().width() - 5, newSize->size().height() );
}

void KpregListBox::setParentWidgets ( QTabWidget * _qtw,  KPopupMenu *_hierMenu)
{
	qtw = _qtw;
	hierMenu = _hierMenu;
}

void KpregListBox::atualizeViewCategory()
{
	KIconLoader kil;
	qtw->changeTab ( this, QIconSet (QPixmap(kil . loadIcon( *categoryIcon, KIcon::Toolbar ))), *categoryLabel  );
	hierMenu->changeItem (hierMenu->idAt (qtw->currentPageIndex()+5), QPixmap(kil . loadIcon( *categoryIcon, KIcon::Toolbar )), *categoryLabel);
}

void KpregListBox::setItens (QDomNode itensNode){

	QDomNodeList itensList = itensNode . childNodes ();
	int a = itensList . length ();
	for ( int b=0; b < a; b++ ) {
		setNewItem ( itensList.item(b) );
	}

}

void KpregListBox::deleteItem ()
{
	subMenu->removeItemAt ( qlb->currentItem() );
	kpi_list . remove ( qlb->currentItem() );
	qlb->removeItem ( qlb->currentItem () );
}

void KpregListBox::moveUp ()
{
	if (qlb->currentItem () != 0 ) {
		KpregItem *item1, *item2;
		int pos1, pos2;
		item1 = kpi_list . at(qlb->currentItem());
		pos1 = kpi_list . at();
		item2 = kpi_list . prev();
		pos2 = kpi_list . at();
		kpi_list . replace(pos1, item2);
		kpi_list . replace(pos2, item1);
		qlb->changeItem  ( *kpi_list . at(pos1)->getIcon(), kpi_list . at(pos1)->getViewItem(), qlb->currentItem () );
		subMenu->changeItem  ( subMenu->idAt(qlb->currentItem()), *kpi_list . at(pos1)->getIcon(), kpi_list . at(pos1)->getViewItem() );
		qlb->changeItem  ( *kpi_list . at(pos2)->getIcon(), kpi_list . at(pos2)->getViewItem(), qlb->currentItem ()-1 );
		subMenu->changeItem  ( subMenu->idAt(qlb->currentItem()), *kpi_list . at(pos2)->getIcon(), kpi_list . at(pos2)->getViewItem() );
	}
}

void KpregListBox::moveDown ()
{
	if ( qlb->currentItem () != (qlb->numItemsVisible () -1 ) ) {
		KpregItem *item1, *item2;
		int pos1, pos2;
		item1 = kpi_list . at(qlb->currentItem());
		pos1 = kpi_list . at();
		item2 = kpi_list . next();
		pos2 = kpi_list . at();
		kpi_list . replace(pos2, item1);
		kpi_list . replace(pos1, item2);
		qlb->changeItem  ( *kpi_list . at(pos1)->getIcon(), kpi_list . at(pos1)->getViewItem(), qlb->currentItem () );
		subMenu->changeItem  ( subMenu->idAt(qlb->currentItem()), *kpi_list . at(pos1)->getIcon(), kpi_list . at(pos1)->getViewItem() );
		qlb->changeItem  ( *kpi_list . at(pos2)->getIcon(), kpi_list . at(pos2)->getViewItem(), qlb->currentItem ()+1 );
		subMenu->changeItem  ( subMenu->idAt(qlb->currentItem()), *kpi_list . at(pos2)->getIcon(), kpi_list . at(pos2)->getViewItem() );
	}
}

void KpregListBox::clicked_list_box (int item_int)
{
	qcb->setSelectionMode( true );
	qcb->setText(kpi_list . at(item_int)->getContent());
}

void KpregListBox::clicked_sub_menu (int item_int)
{
	qcb->setSelectionMode( true );
	qcb->setText(kpi_list . at( subMenu->indexOf(item_int) )->getContent());
}

void KpregListBox::setNewItem (QDomDocument item) //obsoleto
{
	QDomNodeList tabList = item . elementsByTagName ( "item" );
	setNewItem(tabList.item(0));
}

void KpregListBox::setNewItem (QDomNode itemNode)
{
	QDomNode titleNode = itemNode . namedItem("title");
	QDomNode contentNode = itemNode . namedItem("content");

	QDomElement itemElem = itemNode . toElement ();
	QDomAttr typeAttr = itemElem . attributeNode ("type");
	QDomAttr posAttr = itemElem . attributeNode ("pos");
	QDomElement titleElem = titleNode . toElement();
	QDomElement contentElem = contentNode . toElement ();

	if ( posAttr.value() == "end" or posAttr.value() == "" ) {
		kpi_list . append( new KpregItem( titleElem.text(), contentElem.text(),  typeAttr.value(), qlb, subMenu, blue_pm, yellow_pm, red_pm) );
		qlb->insertItem  ( *kpi_list . current ()->getIcon(), kpi_list . current ()->getViewItem() );
		subMenu->insertItem( *kpi_list . current ()->getIcon(), kpi_list . current ()->getViewItem() );
//		kpi_list . current() -> setIndex (qlb->count() - 1);
	} else { // this "else" is for speed up in application start
		if ( posAttr.value() == "begin" ) {
			kpi_list . prepend( new KpregItem( titleElem.text(), contentElem.text(),  typeAttr.value(), qlb, subMenu, blue_pm, yellow_pm, red_pm) );
			qlb->insertItem  ( *kpi_list . current ()->getIcon(), kpi_list . current ()->getViewItem(), 0 );
			subMenu->insertItem( *kpi_list . current ()->getIcon(), kpi_list . current ()->getViewItem(), 0, 0 );
//			kpi_list . current() -> setIndex (0);   //
		}
		if ( posAttr.value() == "up" ) {
			kpi_list . insert ( kpi_list . find(getCurrentItem()), new KpregItem( titleElem.text(), contentElem.text(),  typeAttr.value(), qlb, subMenu, blue_pm, yellow_pm, red_pm) );
			qlb->insertItem  ( *kpi_list . current ()->getIcon(), kpi_list . current ()->getViewItem(), qlb->currentItem() );
			subMenu->insertItem( *kpi_list . current ()->getIcon(), kpi_list . current ()->getViewItem(), 0, qlb->currentItem() - 1 );
//			kpi_list . current() -> setIndex (qlb->currentItem());     //
		}
		if ( posAttr.value() == "down" ) {
			kpi_list . insert ( kpi_list . find(getCurrentItem()) + 1, new KpregItem( titleElem.text(), contentElem.text(),  typeAttr.value(), qlb, subMenu, blue_pm, yellow_pm, red_pm) );
			qlb->insertItem  ( *kpi_list . current ()->getIcon(), kpi_list . current ()->getViewItem(), qlb->currentItem() + 1 );
			subMenu->insertItem( *kpi_list . current ()->getIcon(), kpi_list . current ()->getViewItem(), 0, qlb->currentItem() + 1 );
//			kpi_list . current() -> setIndex (qlb->currentItem() + 1);      //
		}
	}
}

void  KpregListBox::setIcons (QPixmap *_blue_type, QPixmap *_yellow_type, QPixmap *_red_type){
	blue_pm = _blue_type;
	yellow_pm = _yellow_type;
	red_pm = _red_type;
}

QDomDocumentFragment KpregListBox::save (QDomDocument qdd) {
	QDomDocumentFragment fragment  = qdd. createDocumentFragment ();

	for ( kpi_list . first ();  kpi_list . current() != 0;  kpi_list . next () ) {
		fragment . appendChild ( kpi_list . current()->save(qdd) );
	}
	return fragment;
}

KpregItem* KpregListBox::getCurrentItem ()
{
	if ( qlb->currentItem () == -1 ) {
		qlb -> setSelected ( 0, true );
		return kpi_list . first();
	} else {
		kpi_list . current() -> setMenuId (qlb->currentItem ());
		return kpi_list . at(qlb->currentItem());    //
	}
//	return kpi_list . first();  //warning!!!
}

void KpregListBox::setCategoryLabel (QString label)
{
	*categoryLabel = label;
}

QString KpregListBox::getCategoryLabel ()
{
	return  *categoryLabel;
}

void KpregListBox::setCategoryIcon (QString icon)
{
	*categoryIcon = icon;
}

QString KpregListBox::getCategoryIcon ()
{
	return  *categoryIcon;
}

void KpregListBox::clearItens ()
{
	kpi_list . clear ();
}

void KpregListBox::startDrag(){
	QDragObject *d = new QTextDrag( kpi_list.at(qlb->currentItem())->getContent(), this );
	d->dragCopy();
}

