/***************************************************************************
                          appearencedlg.cpp  -  description
                             -------------------
    begin                : Fri Sep 29 2000
    copyright            : (C) 2000 by Luc Langehegermann
    email                : lx2gt@users.sourceforge.net
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include "appearencedlg.h"
#include <stdio.h>
#include <qgroupbox.h>
#include <qlayout.h>
#include <qlabel.h>
#include <qfontdialog.h>
#include <kfontdialog.h>
#include <klocale.h>
#include "globals.h"

appearenceDlg::appearenceDlg(QWidget *parent)
							: KDialogBase(parent, "appearenceDlg", true, i18n("Appearance"), Ok|Cancel, Ok, true)
{
	setWFlags (WDestructiveClose);
	newRxFont=config.screen.rxwinfont;
	newTxFont=config.screen.txwinfont;

	QGroupBox* grpbox;
	QWidget* w;
	QLabel* l;
	QVBoxLayout* vbox;
	QGridLayout* grid;

	w = new QWidget (this);
	setMainWidget (w);

	vbox = new QVBoxLayout (w,0,5);
	grpbox = new QGroupBox (w);
	grpbox->setTitle (i18n ("Fonts"));
	vbox->addWidget (grpbox);

	grid = new QGridLayout (grpbox, 3, 2, 5, 5);
	grid->addRowSpacing (0,10);
  l = new QLabel (grpbox);
	l->setText (i18n ("TX-Win Font:"));
	grid->addWidget (l, 1, 0, Qt::AlignRight);

	txFontButton = new QPushButton (grpbox);
	txFontButton->setFont (newTxFont);
	txFontButton->setText (getFontString (newTxFont));
	QObject::connect (txFontButton, SIGNAL (clicked()), this, SLOT (slottxFontButtonClicked()));

	grid->addWidget (txFontButton, 1, 1);

  l = new QLabel (grpbox);
  l->setText (i18n ("RX-Win Font:"));
  grid->addWidget (l, 2, 0, Qt::AlignRight);

	rxFontButton = new QPushButton (grpbox);
	rxFontButton->setFont (config.screen.rxwinfont);
	rxFontButton->setText (getFontString (config.screen.rxwinfont));
	QObject::connect (rxFontButton, SIGNAL (clicked()), this, SLOT (slotrxFontButtonClicked()));
 	grid->addWidget (rxFontButton, 2, 1);

  grpbox = new QGroupBox (w);
  grpbox -> setTitle (i18n ("Window Colors"));
  vbox->addWidget (grpbox);
  grid = new QGridLayout (grpbox, 3,2,5,5);
  grid->addRowSpacing (0,10);

  l = new QLabel (grpbox);
  l ->setText (i18n ("RX Font Color"));
  grid -> addWidget (l,1,0,Qt::AlignRight);

  rxColorButton = new KColorButton (grpbox);
  rxColorButton ->setColor (config.rxwincolor.rx);
  grid->addWidget (rxColorButton,1,1);

  l = new QLabel (grpbox);
  l ->setText (i18n ("RX Background"));
  grid -> addWidget (l,2,0,Qt::AlignRight);

  rxbColorButton = new KColorButton (grpbox);
  rxbColorButton ->setColor (config.bkground.rxb);
  grid->addWidget (rxbColorButton,2,1);

  l = new QLabel (grpbox);
  l ->setText (i18n ("TX Font Color"));
  grid -> addWidget (l,3,0,Qt::AlignRight);

  txColorButton = new KColorButton (grpbox);
  txColorButton ->setColor (config.rxwincolor.tx);
  grid->addWidget (txColorButton,3,1);

  l = new QLabel (grpbox);
  l ->setText (i18n ("TX Background"));
  grid -> addWidget (l,4,0,Qt::AlignRight);

  txbColorButton = new KColorButton (grpbox);
  txbColorButton ->setColor (config.bkground.txb);
  grid->addWidget (txbColorButton,4,1);

	grpbox = new QGroupBox (w);
	grpbox->setTitle (i18n ("Waterfall Colors"));
	vbox->addWidget (grpbox);
	grid = new QGridLayout (grpbox, 3, 2, 5, 5);
	grid->addRowSpacing (0,10);

  // radio button to set color or grayscale (default) waterfall
	colorWater = new QRadioButton("Color Waterfall", grpbox,0);
  grid->addWidget(colorWater,1,0,Qt::AlignRight);
  if (config.h2oColor.color_water){
     colorWater->setChecked(true);
   }
   else {
      colorWater->setChecked(false);
   }

  l = new QLabel (grpbox);
	l->setText (i18n ("Background Color:"));
	grid->addWidget (l, 2, 0, Qt::AlignRight);

	zeroh2oColorButton = new KColorButton (grpbox);
	zeroh2oColorButton->setColor (config.h2oColor.zero);
	grid->addWidget (zeroh2oColorButton, 2, 1);


	l = new QLabel (grpbox);
	l->setText (i18n ("Very Low Amplitude Color:"));
	grid->addWidget (l, 3, 0, Qt::AlignRight);

	vlowh2oColorButton = new KColorButton (grpbox);
	vlowh2oColorButton->setColor (config.h2oColor.vlow);
	grid->addWidget (vlowh2oColorButton, 3, 1);


	l = new QLabel (grpbox);
	l->setText (i18n ("Low Amplitude Color:"));
	grid->addWidget (l, 4, 0, Qt::AlignRight);

	lowh2oColorButton = new KColorButton (grpbox);
	lowh2oColorButton->setColor (config.h2oColor.low);
	grid->addWidget (lowh2oColorButton, 4, 1);


	l = new QLabel (grpbox);
	l->setText (i18n ("Mid Amplitude Color:"));
	grid->addWidget (l, 5, 0, Qt::AlignRight);

	midh2oColorButton = new KColorButton (grpbox);
	midh2oColorButton->setColor (config.h2oColor.mid);
	grid->addWidget (midh2oColorButton, 5, 1);


	l = new QLabel (grpbox);
	l->setText (i18n ("Mid High Amplitude Color:"));
	grid->addWidget (l, 6, 0, Qt::AlignRight);

	hmidh2oColorButton = new KColorButton (grpbox);
	hmidh2oColorButton->setColor (config.h2oColor.hmid);
	grid->addWidget (hmidh2oColorButton, 6, 1);


	l = new QLabel (grpbox);
	l->setText (i18n ("High Amplitude Color:"));
	grid->addWidget (l, 7, 0, Qt::AlignRight);

	highh2oColorButton = new KColorButton (grpbox);
	highh2oColorButton->setColor (config.h2oColor.high);
	grid->addWidget (highh2oColorButton, 7, 1);


	l = new QLabel (grpbox);
	l->setText (i18n ("Very High Amplitude Color:"));
	grid->addWidget (l, 8, 0, Qt::AlignRight);

	vhighh2oColorButton = new KColorButton (grpbox);
	vhighh2oColorButton->setColor (config.h2oColor.vhigh);
	grid->addWidget (vhighh2oColorButton, 8, 1);


}
appearenceDlg::~appearenceDlg()
{
}

QString appearenceDlg::getFontString (QFont f)
{
	QString str;
	str = f.family();
	str = str + ", " + QString::number (f.pointSize()) + i18n (" pt");
	return str;
}

void appearenceDlg::slotrxFontButtonClicked()
{
	QFont tmpfont;
	if (KFontDialog::getFont (tmpfont)) {
		newRxFont=tmpfont;
		rxFontButton->setFont (newRxFont);
		rxFontButton->setText (getFontString (newRxFont));
  	}
}

void appearenceDlg::slottxFontButtonClicked()
{
	QFont tmpfont;
	if (KFontDialog::getFont (tmpfont)) {
		newTxFont=tmpfont;
		txFontButton->setFont (newTxFont);
		txFontButton->setText (getFontString (newTxFont));
  	}
}


void appearenceDlg::slotOk()
{
	config.screen.rxwinfont=newRxFont;
	config.screen.txwinfont=newTxFont;
	config.rxwincolor.rx = rxColorButton->color();
	config.rxwincolor.tx = txColorButton->color();
  config.bkground.rxb = rxbColorButton->color();
	config.bkground.txb = txbColorButton->color();
	config.h2oColor.zero = zeroh2oColorButton->color();
	config.h2oColor.vlow = vlowh2oColorButton->color();
	config.h2oColor.low = lowh2oColorButton->color();
	config.h2oColor.mid = midh2oColorButton->color();
	config.h2oColor.hmid = hmidh2oColorButton->color();
	config.h2oColor.high = highh2oColorButton->color();
	config.h2oColor.vhigh = vhighh2oColorButton->color();
  if(colorWater-> isChecked()){
    config.h2oColor.color_water = true; //use color waterfall
   }
  else {
    config.h2oColor.color_water = false; // use grayscale waterfall
  }

	kpsk->reInit();
	KDialogBase::slotOk();
}
